/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.menu;

import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.Role;
import org.oddlama.vane.regions.region.RoleSetting;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.StorageUtil;

public class RoleMenu
extends ModuleComponent<Regions> {
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_delete_confirm_title;
    @LangMessage
    public TranslatedMessage lang_select_assign_player_title;
    @LangMessage
    public TranslatedMessage lang_select_remove_player_title;
    @LangMessage
    public TranslatedMessage lang_filter_players_title;
    public TranslatedItemStack<?> item_rename;
    public TranslatedItemStack<?> item_delete;
    public TranslatedItemStack<?> item_delete_confirm_accept;
    public TranslatedItemStack<?> item_delete_confirm_cancel;
    public TranslatedItemStack<?> item_assign_player;
    public TranslatedItemStack<?> item_remove_player;
    public TranslatedItemStack<?> item_select_player;
    public TranslatedItemStack<?> item_setting_toggle_on;
    public TranslatedItemStack<?> item_setting_toggle_off;
    public TranslatedItemStack<?> item_setting_info_admin;
    public TranslatedItemStack<?> item_setting_info_build;
    public TranslatedItemStack<?> item_setting_info_use;
    public TranslatedItemStack<?> item_setting_info_container;
    public TranslatedItemStack<?> item_setting_info_portal;

    public RoleMenu(Context<Regions> context) {
        super((Context)context.namespace("role"));
        Context ctx = this.get_context();
        this.item_rename = new TranslatedItemStack(ctx, "rename", Material.NAME_TAG, 1, "Used to rename the role.");
        this.item_delete = new TranslatedItemStack(ctx, "delete", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to delete this role.");
        this.item_delete_confirm_accept = new TranslatedItemStack(ctx, "delete_confirm_accept", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to confirm deleting the role.");
        this.item_delete_confirm_cancel = new TranslatedItemStack(ctx, "delete_confirm_cancel", Material.PRISMARINE_SHARD, 1, "Used to cancel deleting the role.");
        this.item_assign_player = new TranslatedItemStack(ctx, "assign_player", Material.PLAYER_HEAD, 1, "Used to assign players to this role.");
        this.item_remove_player = new TranslatedItemStack(ctx, "remove_player", Material.PLAYER_HEAD, 1, "Used to remove players from this role.");
        this.item_select_player = new TranslatedItemStack(ctx, "select_player", Material.PLAYER_HEAD, 1, "Used to represent a player in the role assignment/removal list.");
        this.item_setting_toggle_on = new TranslatedItemStack(ctx, "setting_toggle_on", Material.GREEN_TERRACOTTA, 1, "Used to represent a toggle button with current state on.");
        this.item_setting_toggle_off = new TranslatedItemStack(ctx, "setting_toggle_off", Material.RED_TERRACOTTA, 1, "Used to represent a toggle button with current state off.");
        this.item_setting_info_admin = new TranslatedItemStack(ctx, "setting_info_admin", Material.GOLDEN_APPLE, 1, "Used to represent the info for the admin setting.");
        this.item_setting_info_build = new TranslatedItemStack(ctx, "setting_info_build", Material.IRON_PICKAXE, 1, "Used to represent the info for the build setting.");
        this.item_setting_info_use = new TranslatedItemStack(ctx, "setting_info_use", Material.DARK_OAK_DOOR, 1, "Used to represent the info for the use setting.");
        this.item_setting_info_container = new TranslatedItemStack(ctx, "setting_info_container", Material.CHEST, 1, "Used to represent the info for the container setting.");
        this.item_setting_info_portal = new TranslatedItemStack(ctx, "setting_info_portal", Material.ENDER_PEARL, 1, "Used to represent the info for the portal setting.");
    }

    public Menu create(RegionGroup group, Role role, Player player) {
        boolean is_admin;
        int columns = 9;
        int rows = 3;
        Component title = this.lang_title.str_component(new Object[]{role.color() + "\u00a7l" + role.name()});
        Menu role_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)27, (Component)title));
        boolean bl = is_admin = player.getUniqueId().equals(group.owner()) || group.get_role(player.getUniqueId()).get_setting(RoleSetting.ADMIN);
        if (is_admin && role.role_type() == Role.RoleType.NORMAL) {
            role_menu.add(this.menu_item_rename(group, role));
            role_menu.add(this.menu_item_delete(group, role));
        }
        if (role.role_type() != Role.RoleType.OTHERS) {
            role_menu.add(this.menu_item_assign_player(group, role));
            role_menu.add(this.menu_item_remove_player(group, role));
        }
        this.add_menu_item_setting(role_menu, role, 0, this.item_setting_info_admin, RoleSetting.ADMIN);
        this.add_menu_item_setting(role_menu, role, 2, this.item_setting_info_build, RoleSetting.BUILD);
        this.add_menu_item_setting(role_menu, role, 4, this.item_setting_info_use, RoleSetting.USE);
        this.add_menu_item_setting(role_menu, role, 5, this.item_setting_info_container, RoleSetting.CONTAINER);
        if (((Regions)this.get_module()).vane_portals_available) {
            this.add_menu_item_setting(role_menu, role, 8, this.item_setting_info_portal, RoleSetting.PORTAL);
        }
        role_menu.on_natural_close((Consumer1 & Serializable)player2 -> ((Regions)this.get_module()).menus.region_group_menu.create(group, (Player)player2).open(player2));
        return role_menu;
    }

    private MenuWidget menu_item_rename(RegionGroup group, Role role) {
        return new MenuItem(0, this.item_rename.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).menus.enter_role_name_menu.create((Player)player, role.name(), (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                role.name((String)name);
                this.mark_persistent_storage_dirty();
                ((Regions)this.get_module()).menus.role_menu.create(group, role, (Player)player2).open(player2);
                return Menu.ClickResult.SUCCESS;
            }).on_natural_close((Consumer1 & Serializable)player2 -> ((Regions)this.get_module()).menus.role_menu.create(group, role, (Player)player2).open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_delete(RegionGroup group, Role role) {
        return new MenuItem(1, this.item_delete.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            MenuFactory.confirm((Context)this.get_context(), (String)this.lang_delete_confirm_title.str(new Object[0]), (ItemStack)this.item_delete_confirm_accept.item(new Object[0]), (Function1 & Serializable)player2 -> {
                group.remove_role(role.id());
                this.mark_persistent_storage_dirty();
                return Menu.ClickResult.SUCCESS;
            }, (ItemStack)this.item_delete_confirm_cancel.item(new Object[0]), (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_assign_player(RegionGroup group, Role role) {
        return new MenuItem(7, this.item_assign_player.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            List all_players = ((Regions)this.get_module()).get_offline_players_with_valid_name().stream().filter(p -> !role.id().equals(group.player_to_role().get(p.getUniqueId()))).sorted((a, b) -> {
                int c = Boolean.compare(b.isOnline(), a.isOnline());
                if (c != 0) {
                    return c;
                }
                return a.getName().compareToIgnoreCase(b.getName());
            }).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(p, str) -> p.getName().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_assign_player_title.str(new Object[0]), (String)this.lang_filter_players_title.str(new Object[0]), all_players, (Function1 & Serializable)p -> this.item_select_player.alternative(ItemUtil.skull_for_player((OfflinePlayer)p, (boolean)true), new Object[]{"\u00a7a\u00a7l" + p.getName()}), (Filter)filter, (Function3 & Serializable)(player2, m, p) -> {
                all_players.remove(p);
                m.update();
                group.player_to_role().put(p.getUniqueId(), role.id());
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_remove_player(RegionGroup group, Role role) {
        return new MenuItem(8, this.item_remove_player.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            List all_players = ((Regions)this.get_module()).get_offline_players_with_valid_name().stream().filter(p -> role.id().equals(group.player_to_role().get(p.getUniqueId()))).sorted((a, b) -> {
                int c = Boolean.compare(b.isOnline(), a.isOnline());
                if (c != 0) {
                    return c;
                }
                return a.getName().compareToIgnoreCase(b.getName());
            }).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(p, str) -> p.getName().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_remove_player_title.str(new Object[0]), (String)this.lang_filter_players_title.str(new Object[0]), all_players, (Function1 & Serializable)p -> this.item_select_player.alternative(ItemUtil.skull_for_player((OfflinePlayer)p, (boolean)true), new Object[]{"\u00a7a\u00a7l" + p.getName()}), (Filter)filter, (Function3 & Serializable)(player2, m, p) -> {
                all_players.remove(p);
                m.update();
                group.player_to_role().remove(p.getUniqueId());
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private void add_menu_item_setting(Menu role_menu, final Role role, int col, TranslatedItemStack<?> item_info, final RoleSetting setting) {
        role_menu.add((MenuWidget)new MenuItem(9 + col, item_info.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> Menu.ClickResult.IGNORE));
        role_menu.add((MenuWidget)new MenuItem(18 + col, null, (Function3 & Serializable)(player, menu, self) -> {
            if (setting.has_override()) {
                return Menu.ClickResult.ERROR;
            }
            if (setting == RoleSetting.ADMIN) {
                return Menu.ClickResult.ERROR;
            }
            role.settings().put(setting, !role.get_setting(setting));
            this.mark_persistent_storage_dirty();
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                Consumer<List> maybe_add_forced_hint = lore -> {
                    if (setting.has_override()) {
                        lore.add(Component.empty());
                        lore.add(Component.text((String)"FORCED BY SERVER"));
                    }
                };
                if (role.get_setting(setting)) {
                    super.item(RoleMenu.this.item_setting_toggle_on.item_transform_lore(maybe_add_forced_hint, new Object[0]));
                } else {
                    super.item(RoleMenu.this.item_setting_toggle_off.item_transform_lore(maybe_add_forced_hint, new Object[0]));
                }
            }
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }
}

