/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.region;

import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.RegionExtent;
import org.oddlama.vane.regions.region.RegionGroup;

public class Region {
    private UUID id;
    private String name;
    private UUID owner;
    private RegionExtent extent;
    private UUID region_group;
    public boolean invalidated = true;
    private RegionGroup cached_region_group = null;

    public static Object serialize(@NotNull Object o) throws IOException {
        Region region = (Region)o;
        JSONObject json = new JSONObject();
        json.put("id", PersistentSerializer.to_json(UUID.class, (Object)region.id));
        json.put("name", PersistentSerializer.to_json(String.class, (Object)region.name));
        json.put("owner", PersistentSerializer.to_json(UUID.class, (Object)region.owner));
        json.put("region_group", PersistentSerializer.to_json(UUID.class, (Object)region.region_group));
        json.put("extent", PersistentSerializer.to_json(RegionExtent.class, (Object)region.extent));
        return json;
    }

    public static Region deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        Region region = new Region();
        region.id = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("id"));
        region.name = (String)PersistentSerializer.from_json(String.class, (Object)json.get("name"));
        region.owner = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("owner"));
        region.region_group = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("region_group"));
        region.extent = (RegionExtent)PersistentSerializer.from_json(RegionExtent.class, (Object)json.get("extent"));
        return region;
    }

    private Region() {
    }

    public Region(String name, UUID owner, RegionExtent extent, UUID region_group) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.owner = owner;
        this.extent = extent;
        this.region_group = region_group;
    }

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.invalidated = true;
    }

    public UUID owner() {
        return this.owner;
    }

    public RegionExtent extent() {
        return this.extent;
    }

    public UUID region_group_id() {
        return this.region_group;
    }

    public void region_group_id(UUID region_group) {
        this.region_group = region_group;
        this.cached_region_group = null;
        this.invalidated = true;
    }

    public RegionGroup region_group(Regions regions) {
        if (this.cached_region_group == null) {
            this.cached_region_group = regions.get_region_group(this.region_group);
        }
        return this.cached_region_group;
    }
}

