/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.region;

import java.io.IOException;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.util.LazyBlock;

public class RegionExtent {
    private LazyBlock min;
    private LazyBlock max;

    public static Object serialize(@NotNull Object o) throws IOException {
        RegionExtent region_extent = (RegionExtent)o;
        JSONObject json = new JSONObject();
        json.put("min", PersistentSerializer.to_json(LazyBlock.class, (Object)region_extent.min));
        json.put("max", PersistentSerializer.to_json(LazyBlock.class, (Object)region_extent.max));
        return json;
    }

    public static RegionExtent deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        LazyBlock min = (LazyBlock)PersistentSerializer.from_json(LazyBlock.class, (Object)json.get("min"));
        LazyBlock max = (LazyBlock)PersistentSerializer.from_json(LazyBlock.class, (Object)json.get("max"));
        return new RegionExtent(min, max);
    }

    public RegionExtent(LazyBlock min, LazyBlock max) {
        this.min = min;
        this.max = max;
    }

    public RegionExtent(Block from, Block to) {
        if (!from.getWorld().equals((Object)to.getWorld())) {
            throw new RuntimeException("Invalid region extent across dimensions!");
        }
        this.min = new LazyBlock(from.getWorld().getBlockAt(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ())));
        this.max = new LazyBlock(from.getWorld().getBlockAt(Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ())));
    }

    public UUID world() {
        return this.min.world_id();
    }

    public Block min() {
        return this.min.block();
    }

    public Block max() {
        return this.max.block();
    }

    public boolean is_inside(Location loc) {
        if (!loc.getWorld().equals((Object)this.min().getWorld())) {
            return false;
        }
        Block l = this.min();
        Block h = this.max();
        return loc.getX() >= (double)l.getX() && loc.getX() < (double)(h.getX() + 1) && loc.getY() >= (double)l.getY() && loc.getY() < (double)(h.getY() + 1) && loc.getZ() >= (double)l.getZ() && loc.getZ() < (double)(h.getZ() + 1);
    }

    public boolean is_inside(Block block) {
        if (!block.getWorld().equals((Object)this.min().getWorld())) {
            return false;
        }
        Block l = this.min();
        Block h = this.max();
        return block.getX() >= l.getX() && block.getX() <= h.getX() && block.getY() >= l.getY() && block.getY() <= h.getY() && block.getZ() >= l.getZ() && block.getZ() <= h.getZ();
    }

    public boolean intersects_extent(RegionExtent other) {
        if (!this.min().getWorld().equals((Object)other.min().getWorld())) {
            return false;
        }
        Block l1 = this.min();
        Block h1 = this.max();
        Block l2 = other.min();
        Block h2 = other.max();
        int llx = Math.min(l1.getX(), l2.getX());
        int lly = Math.min(l1.getY(), l2.getY());
        int llz = Math.min(l1.getZ(), l2.getZ());
        int hhx = Math.max(h1.getX(), h2.getX());
        int hhy = Math.max(h1.getY(), h2.getY());
        int hhz = Math.max(h1.getZ(), h2.getZ());
        int extent_global_x = hhx - llx + 1;
        int extent_global_y = hhy - lly + 1;
        int extent_global_z = hhz - llz + 1;
        int extent_sum_x = h2.getX() - l2.getX() + (h1.getX() - l1.getX()) + 2;
        int extent_sum_y = h2.getY() - l2.getY() + (h1.getY() - l1.getY()) + 2;
        int extent_sum_z = h2.getZ() - l2.getZ() + (h1.getZ() - l1.getZ()) + 2;
        return extent_global_x < extent_sum_x && extent_global_y < extent_sum_y && extent_global_z < extent_sum_z;
    }

    public boolean intersects_chunk(Chunk chunk) {
        if (!chunk.getWorld().equals((Object)this.min().getWorld())) {
            return false;
        }
        Block l1 = this.min();
        Block h1 = this.max();
        int l2x = chunk.getX() * 16;
        int l2z = chunk.getZ() * 16;
        int h2x = (chunk.getX() + 1) * 16 - 1;
        int h2z = (chunk.getZ() + 1) * 16 - 1;
        int llx = Math.min(l1.getX(), l2x);
        int llz = Math.min(l1.getZ(), l2z);
        int hhx = Math.max(h1.getX(), h2x);
        int hhz = Math.max(h1.getZ(), h2z);
        int extent_global_x = hhx - llx + 1;
        int extent_global_z = hhz - llz + 1;
        int extent_sum_x = h2x - l2x + (h1.getX() - l1.getX()) + 2;
        int extent_sum_z = h2z - l2z + (h1.getZ() - l1.getZ()) + 2;
        return extent_global_x < extent_sum_x && extent_global_z < extent_sum_z;
    }
}

