/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.region;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.EnvironmentSetting;
import org.oddlama.vane.regions.region.Role;
import org.oddlama.vane.regions.region.RoleSetting;

public class RegionGroup {
    private UUID id;
    private String name;
    private UUID owner;
    private Map<UUID, Role> roles = new HashMap<UUID, Role>();
    private Map<UUID, UUID> player_to_role = new HashMap<UUID, UUID>();
    private UUID role_others;
    private Map<EnvironmentSetting, Boolean> settings = new HashMap<EnvironmentSetting, Boolean>();

    public static Object serialize(@NotNull Object o) throws IOException {
        RegionGroup region_group = (RegionGroup)o;
        JSONObject json = new JSONObject();
        json.put("id", PersistentSerializer.to_json(UUID.class, (Object)region_group.id));
        json.put("name", PersistentSerializer.to_json(String.class, (Object)region_group.name));
        json.put("owner", PersistentSerializer.to_json(UUID.class, (Object)region_group.owner));
        try {
            json.put("roles", PersistentSerializer.to_json((Field)RegionGroup.class.getDeclaredField("roles"), region_group.roles));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        try {
            json.put("player_to_role", PersistentSerializer.to_json((Field)RegionGroup.class.getDeclaredField("player_to_role"), region_group.player_to_role));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        json.put("role_others", PersistentSerializer.to_json(UUID.class, (Object)region_group.role_others));
        try {
            json.put("settings", PersistentSerializer.to_json((Field)RegionGroup.class.getDeclaredField("settings"), region_group.settings));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        return json;
    }

    public static RegionGroup deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        RegionGroup region_group = new RegionGroup();
        region_group.id = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("id"));
        region_group.name = (String)PersistentSerializer.from_json(String.class, (Object)json.get("name"));
        region_group.owner = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("owner"));
        try {
            region_group.roles = (Map)PersistentSerializer.from_json((Field)RegionGroup.class.getDeclaredField("roles"), (Object)json.get("roles"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        try {
            region_group.player_to_role = (Map)PersistentSerializer.from_json((Field)RegionGroup.class.getDeclaredField("player_to_role"), (Object)json.get("player_to_role"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        region_group.role_others = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("role_others"));
        try {
            region_group.settings = (Map)PersistentSerializer.from_json((Field)RegionGroup.class.getDeclaredField("settings"), (Object)json.get("settings"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        return region_group;
    }

    private RegionGroup() {
    }

    public RegionGroup(String name, UUID owner) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.owner = owner;
        Role admins = new Role("[Admins]", Role.RoleType.ADMINS);
        this.add_role(admins);
        Role others = new Role("[Others]", Role.RoleType.OTHERS);
        this.add_role(others);
        this.role_others = others.id();
        Role friends = new Role("Friends", Role.RoleType.NORMAL);
        friends.settings().put(RoleSetting.BUILD, true);
        friends.settings().put(RoleSetting.USE, true);
        friends.settings().put(RoleSetting.CONTAINER, true);
        friends.settings().put(RoleSetting.PORTAL, true);
        this.add_role(friends);
        this.player_to_role.put(owner, admins.id());
        for (EnvironmentSetting es : EnvironmentSetting.values()) {
            this.settings.put(es, es.default_value());
        }
    }

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public UUID owner() {
        return this.owner;
    }

    public Map<EnvironmentSetting, Boolean> settings() {
        return this.settings;
    }

    public boolean get_setting(EnvironmentSetting setting) {
        if (setting.has_override()) {
            return setting.get_override() == 1;
        }
        return this.settings.getOrDefault((Object)setting, setting.default_value());
    }

    public void add_role(Role role) {
        this.roles.put(role.id(), role);
    }

    public Map<UUID, UUID> player_to_role() {
        return this.player_to_role;
    }

    public Role get_role(UUID player) {
        return this.roles.get(this.player_to_role.getOrDefault(player, this.role_others));
    }

    public void remove_role(UUID role_id) {
        this.player_to_role.values().removeIf(r -> role_id.equals(r));
        this.roles.remove(role_id);
    }

    public Collection<Role> roles() {
        return this.roles.values();
    }

    public boolean is_orphan(Regions regions) {
        return !regions.all_regions().stream().anyMatch(r -> this.id.equals(r.region_group_id()));
    }
}

