/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.region;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionExtent;
import org.oddlama.vane.util.PlayerUtil;

public class RegionSelection {
    private Regions regions;
    public Block primary = null;
    public Block secondary = null;

    public RegionSelection(Regions regions) {
        this.regions = regions;
    }

    public boolean intersects_existing() {
        RegionExtent extent = this.extent();
        for (Region r : this.regions.all_regions()) {
            if (!r.extent().min().getWorld().equals((Object)this.primary.getWorld()) || !extent.intersects_extent(r.extent())) continue;
            return true;
        }
        return false;
    }

    public double price() {
        int dx = 1 + Math.abs(this.primary.getX() - this.secondary.getX());
        int dy = 1 + Math.abs(this.primary.getY() - this.secondary.getY());
        int dz = 1 + Math.abs(this.primary.getZ() - this.secondary.getZ());
        double cost = Math.pow(this.regions.config_cost_y_multiplicator, (double)dy / 16.0) * this.regions.config_cost_xz_base / 256.0 * (double)dx * (double)dz;
        if (this.regions.config_economy_as_currency) {
            int decimal_places = this.regions.config_economy_decimal_places;
            if (decimal_places == -1) {
                decimal_places = this.regions.economy.fractionalDigits();
            }
            if (decimal_places >= 0) {
                return new BigDecimal(cost).setScale(decimal_places, RoundingMode.UP).doubleValue();
            }
            return cost;
        }
        return Math.ceil(cost);
    }

    public boolean can_afford(Player player) {
        double price = this.price();
        if (price <= 0.0) {
            return true;
        }
        if (this.regions.config_economy_as_currency) {
            return this.regions.economy.has((OfflinePlayer)player, price);
        }
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        map.put(new ItemStack(this.regions.config_currency), (int)price);
        return PlayerUtil.has_items((Player)player, map);
    }

    public boolean is_valid(Player player) {
        if (this.primary == null || this.secondary == null) {
            return false;
        }
        if (!this.primary.getWorld().equals((Object)this.secondary.getWorld())) {
            return false;
        }
        int dx = 1 + Math.abs(this.primary.getX() - this.secondary.getX());
        int dy = 1 + Math.abs(this.primary.getY() - this.secondary.getY());
        int dz = 1 + Math.abs(this.primary.getZ() - this.secondary.getZ());
        if (dx < this.regions.config_min_region_extent_x || dy < this.regions.config_min_region_extent_y || dz < this.regions.config_min_region_extent_z || dx > this.regions.config_max_region_extent_x || dy > this.regions.config_max_region_extent_y || dz > this.regions.config_max_region_extent_z) {
            return false;
        }
        if (this.intersects_existing()) {
            return false;
        }
        return this.can_afford(player);
    }

    public RegionExtent extent() {
        return new RegionExtent(this.primary, this.secondary);
    }
}

