/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.region;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.regions.region.RoleSetting;

public class Role {
    private UUID id;
    private String name;
    private RoleType role_type;
    private Map<RoleSetting, Boolean> settings = new HashMap<RoleSetting, Boolean>();

    public static Object serialize(@NotNull Object o) throws IOException {
        Role role = (Role)o;
        JSONObject json = new JSONObject();
        json.put("id", PersistentSerializer.to_json(UUID.class, (Object)role.id));
        json.put("name", PersistentSerializer.to_json(String.class, (Object)role.name));
        json.put("role_type", PersistentSerializer.to_json(RoleType.class, (Object)((Object)role.role_type)));
        try {
            json.put("settings", PersistentSerializer.to_json((Field)Role.class.getDeclaredField("settings"), role.settings));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        return json;
    }

    public static Role deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        Role role = new Role();
        role.id = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("id"));
        role.name = (String)PersistentSerializer.from_json(String.class, (Object)json.get("name"));
        role.role_type = (RoleType)((Object)PersistentSerializer.from_json(RoleType.class, (Object)json.get("role_type")));
        try {
            role.settings = (Map)PersistentSerializer.from_json((Field)Role.class.getDeclaredField("settings"), (Object)json.get("settings"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        return role;
    }

    private Role() {
    }

    public Role(String name, RoleType role_type) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.role_type = role_type;
        for (RoleSetting rs : RoleSetting.values()) {
            this.settings.put(rs, rs.default_value(role_type == RoleType.ADMINS));
        }
    }

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public RoleType role_type() {
        return this.role_type;
    }

    public Map<RoleSetting, Boolean> settings() {
        return this.settings;
    }

    public boolean get_setting(RoleSetting setting) {
        if (setting.has_override()) {
            return setting.get_override() == 1;
        }
        return this.settings.getOrDefault((Object)setting, setting.default_value(false));
    }

    public String color() {
        switch (this.role_type.ordinal()) {
            case 0: {
                return "\u00a7c";
            }
            case 1: {
                return "\u00a7a";
            }
        }
        return "\u00a7b";
    }

    public static enum RoleType {
        ADMINS,
        OTHERS,
        NORMAL;

    }
}

