/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitTask;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.EntityMoveEvent;
import org.oddlama.vane.portals.portal.Portal;

public class EntityMoveProcessor
extends ModuleComponent<Portals> {
    private LinkedHashMap<UUID, Pair<Entity, Location>> move_event_processing_queue = new LinkedHashMap();
    private HashMap<UUID, Pair<Entity, Location>> move_event_current_positions = new HashMap();
    private HashMap<UUID, Pair<Entity, Location>> move_event_old_positions = new HashMap();
    private BukkitTask task;
    private static final long move_event_max_nanoseconds_per_tick = 15000000L;

    public EntityMoveProcessor(Context<Portals> context) {
        super(context);
    }

    private static boolean is_movement(Location l1, Location l2) {
        return l1.getWorld() == l2.getWorld() && (l1.getX() != l2.getX() || l1.getY() != l2.getY() || l1.getZ() != l2.getZ() || l1.getPitch() != l2.getPitch() || l1.getYaw() != l2.getYaw());
    }

    private void process_entity_movements() {
        HashSet<UUID> active_portal_worlds = new HashSet<UUID>();
        for (Portal portal : ((Portals)this.get_module()).all_available_portals()) {
            if (!((Portals)this.get_module()).is_activated(portal)) continue;
            active_portal_worlds.add(portal.spawn_world());
        }
        for (UUID world_id : active_portal_worlds) {
            World world = ((Portals)this.get_module()).getServer().getWorld(world_id);
            if (world == null) continue;
            for (Entity entity : world.getEntities()) {
                this.move_event_current_positions.put(entity.getUniqueId(), (Pair<Entity, Location>)Pair.of((Object)entity, (Object)entity.getLocation()));
            }
        }
        for (UUID eid : Sets.difference((Set)Sets.intersection(this.move_event_old_positions.keySet(), this.move_event_current_positions.keySet()), this.move_event_processing_queue.keySet())) {
            Pair<Entity, Location> old_entity_and_loc = this.move_event_old_positions.get(eid);
            Pair<Entity, Location> new_entity_and_loc = this.move_event_current_positions.get(eid);
            if (old_entity_and_loc == null || new_entity_and_loc == null || !EntityMoveProcessor.is_movement((Location)old_entity_and_loc.getRight(), (Location)new_entity_and_loc.getRight())) continue;
            this.move_event_processing_queue.put(eid, (Pair<Entity, Location>)Pair.of(old_entity_and_loc));
        }
        HashMap<UUID, Pair<Entity, Location>> tmp = this.move_event_current_positions;
        this.move_event_current_positions = this.move_event_old_positions;
        this.move_event_old_positions = tmp;
        this.move_event_current_positions.clear();
        long time_begin = System.nanoTime();
        PluginManager pm = ((Portals)this.get_module()).getServer().getPluginManager();
        Iterator<Map.Entry<UUID, Pair<Entity, Location>>> iter = this.move_event_processing_queue.entrySet().iterator();
        while (iter.hasNext()) {
            Pair<Entity, Location> e_and_old_loc = iter.next().getValue();
            iter.remove();
            Entity entity = (Entity)e_and_old_loc.getLeft();
            EntityMoveEvent event = new EntityMoveEvent(entity, (Location)e_and_old_loc.getRight(), entity.getLocation());
            pm.callEvent((Event)event);
            long time_now = System.nanoTime();
            if (time_now - time_begin <= 15000000L) continue;
            break;
        }
    }

    protected void on_enable() {
        this.task = this.schedule_task_timer(this::process_entity_movements, 1L, 1L);
    }

    protected void on_disable() {
        this.task.cancel();
    }
}

