/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.portals.portal.PortalBlockLookup;
import org.oddlama.vane.util.PlayerUtil;

public class PortalActivator
extends Listener<Portals> {
    public PortalActivator(Context<Portals> context) {
        super(context);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void on_player_interact_console(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Block block = event.getClickedBlock();
        PortalBlockLookup portal_block = ((Portals)this.get_module()).portal_block_for(block);
        if (portal_block == null || portal_block.type() != PortalBlock.Type.CONSOLE) {
            return;
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
        Player player = event.getPlayer();
        Portal portal = ((Portals)this.get_module()).portal_for(portal_block);
        if (portal.open_console((Portals)this.get_module(), player, block)) {
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_interact_switch(PlayerInteractEvent event) {
        boolean allow_disable;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.getType() == Material.LEVER) {
            allow_disable = true;
        } else if (Tag.BUTTONS.isTagged((Keyed)block.getType())) {
            allow_disable = false;
        } else {
            return;
        }
        Switch bswitch = (Switch)block.getBlockData();
        Block base = block.getRelative(switch (bswitch.getAttachedFace()) {
            default -> bswitch.getFacing().getOppositeFace();
            case FaceAttachable.AttachedFace.CEILING -> BlockFace.UP;
            case FaceAttachable.AttachedFace.FLOOR -> BlockFace.DOWN;
        });
        Portal portal = ((Portals)this.get_module()).controlled_portal(base);
        if (portal == null) {
            return;
        }
        Player player = event.getPlayer();
        boolean active = ((Portals)this.get_module()).is_activated(portal);
        if (bswitch.isPowered() && allow_disable) {
            if (!active) {
                return;
            }
            if (!portal.deactivate((Portals)this.get_module(), player)) {
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
            }
        } else {
            if (active) {
                return;
            }
            if (!portal.activate((Portals)this.get_module(), player)) {
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_block_redstone(BlockRedstoneEvent event) {
        if (event.getOldCurrent() != 0 || event.getNewCurrent() == 0) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.REPEATER) {
            return;
        }
        Repeater repeater = (Repeater)block.getBlockData();
        Block into_block = block.getRelative(repeater.getFacing().getOppositeFace());
        Portal portal = ((Portals)this.get_module()).portal_for(into_block);
        if (portal == null) {
            return;
        }
        portal.activate((Portals)this.get_module(), null);
    }
}

