/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.portals.Portals;

public class PortalBlockProtector
extends Listener<Portals> {
    public PortalBlockProtector(Context<Portals> context) {
        super(context);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_block_break(BlockBreakEvent event) {
        if (((Portals)this.get_module()).is_portal_block(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_block_place(BlockPlaceEvent event) {
        if (((Portals)this.get_module()).is_portal_block(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_entity_explode(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> ((Portals)this.get_module()).is_portal_block((Block)block));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_entity_change_block(EntityChangeBlockEvent event) {
        if (((Portals)this.get_module()).is_portal_block(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_block_piston_extend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!((Portals)this.get_module()).is_portal_block(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_block_piston_retract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (!((Portals)this.get_module()).is_portal_block(block)) continue;
            event.setCancelled(true);
            return;
        }
    }
}

