/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.portals.PortalBlueMapLayerDelegate;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.portal.Portal;

public class PortalBlueMapLayer
extends ModuleComponent<Portals> {
    @ConfigBoolean(def=false, desc="If the marker set should be hidden by default.")
    public boolean config_hide_by_default;
    @LangMessage
    public TranslatedMessage lang_layer_label;
    @LangMessage
    public TranslatedMessage lang_marker_label;
    private PortalBlueMapLayerDelegate delegate = null;

    public PortalBlueMapLayer(Context<Portals> context) {
        super((Context)context.group("blue_map", "Enable BlueMap integration to show public portals."));
    }

    public void delayed_on_enable() {
        Plugin plugin = ((Portals)this.get_module()).getServer().getPluginManager().getPlugin("BlueMap");
        if (plugin == null) {
            return;
        }
        this.delegate = new PortalBlueMapLayerDelegate(this);
        this.delegate.on_enable(plugin);
    }

    public void on_enable() {
        this.schedule_next_tick(this::delayed_on_enable);
    }

    public void on_disable() {
        if (this.delegate != null) {
            this.delegate.on_disable();
            this.delegate = null;
        }
    }

    public void update_marker(Portal portal) {
        if (this.delegate != null) {
            this.delegate.update_marker(portal);
        }
    }

    public void remove_marker(UUID portal_id) {
        if (this.delegate != null) {
            this.delegate.remove_marker(portal_id);
        }
    }

    public void update_all_markers() {
        if (this.delegate != null) {
            this.delegate.update_all_markers();
        }
    }
}

