/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.HtmlMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.external.apache.commons.text.StringEscapeUtils;
import org.oddlama.vane.portals.PortalBlueMapLayer;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.portal.Portal;

public class PortalBlueMapLayerDelegate {
    public static final String MARKER_SET_ID = "vane_portals.portals";
    private final PortalBlueMapLayer parent;
    private boolean bluemap_enabled = false;
    private final HashMap<UUID, MarkerSet> marker_sets = new HashMap();

    public PortalBlueMapLayerDelegate(PortalBlueMapLayer parent) {
        this.parent = parent;
    }

    public Portals get_module() {
        return (Portals)this.parent.get_module();
    }

    public void on_enable(Plugin plugin) {
        BlueMapAPI.onEnable(api -> {
            this.get_module().log.info("Enabling BlueMap integration");
            this.bluemap_enabled = true;
            for (World world : this.get_module().getServer().getWorlds()) {
                this.create_marker_set((BlueMapAPI)api, world);
            }
            this.update_all_markers();
        });
    }

    public void on_disable() {
        if (!this.bluemap_enabled) {
            return;
        }
        this.get_module().log.info("Disabling BlueMap integration");
        this.bluemap_enabled = false;
    }

    private void create_marker_set(BlueMapAPI api, World world) {
        if (this.marker_sets.containsKey(world.getUID())) {
            return;
        }
        MarkerSet marker_set = MarkerSet.builder().label(this.parent.lang_layer_label.str(new Object[0])).toggleable(Boolean.valueOf(true)).defaultHidden(Boolean.valueOf(this.parent.config_hide_by_default)).build();
        api.getWorld((Object)world).ifPresent(bm_world -> {
            for (BlueMapMap map : bm_world.getMaps()) {
                map.getMarkerSets().put(MARKER_SET_ID, marker_set);
            }
        });
        this.marker_sets.put(world.getUID(), marker_set);
    }

    public void update_marker(Portal portal) {
        this.remove_marker(portal.id());
        if (portal.visibility() == Portal.Visibility.PRIVATE) {
            return;
        }
        Location loc = portal.spawn();
        HtmlMarker marker = ((HtmlMarker.Builder)((HtmlMarker.Builder)HtmlMarker.builder().position(loc.getX(), loc.getY(), loc.getZ())).label("Portal " + portal.name())).html(this.parent.lang_marker_label.str(new Object[]{StringEscapeUtils.escapeHtml4((String)portal.name())})).build();
        this.marker_sets.get(loc.getWorld().getUID()).getMarkers().put(portal.id().toString(), marker);
    }

    public void remove_marker(UUID portal_id) {
        for (MarkerSet marker_set : this.marker_sets.values()) {
            marker_set.getMarkers().remove(portal_id.toString());
        }
    }

    public void update_all_markers() {
        for (Portal portal : this.get_module().all_available_portals()) {
            if (portal.visibility() == Portal.Visibility.PRIVATE) continue;
            this.update_marker(portal);
        }
    }
}

