/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigMaterial;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.PortalConstructEvent;
import org.oddlama.vane.portals.event.PortalLinkConsoleEvent;
import org.oddlama.vane.portals.portal.Orientation;
import org.oddlama.vane.portals.portal.Plane;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.portals.portal.PortalBoundary;
import org.oddlama.vane.util.PlayerUtil;

public class PortalConstructor
extends Listener<Portals> {
    @ConfigMaterial(def=Material.ENCHANTING_TABLE, desc="The block used to build portal consoles.")
    public Material config_material_console;
    @ConfigMaterial(def=Material.OBSIDIAN, desc="The block used to build the portal boundary. Variation 1.")
    public Material config_material_boundary_1;
    @ConfigMaterial(def=Material.CRYING_OBSIDIAN, desc="The block used to build the portal boundary. Variation 2.")
    public Material config_material_boundary_2;
    @ConfigMaterial(def=Material.GOLD_BLOCK, desc="The block used to build the portal boundary. Variation 3.")
    public Material config_material_boundary_3;
    @ConfigMaterial(def=Material.GILDED_BLACKSTONE, desc="The block used to build the portal boundary. Variation 4.")
    public Material config_material_boundary_4;
    @ConfigMaterial(def=Material.EMERALD_BLOCK, desc="The block used to build the portal boundary. Variation 5.")
    public Material config_material_boundary_5;
    @ConfigMaterial(def=Material.NETHERITE_BLOCK, desc="The block used to build the portal origin.")
    public Material config_material_origin;
    @ConfigMaterial(def=Material.AIR, desc="The block used to build the portal area.")
    public Material config_material_portal_area;
    @ConfigInt(def=12, min=1, desc="Maximum horizontal distance between a console block and the portal.")
    public int config_console_max_distance_xz;
    @ConfigInt(def=12, min=1, desc="Maximum vertical distance between a console block and the portal.")
    public int config_console_max_distance_y;
    @ConfigInt(def=1024, min=256, desc="Maximum steps for the floodfill algorithm. This should only be increased if you want really big portals. It's recommended to keep this as low as possible.")
    public int config_area_floodfill_max_steps = 1024;
    @ConfigInt(def=24, min=8, desc="Maximum portal area width (bounding box will be measured).")
    public int config_area_max_width;
    @ConfigInt(def=24, min=8, desc="Maximum portal area height (bounding box will be measured).")
    public int config_area_max_height = 24;
    @ConfigInt(def=128, min=8, desc="Maximum total amount of portal area blocks.")
    public int config_area_max_blocks = 128;
    @LangMessage
    public TranslatedMessage lang_select_boundary_now;
    @LangMessage
    public TranslatedMessage lang_console_invalid_type;
    @LangMessage
    public TranslatedMessage lang_console_different_world;
    @LangMessage
    public TranslatedMessage lang_console_too_far_away;
    @LangMessage
    public TranslatedMessage lang_console_linked;
    @LangMessage
    public TranslatedMessage lang_no_boundary_found;
    @LangMessage
    public TranslatedMessage lang_no_origin;
    @LangMessage
    public TranslatedMessage lang_multiple_origins;
    @LangMessage
    public TranslatedMessage lang_no_portal_block_above_origin;
    @LangMessage
    public TranslatedMessage lang_not_enough_portal_blocks_above_origin;
    @LangMessage
    public TranslatedMessage lang_too_large;
    @LangMessage
    public TranslatedMessage lang_too_small_spawn;
    @LangMessage
    public TranslatedMessage lang_too_many_portal_area_blocks;
    @LangMessage
    public TranslatedMessage lang_portal_area_obstructed;
    @LangMessage
    public TranslatedMessage lang_intersects_existing_portal;
    @LangMessage
    public TranslatedMessage lang_build_restricted;
    @LangMessage
    public TranslatedMessage lang_link_restricted;
    @LangMessage
    public TranslatedMessage lang_target_already_connected;
    @LangMessage
    public TranslatedMessage lang_source_use_restricted;
    @LangMessage
    public TranslatedMessage lang_target_use_restricted;
    private Set<Material> portal_boundary_build_materials = new HashSet<Material>();
    private HashMap<UUID, Block> pending_console = new HashMap();

    public PortalConstructor(Context<Portals> context) {
        super(context);
    }

    public void on_config_change() {
        this.portal_boundary_build_materials.clear();
        this.portal_boundary_build_materials.add(this.config_material_boundary_1);
        this.portal_boundary_build_materials.add(this.config_material_boundary_2);
        this.portal_boundary_build_materials.add(this.config_material_boundary_3);
        this.portal_boundary_build_materials.add(this.config_material_boundary_4);
        this.portal_boundary_build_materials.add(this.config_material_boundary_5);
        this.portal_boundary_build_materials.add(this.config_material_origin);
    }

    public int max_dim_x(Plane plane) {
        return plane.x() ? this.config_area_max_width : 1;
    }

    public int max_dim_y(Plane plane) {
        return plane.y() ? this.config_area_max_height : 1;
    }

    public int max_dim_z(Plane plane) {
        return plane.z() ? this.config_area_max_width : 1;
    }

    private boolean remember_new_console(Player player, Block console_block) {
        boolean changed = !console_block.equals((Object)this.pending_console.get(player.getUniqueId()));
        this.pending_console.put(player.getUniqueId(), console_block);
        if (changed) {
            this.lang_select_boundary_now.send((CommandSender)player, new Object[0]);
        }
        return changed;
    }

    private boolean can_link_console(Player player, PortalBoundary boundary, Block console, boolean check_only) {
        return this.can_link_console(player, boundary.all_blocks(), console, null, check_only);
    }

    private boolean can_link_console(Player player, Portal portal, Block console, boolean check_only) {
        List<Block> blocks = portal.blocks().stream().filter(pb -> pb.type() != PortalBlock.Type.CONSOLE).map(pb -> pb.block()).collect(Collectors.toList());
        return this.can_link_console(player, blocks, console, portal, check_only);
    }

    private boolean can_link_console(Player player, List<Block> blocks, Block console, @Nullable Portal existing_portal, boolean check_only) {
        if (console.getType() != this.config_material_console) {
            this.lang_console_invalid_type.send((CommandSender)player, new Object[0]);
            return false;
        }
        if (!console.getWorld().equals((Object)blocks.get(0).getWorld())) {
            this.lang_console_different_world.send((CommandSender)player, new Object[0]);
            return false;
        }
        boolean found_valid_block = false;
        for (Block block : blocks) {
            if (Math.abs(console.getX() - block.getX()) > this.config_console_max_distance_xz || Math.abs(console.getY() - block.getY()) > this.config_console_max_distance_y || Math.abs(console.getZ() - block.getZ()) > this.config_console_max_distance_xz) continue;
            found_valid_block = true;
            break;
        }
        if (!found_valid_block) {
            this.lang_console_too_far_away.send((CommandSender)player, new Object[0]);
            return false;
        }
        PortalLinkConsoleEvent event = new PortalLinkConsoleEvent(player, console, blocks, check_only, existing_portal);
        ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
            this.lang_link_restricted.send((CommandSender)player, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean link_console(Player player, Block console, Portal portal) {
        if (!this.can_link_console(player, portal, console, false)) {
            return false;
        }
        ((Portals)this.get_module()).add_new_portal_block(portal, this.create_portal_block(console));
        portal.update_blocks((Portals)this.get_module());
        return true;
    }

    private PortalBoundary find_boundary(Player player, Block block) {
        PortalBoundary boundary = PortalBoundary.search_at(this, block);
        if (boundary == null) {
            this.lang_no_boundary_found.send((CommandSender)player, new Object[0]);
            return null;
        }
        switch (boundary.error_state()) {
            case NONE: {
                break;
            }
            case NO_ORIGIN: {
                this.lang_no_origin.send((CommandSender)player, new Object[0]);
                return null;
            }
            case MULTIPLE_ORIGINS: {
                this.lang_multiple_origins.send((CommandSender)player, new Object[0]);
                return null;
            }
            case NO_PORTAL_BLOCK_ABOVE_ORIGIN: {
                this.lang_no_portal_block_above_origin.send((CommandSender)player, new Object[0]);
                return null;
            }
            case NOT_ENOUGH_PORTAL_BLOCKS_ABOVE_ORIGIN: {
                this.lang_not_enough_portal_blocks_above_origin.send((CommandSender)player, new Object[0]);
                return null;
            }
            case TOO_LARGE_X: {
                this.lang_too_large.send((CommandSender)player, new Object[]{"\u00a76x"});
                return null;
            }
            case TOO_LARGE_Y: {
                this.lang_too_large.send((CommandSender)player, new Object[]{"\u00a76y"});
                return null;
            }
            case TOO_LARGE_Z: {
                this.lang_too_large.send((CommandSender)player, new Object[]{"\u00a76z"});
                return null;
            }
            case TOO_SMALL_SPAWN_X: {
                this.lang_too_small_spawn.send((CommandSender)player, new Object[]{"\u00a76x"});
                return null;
            }
            case TOO_SMALL_SPAWN_Y: {
                this.lang_too_small_spawn.send((CommandSender)player, new Object[]{"\u00a76y"});
                return null;
            }
            case TOO_SMALL_SPAWN_Z: {
                this.lang_too_small_spawn.send((CommandSender)player, new Object[]{"\u00a76z"});
                return null;
            }
            case PORTAL_AREA_OBSTRUCTED: {
                this.lang_portal_area_obstructed.send((CommandSender)player, new Object[0]);
                return null;
            }
            case TOO_MANY_PORTAL_AREA_BLOCKS: {
                this.lang_too_many_portal_area_blocks.send((CommandSender)player, new Object[]{"\u00a76" + boundary.portal_area_blocks().size(), "\u00a76" + this.config_area_max_blocks});
                return null;
            }
        }
        if (boundary.intersects_existing_portal(this)) {
            this.lang_intersects_existing_portal.send((CommandSender)player, new Object[0]);
            return null;
        }
        return boundary;
    }

    public boolean is_type_part_of_boundary(Material material) {
        return material == this.config_material_boundary_1 || material == this.config_material_boundary_2 || material == this.config_material_boundary_3 || material == this.config_material_boundary_4 || material == this.config_material_boundary_5;
    }

    public boolean is_type_part_of_boundary_or_origin(Material material) {
        return material == this.config_material_origin || this.is_type_part_of_boundary(material);
    }

    private PortalBoundary check_construction_conditions(Player player, Block console, Block boundary_block, boolean check_only) {
        if (((Portals)this.get_module()).is_portal_block(boundary_block)) {
            ((Portals)this.get_module()).log.severe("construct_portal() was called on a boundary that already belongs to a portal! This is a bug.");
            return null;
        }
        PortalBoundary boundary = this.find_boundary(player, boundary_block);
        if (boundary == null) {
            return null;
        }
        PortalConstructEvent event = new PortalConstructEvent(player, boundary, check_only);
        ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.lang_build_restricted.send((CommandSender)player, new Object[0]);
            return null;
        }
        if (!this.can_link_console(player, boundary, console, true)) {
            return null;
        }
        return boundary;
    }

    private PortalBlock create_portal_block(Block block) {
        PortalBlock.Type type;
        Material mat = block.getType();
        if (mat == Material.CAVE_AIR || mat == Material.VOID_AIR) {
            mat = Material.AIR;
        }
        if (mat == this.config_material_console) {
            type = PortalBlock.Type.CONSOLE;
        } else if (mat == this.config_material_boundary_1) {
            type = PortalBlock.Type.BOUNDARY_1;
        } else if (mat == this.config_material_boundary_2) {
            type = PortalBlock.Type.BOUNDARY_2;
        } else if (mat == this.config_material_boundary_3) {
            type = PortalBlock.Type.BOUNDARY_3;
        } else if (mat == this.config_material_boundary_4) {
            type = PortalBlock.Type.BOUNDARY_4;
        } else if (mat == this.config_material_boundary_5) {
            type = PortalBlock.Type.BOUNDARY_5;
        } else if (mat == this.config_material_origin) {
            type = PortalBlock.Type.ORIGIN;
        } else if (mat == this.config_material_portal_area) {
            type = PortalBlock.Type.PORTAL;
        } else {
            ((Portals)this.get_module()).log.warning("Invalid block type '" + String.valueOf(mat) + "' encountered in portal block creation. Assuming boundary variant 1.");
            type = PortalBlock.Type.BOUNDARY_1;
        }
        return new PortalBlock(block, type);
    }

    private boolean construct_portal(Player player, Block console, Block boundary_block) {
        if (this.check_construction_conditions(player, console, boundary_block, true) == null) {
            return false;
        }
        ((Portals)this.get_module()).menus.enter_name_menu.create(player, (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(p, name) -> {
            PortalBoundary boundary = this.check_construction_conditions((Player)p, console, boundary_block, false);
            if (boundary == null) {
                return Menu.ClickResult.ERROR;
            }
            Orientation orientation = Orientation.from(boundary.plane(), boundary.origin_block(), console, player.getLocation());
            Portal portal = new Portal(p.getUniqueId(), orientation, boundary.spawn());
            portal.name((String)name);
            ((Portals)this.get_module()).add_new_portal(portal);
            for (Block block : boundary.all_blocks()) {
                ((Portals)this.get_module()).add_new_portal_block(portal, this.create_portal_block(block));
            }
            this.link_console((Player)p, console, portal);
            ((Portals)this.get_module()).update_persistent_data();
            portal.update_blocks((Portals)this.get_module());
            return Menu.ClickResult.SUCCESS;
        }).open(player);
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_interact_console(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.getType() != this.config_material_console) {
            return;
        }
        if (((Portals)this.get_module()).is_portal_block(block)) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking() || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        this.remember_new_console(player, block);
        PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void on_player_interact_boundary(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        Portal portal = ((Portals)this.get_module()).portal_for(block);
        Material type = block.getType();
        if (portal == null && !this.portal_boundary_build_materials.contains(type)) {
            return;
        }
        Player player = event.getPlayer();
        Block console = this.pending_console.remove(player.getUniqueId());
        if (console == null) {
            return;
        }
        if (portal == null) {
            if (this.construct_portal(player, console, block)) {
                PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
            }
        } else if (this.link_console(player, console, portal)) {
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
    }
}

