/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.oddlama.vane.portals.PortalDynmapLayer;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.portal.Portal;

public class PortalDynmapLayerDelegate {
    private final PortalDynmapLayer parent;
    private DynmapCommonAPI dynmap_api = null;
    private MarkerAPI marker_api = null;
    private boolean dynmap_enabled = false;
    private MarkerSet marker_set = null;
    private MarkerIcon marker_icon = null;

    public PortalDynmapLayerDelegate(PortalDynmapLayer parent) {
        this.parent = parent;
    }

    public Portals get_module() {
        return (Portals)this.parent.get_module();
    }

    public void on_enable(Plugin plugin) {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI api) {
                    PortalDynmapLayerDelegate.this.dynmap_api = api;
                    PortalDynmapLayerDelegate.this.marker_api = PortalDynmapLayerDelegate.this.dynmap_api.getMarkerAPI();
                }
            });
        }
        catch (Exception e) {
            this.get_module().log.log(Level.WARNING, "Error while enabling dynmap integration!", e);
            return;
        }
        if (this.marker_api == null) {
            return;
        }
        this.get_module().log.info("Enabling dynmap integration");
        this.dynmap_enabled = true;
        this.create_or_load_layer();
    }

    public void on_disable() {
        if (!this.dynmap_enabled) {
            return;
        }
        this.get_module().log.info("Disabling dynmap integration");
        this.dynmap_enabled = false;
        this.dynmap_api = null;
        this.marker_api = null;
    }

    private void create_or_load_layer() {
        this.marker_set = this.marker_api.getMarkerSet("vane_portals.portals");
        if (this.marker_set == null) {
            this.marker_set = this.marker_api.createMarkerSet("vane_portals.portals", this.parent.lang_layer_label.str(new Object[0]), null, false);
        }
        if (this.marker_set == null) {
            this.get_module().log.severe("Failed to create dynmap portal marker set!");
            return;
        }
        this.marker_set.setMarkerSetLabel(this.parent.lang_layer_label.str(new Object[0]));
        this.marker_set.setLayerPriority(this.parent.config_layer_priority);
        this.marker_set.setHideByDefault(this.parent.config_layer_hide);
        this.marker_icon = this.marker_api.getMarkerIcon(this.parent.config_marker_icon);
        if (this.marker_icon == null) {
            this.get_module().log.severe("Failed to load dynmap portal marker icon!");
            return;
        }
        this.update_all_markers();
    }

    private String id_for(UUID portal_id) {
        return portal_id.toString();
    }

    private String id_for(Portal portal) {
        return this.id_for(portal.id());
    }

    public void update_marker(Portal portal) {
        if (!this.dynmap_enabled) {
            return;
        }
        if (portal.visibility() == Portal.Visibility.PRIVATE) {
            this.remove_marker(portal.id());
            return;
        }
        Location loc = portal.spawn();
        String world_name = loc.getWorld().getName();
        String marker_id = this.id_for(portal);
        String marker_label = this.parent.lang_marker_label.str(new Object[]{portal.name()});
        this.marker_set.createMarker(marker_id, marker_label, world_name, loc.getX(), loc.getY(), loc.getZ(), this.marker_icon, false);
    }

    public void remove_marker(UUID portal_id) {
        this.remove_marker(this.id_for(portal_id));
    }

    public void remove_marker(String marker_id) {
        if (!this.dynmap_enabled || marker_id == null) {
            return;
        }
        this.remove_marker(this.marker_set.findMarker(marker_id));
    }

    public void remove_marker(Marker marker) {
        if (!this.dynmap_enabled || marker == null) {
            return;
        }
        marker.deleteMarker();
    }

    public void update_all_markers() {
        if (!this.dynmap_enabled) {
            return;
        }
        HashSet<String> id_set = new HashSet<String>();
        for (Portal portal : this.get_module().all_available_portals()) {
            id_set.add(this.id_for(portal));
            this.update_marker(portal);
        }
        for (Marker marker : this.marker_set.getMarkers()) {
            String id = marker.getMarkerID();
            if (id == null || id_set.contains(id)) continue;
            this.remove_marker(marker);
        }
    }
}

