/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.util.Vector;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.EntityMoveEvent;
import org.oddlama.vane.portals.portal.Orientation;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.util.Nms;

public class PortalTeleporter
extends Listener<Portals> {
    private final HashMap<UUID, Location> entities_portalling = new HashMap();

    public PortalTeleporter(Context<Portals> context) {
        super(context);
    }

    private boolean cancel_portal_event(Entity entity) {
        if (this.entities_portalling.containsKey(entity.getUniqueId())) {
            return true;
        }
        return ((Portals)this.get_module()).is_portal_block(entity.getLocation().getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_player_portal(PlayerPortalEvent event) {
        if (this.cancel_portal_event((Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_entity_teleport_event(EntityTeleportEvent event) {
        if (this.cancel_portal_event(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_entity_teleport_end_gateway_event(EntityTeleportEndGatewayEvent event) {
        if (((Portals)this.get_module()).is_portal_block(event.getGateway().getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_teleport_event(PlayerTeleportEndGatewayEvent event) {
        Block block = event.getGateway().getBlock();
        if (((Portals)this.get_module()).is_portal_block(block)) {
            event.setCancelled(true);
        }
    }

    private void teleport_single_entity(Entity entity, Location target_location, Vector new_velocity) {
        Location entity_location = entity.getLocation();
        net.minecraft.world.entity.Entity nms_entity = Nms.entity_handle((Entity)entity);
        if (target_location.getWorld() == entity_location.getWorld()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Nms.get_player((Player)player).connection.teleport(target_location.getX(), target_location.getY(), target_location.getZ(), target_location.getYaw(), target_location.getPitch());
            } else {
                nms_entity.absSnapTo(target_location.getX(), target_location.getY(), target_location.getZ(), target_location.getYaw(), target_location.getPitch());
            }
            nms_entity.setYHeadRot(target_location.getYaw());
        } else {
            ArrayList passengers = new ArrayList(entity.getPassengers());
            passengers.stream().forEach(arg_0 -> ((Entity)entity).removePassenger(arg_0));
            entity.teleport(target_location);
            for (Entity p : passengers) {
                this.teleport_single_entity(p, target_location, new Vector());
                entity.addPassenger(p);
            }
        }
        entity.setVelocity(new_velocity);
    }

    private void teleport_entity(Entity entity, Portal source, Portal target) {
        Location target_location = target.spawn().clone();
        if (entity instanceof LivingEntity) {
            LivingEntity living_entity = (LivingEntity)entity;
            if (living_entity.isInsideVehicle()) {
                return;
            }
            if (living_entity.isGliding() && source.orientation().plane().y()) {
                target_location.setY(target_location.getY() + 1.5);
            }
        }
        UUID entity_id = entity.getUniqueId();
        this.entities_portalling.put(entity_id, null);
        Location entity_location = entity.getLocation();
        target_location.setPitch(entity_location.getPitch());
        target_location.setYaw(entity_location.getYaw());
        Orientation source_orientation = source.orientation();
        target_location = source_orientation.apply(target.orientation(), target_location, target.exit_orientation_locked());
        Vector new_velocity = source_orientation.apply(target.orientation(), entity.getVelocity(), target.exit_orientation_locked());
        this.teleport_single_entity(entity, target_location, new_velocity);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_entity_move(EntityMoveEvent event) {
        Entity entity = event.getEntity();
        UUID entity_id = entity.getUniqueId();
        Block block = event.getTo().getBlock();
        if (!this.entities_portalling.containsKey(entity_id)) {
            if (!((Portals)this.get_module()).portal_area_materials.contains(block.getType())) {
                return;
            }
            Portal portal = ((Portals)this.get_module()).portal_for(block);
            if (portal == null) {
                return;
            }
            Portal target = ((Portals)this.get_module()).connected_portal(portal);
            if (target == null) {
                return;
            }
            this.teleport_entity(entity, portal, target);
        } else {
            Location loc = this.entities_portalling.get(entity_id);
            if (loc == null) {
                this.entities_portalling.put(entity_id, event.getFrom().clone());
            } else if (!((Portals)this.get_module()).portal_area_materials.contains(block.getType()) && loc.getWorld() == event.getFrom().getWorld() && event.getFrom().distance(loc) > 2.0) {
                this.entities_portalling.remove(entity_id);
            }
        }
    }
}

