/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.annotation.VaneModule;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigExtendedMaterial;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.annotation.config.ConfigMaterialMapEntry;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapEntry;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapMap;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapMapEntry;
import org.oddlama.vane.annotation.config.ConfigMaterialSet;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.functional.Consumer2;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.material.ExtendedMaterial;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.apache.commons.lang3.StringUtils;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.portals.EntityMoveProcessor;
import org.oddlama.vane.portals.PortalActivator;
import org.oddlama.vane.portals.PortalBlockProtector;
import org.oddlama.vane.portals.PortalBlueMapLayer;
import org.oddlama.vane.portals.PortalConstructor;
import org.oddlama.vane.portals.PortalDynmapLayer;
import org.oddlama.vane.portals.PortalTeleporter;
import org.oddlama.vane.portals.entity.FloatingItem;
import org.oddlama.vane.portals.menu.PortalMenuGroup;
import org.oddlama.vane.portals.menu.PortalMenuTag;
import org.oddlama.vane.portals.portal.Orientation;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.portals.portal.PortalBlockLookup;
import org.oddlama.vane.portals.portal.Style;
import org.oddlama.vane.util.BlockUtil;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.Nms;
import org.oddlama.vane.util.StorageUtil;

@VaneModule(name="portals", bstats=8642, config_version=3L, lang_version=6L, storage_version=2L)
public class Portals
extends Module<Portals> {
    @ConfigMaterialSet(def={Material.PISTON, Material.STICKY_PISTON}, desc="Materials which may not be used to decorate portals.")
    public Set<Material> config_blacklisted_materials;
    @ConfigMaterialMapMapMap(def={@ConfigMaterialMapMapMapEntry(key="vane_portals:portal_style_default", value={@ConfigMaterialMapMapEntry(key="active", value={@ConfigMaterialMapEntry(key="boundary_1", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_2", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_3", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_4", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_5", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="console", value=Material.ENCHANTING_TABLE), @ConfigMaterialMapEntry(key="origin", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="portal", value=Material.END_GATEWAY)}), @ConfigMaterialMapMapEntry(key="inactive", value={@ConfigMaterialMapEntry(key="boundary_1", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_2", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_3", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_4", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="boundary_5", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="console", value=Material.ENCHANTING_TABLE), @ConfigMaterialMapEntry(key="origin", value=Material.OBSIDIAN), @ConfigMaterialMapEntry(key="portal", value=Material.AIR)})}), @ConfigMaterialMapMapMapEntry(key="vane_portals:portal_style_aqua", value={@ConfigMaterialMapMapEntry(key="active", value={@ConfigMaterialMapEntry(key="boundary_1", value=Material.DARK_PRISMARINE), @ConfigMaterialMapEntry(key="boundary_2", value=Material.WARPED_PLANKS), @ConfigMaterialMapEntry(key="boundary_3", value=Material.SEA_LANTERN), @ConfigMaterialMapEntry(key="boundary_4", value=Material.WARPED_WART_BLOCK), @ConfigMaterialMapEntry(key="boundary_5", value=Material.LIGHT_BLUE_STAINED_GLASS), @ConfigMaterialMapEntry(key="console", value=Material.ENCHANTING_TABLE), @ConfigMaterialMapEntry(key="origin", value=Material.DARK_PRISMARINE), @ConfigMaterialMapEntry(key="portal", value=Material.END_GATEWAY)}), @ConfigMaterialMapMapEntry(key="inactive", value={@ConfigMaterialMapEntry(key="boundary_1", value=Material.DARK_PRISMARINE), @ConfigMaterialMapEntry(key="boundary_2", value=Material.WARPED_PLANKS), @ConfigMaterialMapEntry(key="boundary_3", value=Material.PRISMARINE_BRICKS), @ConfigMaterialMapEntry(key="boundary_4", value=Material.WARPED_WART_BLOCK), @ConfigMaterialMapEntry(key="boundary_5", value=Material.LIGHT_BLUE_STAINED_GLASS), @ConfigMaterialMapEntry(key="console", value=Material.ENCHANTING_TABLE), @ConfigMaterialMapEntry(key="origin", value=Material.DARK_PRISMARINE), @ConfigMaterialMapEntry(key="portal", value=Material.AIR)})})}, desc="Portal style definitions. Must provide a material for each portal block type and activation state. The default style may be overridden.")
    public Map<String, Map<String, Map<String, Material>>> config_styles;
    @ConfigLong(def=10000L, min=1000L, max=110000L, desc="Delay in milliseconds after which two connected portals will automatically be disabled. Purple end-gateway beams do not show up until the maximum value of 110 seconds.")
    public long config_deactivation_delay;
    @ConfigExtendedMaterial(def="vane:decoration_end_portal_orb", desc="The default portal icon. Also accepts heads from the head library.")
    public ExtendedMaterial config_default_icon;
    @ConfigDouble(def=0.9, min=0.0, max=1.0, desc="Volume for the portal activation sound effect. 0 to disable.")
    public double config_volume_activation;
    @ConfigDouble(def=1.0, min=0.0, max=1.0, desc="Volume for the portal deactivation sound effect. 0 to disable.")
    public double config_volume_deactivation;
    @LangMessage
    public TranslatedMessage lang_console_display_active;
    @LangMessage
    public TranslatedMessage lang_console_display_inactive;
    @LangMessage
    public TranslatedMessage lang_console_no_target;
    @LangMessage
    public TranslatedMessage lang_unlink_restricted;
    @LangMessage
    public TranslatedMessage lang_destroy_restricted;
    @LangMessage
    public TranslatedMessage lang_settings_restricted;
    @LangMessage
    public TranslatedMessage lang_select_target_restricted;
    public final Permission admin_permission;
    @Persistent
    private Map<UUID, Portal> storage_portals = new HashMap<UUID, Portal>();
    private Map<UUID, Portal> portals = new HashMap<UUID, Portal>();
    private Map<UUID, Map<Long, Map<Long, PortalBlockLookup>>> portal_blocks_in_chunk_in_world = new HashMap<UUID, Map<Long, Map<Long, PortalBlockLookup>>>();
    public Map<NamespacedKey, Style> styles = new HashMap<NamespacedKey, Style>();
    public Set<Material> portal_area_materials = new HashSet<Material>();
    private final Map<Block, FloatingItem> console_floating_items = new HashMap<Block, FloatingItem>();
    private final Map<UUID, UUID> connected_portals = new HashMap<UUID, UUID>();
    private final Map<Long, Integer> chunk_ticket_count = new HashMap<Long, Integer>();
    private final Map<UUID, BukkitTask> disable_tasks = new HashMap<UUID, BukkitTask>();
    public PortalMenuGroup menus;
    public PortalConstructor constructor;
    public PortalDynmapLayer dynmap_layer;
    public PortalBlueMapLayer blue_map_layer;
    private Function2<Portal, Portal, Boolean> is_in_same_region_group_callback = null;
    private Function2<Player, Portal, Boolean> player_can_use_portals_in_region_group_of_callback = null;
    public static final NamespacedKey STORAGE_PORTALS;

    public Portals() {
        this.register_entities();
        this.menus = new PortalMenuGroup((Context<Portals>)this);
        new PortalActivator((Context<Portals>)this);
        new PortalBlockProtector((Context<Portals>)this);
        this.constructor = new PortalConstructor((Context<Portals>)this);
        new PortalTeleporter((Context<Portals>)this);
        new EntityMoveProcessor((Context<Portals>)this);
        this.dynmap_layer = new PortalDynmapLayer((Context<Portals>)this);
        this.blue_map_layer = new PortalBlueMapLayer((Context<Portals>)this);
        this.admin_permission = new Permission("vane." + ((Portals)this.get_module()).get_name() + ".admin", "Allows administration of any portal", PermissionDefault.OP);
        ((Portals)this.get_module()).register_permission(this.admin_permission);
        this.persistent_storage_manager.add_migration_to(2L, "Portal visibility GROUP_INTERNAL was added. This is a no-op.", json -> {});
    }

    private void register_entities() {
        ((Portals)this.get_module()).core.unfreeze_registries();
        Nms.register_entity((NamespacedKey)NamespacedKey.minecraft((String)"item"), (String)this.namespace(), (String)"floating_item", (EntityType.Builder)EntityType.Builder.of(FloatingItem::new, (MobCategory)MobCategory.MISC).noSave().sized(0.0f, 0.0f));
    }

    private static long block_key(Block block) {
        return block.getY() << 8 | (block.getX() & 0xF) << 4 | block.getZ() & 0xF;
    }

    private static Block unpack_block_key(Chunk chunk, long block_key) {
        int y = (int)(block_key >> 8);
        int x = (int)(block_key >> 4 & 0xFL);
        int z = (int)(block_key & 0xFL);
        return chunk.getBlock(x, y, z);
    }

    public void on_config_change() {
        this.styles.clear();
        this.config_styles.forEach((style_key, v1) -> {
            String[] split = style_key.split(":");
            if (split.length != 2) {
                throw new RuntimeException("Invalid style key: '" + style_key + "' is not a valid namespaced key");
            }
            Style style = new Style(StorageUtil.namespaced_key((String)split[0], (String)split[1]));
            v1.forEach((is_active, v2) -> v2.forEach((arg_0, arg_1) -> Portals.lambda$on_config_change$7(style, switch (is_active) {
                case "active" -> true;
                case "inactive" -> false;
                default -> throw new RuntimeException("Invalid active state, must be either 'active' or 'inactive'");
            }, arg_0, arg_1)));
            style.check_valid();
            this.styles.put(style.key(), style);
        });
        if (!this.styles.containsKey(Style.default_style_key())) {
            Style default_style = Style.default_style();
            this.styles.put(default_style.key(), default_style);
        }
        this.portal_area_materials.clear();
        for (Style style : this.styles.values()) {
            this.portal_area_materials.add(style.material(true, PortalBlock.Type.PORTAL));
        }
    }

    public void set_is_in_same_region_group_callback(Function2<Portal, Portal, Boolean> callback) {
        this.is_in_same_region_group_callback = callback;
    }

    public void set_player_can_use_portals_in_region_group_of_callback(Function2<Player, Portal, Boolean> callback) {
        this.player_can_use_portals_in_region_group_of_callback = callback;
    }

    public boolean is_in_same_region_group(Portal a, Portal b) {
        if (this.is_in_same_region_group_callback == null) {
            return true;
        }
        return (Boolean)this.is_in_same_region_group_callback.apply((Object)a, (Object)b);
    }

    public boolean player_can_use_portals_in_region_group_of(Player player, Portal portal) {
        if (this.player_can_use_portals_in_region_group_of_callback == null) {
            return true;
        }
        return (Boolean)this.player_can_use_portals_in_region_group_of_callback.apply((Object)player, (Object)portal);
    }

    public boolean is_regions_installed() {
        return this.is_in_same_region_group_callback != null;
    }

    public Style style(NamespacedKey key) {
        Style s = this.styles.get(key);
        if (s == null) {
            this.log.warning("Encountered invalid style " + String.valueOf(key) + ", falling back to default style.");
            return this.styles.get(Style.default_style_key());
        }
        return s;
    }

    public void remove_portal(Portal portal) {
        Portal connected = this.connected_portal(portal);
        if (connected != null) {
            this.disconnect_portals(portal, connected);
        }
        if (this.portals.remove(portal.id()) == null) {
            return;
        }
        portal.blocks().forEach(this::remove_portal_block);
        for (Portal other : this.portals.values()) {
            if (!Objects.equals(other.target_id(), portal.id())) continue;
            other.target_id(null);
            other.blocks().stream().filter(pb -> pb.type() == PortalBlock.Type.CONSOLE).filter(pb -> this.console_floating_items.containsKey(pb.block())).forEach(pb -> this.update_console_item(other, pb.block()));
        }
        this.update_persistent_data();
        ((Portals)this.get_module()).core.menu_manager.for_each_open((Consumer2 & Serializable)(player, menu) -> {
            if (menu.tag() instanceof PortalMenuTag && Objects.equals(((PortalMenuTag)menu.tag()).portal_id(), portal.id())) {
                menu.taint();
                menu.close(player);
            }
        });
        this.remove_marker(portal.id());
        portal.spawn().getWorld().playSound(portal.spawn(), Sound.ENTITY_ENDER_EYE_DEATH, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void add_new_portal(Portal portal) {
        portal.invalidated = true;
        this.index_portal(portal);
        portal.spawn().getWorld().playSound(portal.spawn(), Sound.ENTITY_ENDER_EYE_DEATH, SoundCategory.BLOCKS, 1.0f, 2.0f);
    }

    public void index_portal(Portal portal) {
        this.portals.put(portal.id(), portal);
        portal.blocks().forEach(b -> this.index_portal_block(portal, (PortalBlock)b));
        this.update_marker(portal);
    }

    public Collection<Portal> all_available_portals() {
        return this.portals.values().stream().filter(p -> p.spawn().isWorldLoaded()).collect(Collectors.toList());
    }

    public void remove_portal_block(PortalBlock portal_block) {
        Block block;
        Map<Long, Map<Long, PortalBlockLookup>> portal_blocks_in_chunk;
        switch (portal_block.type()) {
            case ORIGIN: {
                portal_block.block().setType(this.constructor.config_material_origin);
                break;
            }
            case CONSOLE: {
                portal_block.block().setType(this.constructor.config_material_console);
                break;
            }
            case BOUNDARY_1: {
                portal_block.block().setType(this.constructor.config_material_boundary_1);
                break;
            }
            case BOUNDARY_2: {
                portal_block.block().setType(this.constructor.config_material_boundary_2);
                break;
            }
            case BOUNDARY_3: {
                portal_block.block().setType(this.constructor.config_material_boundary_3);
                break;
            }
            case BOUNDARY_4: {
                portal_block.block().setType(this.constructor.config_material_boundary_4);
                break;
            }
            case BOUNDARY_5: {
                portal_block.block().setType(this.constructor.config_material_boundary_5);
                break;
            }
            case PORTAL: {
                portal_block.block().setType(this.constructor.config_material_portal_area);
            }
        }
        if (portal_block.type() == PortalBlock.Type.CONSOLE) {
            this.remove_console_item(portal_block.block());
        }
        if ((portal_blocks_in_chunk = this.portal_blocks_in_chunk_in_world.get((block = portal_block.block()).getWorld().getUID())) == null) {
            return;
        }
        long chunk_key = block.getChunk().getChunkKey();
        Map<Long, PortalBlockLookup> block_to_portal_block = portal_blocks_in_chunk.get(chunk_key);
        if (block_to_portal_block == null) {
            return;
        }
        block_to_portal_block.remove(Portals.block_key(block));
        if (portal_block.type() != PortalBlock.Type.PORTAL) {
            portal_block.block().getWorld().spawnParticle(Particle.ENCHANT, portal_block.block().getLocation().add(0.5, 0.5, 0.5), 50, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void remove_portal_block(Portal portal, PortalBlock portal_block) {
        portal.blocks().remove(portal_block);
        this.remove_portal_block(portal_block);
    }

    public void add_new_portal_block(Portal portal, PortalBlock portal_block) {
        portal.blocks().add(portal_block);
        portal.invalidated = true;
        this.index_portal_block(portal, portal_block);
        if (portal_block.type() != PortalBlock.Type.PORTAL) {
            portal_block.block().getWorld().spawnParticle(Particle.PORTAL, portal_block.block().getLocation().add(0.5, 0.5, 0.5), 50, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void index_portal_block(Portal portal, PortalBlock portal_block) {
        Block block = portal_block.block();
        UUID world_id = block.getWorld().getUID();
        Map portal_blocks_in_chunk = this.portal_blocks_in_chunk_in_world.computeIfAbsent(world_id, k -> new HashMap());
        long chunk_key = block.getChunk().getChunkKey();
        Map block_to_portal_block = portal_blocks_in_chunk.computeIfAbsent(chunk_key, k -> new HashMap());
        block_to_portal_block.put(Portals.block_key(block), portal_block.lookup(portal.id()));
    }

    public PortalBlockLookup portal_block_for(Block block) {
        Map<Long, Map<Long, PortalBlockLookup>> portal_blocks_in_chunk = this.portal_blocks_in_chunk_in_world.get(block.getWorld().getUID());
        if (portal_blocks_in_chunk == null) {
            return null;
        }
        long chunk_key = block.getChunk().getChunkKey();
        Map<Long, PortalBlockLookup> block_to_portal_block = portal_blocks_in_chunk.get(chunk_key);
        if (block_to_portal_block == null) {
            return null;
        }
        return block_to_portal_block.get(Portals.block_key(block));
    }

    public Portal portal_for(@Nullable UUID uuid) {
        Portal portal = this.portals.get(uuid);
        if (portal == null || !portal.spawn().isWorldLoaded()) {
            return null;
        }
        return portal;
    }

    public Portal portal_for(@NotNull PortalBlockLookup block) {
        return this.portal_for(block.portal_id());
    }

    public Portal portal_for(Block block) {
        PortalBlockLookup portal_block = this.portal_block_for(block);
        if (portal_block == null) {
            return null;
        }
        return this.portal_for(portal_block);
    }

    public boolean is_portal_block(Block block) {
        Map<Long, Map<Long, PortalBlockLookup>> portal_blocks_in_chunk = this.portal_blocks_in_chunk_in_world.get(block.getWorld().getUID());
        if (portal_blocks_in_chunk == null) {
            return false;
        }
        long chunk_key = block.getChunk().getChunkKey();
        Map<Long, PortalBlockLookup> block_to_portal_block = portal_blocks_in_chunk.get(chunk_key);
        if (block_to_portal_block == null) {
            return false;
        }
        return block_to_portal_block.containsKey(Portals.block_key(block));
    }

    public Portal controlled_portal(Block block) {
        Portal root_portal = this.portal_for(block);
        if (root_portal != null) {
            return root_portal;
        }
        for (Block adj : BlockUtil.adjacent_blocks_3d((Block)block)) {
            PortalBlockLookup portal_block = this.portal_block_for(adj);
            if (portal_block == null || portal_block.type() != PortalBlock.Type.CONSOLE) continue;
            return this.portal_for(portal_block);
        }
        return null;
    }

    public Set<Chunk> chunks_for(Portal portal) {
        if (portal == null) {
            return new HashSet<Chunk>();
        }
        HashSet<Chunk> set = new HashSet<Chunk>();
        for (PortalBlock pb : portal.blocks()) {
            set.add(pb.block().getChunk());
        }
        return set;
    }

    public void load_portal_chunks(Portal portal) {
        for (Chunk chunk : this.chunks_for(portal)) {
            long chunk_key = chunk.getChunkKey();
            Integer ticket_counter = this.chunk_ticket_count.get(chunk_key);
            if (ticket_counter == null) {
                chunk.addPluginChunkTicket((Plugin)this);
                this.chunk_ticket_count.put(chunk_key, 1);
                continue;
            }
            this.chunk_ticket_count.put(chunk_key, ticket_counter + 1);
        }
    }

    public void allow_unload_portal_chunks(Portal portal) {
        for (Chunk chunk : this.chunks_for(portal)) {
            long chunk_key = chunk.getChunkKey();
            Integer ticket_counter = this.chunk_ticket_count.get(chunk_key);
            if (ticket_counter > 1) {
                this.chunk_ticket_count.put(chunk_key, ticket_counter - 1);
                continue;
            }
            if (ticket_counter != 1) continue;
            chunk.removePluginChunkTicket((Plugin)this);
            this.chunk_ticket_count.remove(chunk_key);
        }
    }

    public void connect_portals(Portal src, Portal dst) {
        this.load_portal_chunks(src);
        this.load_portal_chunks(dst);
        this.connected_portals.put(src.id(), dst.id());
        this.connected_portals.put(dst.id(), src.id());
        src.on_connect(this, dst);
        dst.on_connect(this, src);
        this.start_disable_task(src, dst);
    }

    public void disconnect_portals(Portal src) {
        this.disconnect_portals(src, this.portal_for(this.connected_portals.get(src.id())));
    }

    public void disconnect_portals(Portal src, Portal dst) {
        if (src == null || dst == null) {
            return;
        }
        this.allow_unload_portal_chunks(src);
        this.allow_unload_portal_chunks(dst);
        this.connected_portals.remove(src.id());
        this.connected_portals.remove(dst.id());
        src.on_disconnect(this, dst);
        dst.on_disconnect(this, src);
        if (dst.visibility().is_transient_target() && !src.target_locked()) {
            src.target_id(null);
            src.update_blocks(this);
        }
        this.stop_disable_task(src, dst);
    }

    private void start_disable_task(Portal portal, Portal target) {
        this.stop_disable_task(portal, target);
        BukkitTask task = this.schedule_task(new PortalDisableRunnable(portal, target), Conversions.ms_to_ticks((long)this.config_deactivation_delay));
        this.disable_tasks.put(portal.id(), task);
        this.disable_tasks.put(target.id(), task);
    }

    private void stop_disable_task(Portal portal, Portal target) {
        BukkitTask task1 = this.disable_tasks.remove(portal.id());
        BukkitTask task2 = this.disable_tasks.remove(target.id());
        if (task1 != null) {
            task1.cancel();
        }
        if (task2 != null && task2 != task1) {
            task2.cancel();
        }
    }

    public void on_disable() {
        for (UUID id : new ArrayList<UUID>(this.connected_portals.keySet())) {
            this.disconnect_portals(this.portal_for(id));
        }
        this.chunk_ticket_count.clear();
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                this.for_each_console_block_in_chunk(chunk, (Consumer2<Block, PortalBlockLookup>)(Consumer2 & Serializable)(block, console) -> this.remove_console_item((Block)block));
                chunk.removePluginChunkTicket((Plugin)this);
            }
        }
        this.update_persistent_data();
        super.on_disable();
    }

    public boolean is_activated(Portal portal) {
        return this.connected_portals.containsKey(portal.id());
    }

    public Portal connected_portal(Portal portal) {
        UUID connected_id = this.connected_portals.get(portal.id());
        if (connected_id == null) {
            return null;
        }
        return this.portal_for(connected_id);
    }

    public ItemStack icon_for(Portal portal) {
        ItemStack item = portal.icon();
        if (item == null) {
            return this.config_default_icon.item();
        }
        return item;
    }

    private ItemStack make_console_item(Portal portal, boolean active) {
        Portal target = active ? this.connected_portal(portal) : portal.target(this);
        ItemStack item = null;
        if (target != null) {
            item = target.icon();
        }
        if (item == null) {
            item = this.config_default_icon.item();
        }
        String target_name = target == null ? this.lang_console_no_target.str(new Object[0]) : target.name();
        Component display_name = active ? this.lang_console_display_active.format(new Object[]{"\u00a75" + target_name}) : this.lang_console_display_inactive.format(new Object[]{"\u00a77" + target_name});
        return ItemUtil.name_item((ItemStack)item, (Component)display_name);
    }

    public void update_portal_icon(Portal portal) {
        this.update_marker(portal);
        for (Block active_console : this.console_floating_items.keySet()) {
            PortalBlockLookup portal_block = this.portal_block_for(active_console);
            Portal other = this.portal_for(portal_block);
            if (!Objects.equals(other.target_id(), portal.id())) continue;
            this.update_console_item(other, active_console);
        }
    }

    public void update_portal_visibility(Portal portal) {
        switch (portal.visibility()) {
            case PRIVATE: 
            case GROUP: {
                for (Portal other : this.portals.values()) {
                    if (!Objects.equals(other.target_id(), portal.id())) continue;
                    other.target_id(null);
                }
                break;
            }
            case GROUP_INTERNAL: {
                for (Portal other : this.portals.values()) {
                    if (!Objects.equals(other.target_id(), portal.id()) || this.is_in_same_region_group(other, portal)) continue;
                    other.target_id(null);
                }
                break;
            }
        }
        this.update_marker(portal);
    }

    public void update_console_item(Portal portal, Block block) {
        boolean is_new;
        FloatingItem console_item = this.console_floating_items.get(block);
        if (console_item == null) {
            console_item = new FloatingItem(block.getWorld(), (double)block.getX() + 0.5, (double)block.getY() + 1.2, (double)block.getZ() + 0.5);
            is_new = true;
        } else {
            is_new = false;
        }
        boolean active = this.is_activated(portal);
        console_item.setItem(Nms.item_handle((ItemStack)this.make_console_item(portal, active)));
        if (is_new) {
            this.console_floating_items.put(block, console_item);
            Nms.spawn((World)block.getWorld(), (Entity)console_item);
        }
    }

    public void remove_console_item(Block block) {
        FloatingItem console_item = this.console_floating_items.remove(block);
        if (console_item != null) {
            console_item.discard();
        }
    }

    private void for_each_console_block_in_chunk(Chunk chunk, Consumer2<Block, PortalBlockLookup> consumer) {
        Map<Long, Map<Long, PortalBlockLookup>> portal_blocks_in_chunk = this.portal_blocks_in_chunk_in_world.get(chunk.getWorld().getUID());
        if (portal_blocks_in_chunk == null) {
            return;
        }
        long chunk_key = chunk.getChunkKey();
        Map<Long, PortalBlockLookup> block_to_portal_block = portal_blocks_in_chunk.get(chunk_key);
        if (block_to_portal_block == null) {
            return;
        }
        block_to_portal_block.forEach((k, v) -> {
            if (v.type() == PortalBlock.Type.CONSOLE) {
                consumer.apply((Object)Portals.unpack_block_key(chunk, k), v);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_monitor_chunk_unload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        this.for_each_console_block_in_chunk(chunk, (Consumer2<Block, PortalBlockLookup>)(Consumer2 & Serializable)(block, console) -> this.remove_console_item((Block)block));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_monitor_chunk_load(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        this.for_each_console_block_in_chunk(chunk, (Consumer2<Block, PortalBlockLookup>)(Consumer2 & Serializable)(block, console) -> {
            Portal portal = this.portal_for(console.portal_id());
            this.update_console_item(portal, (Block)block);
        });
    }

    public void update_marker(Portal portal) {
        this.dynmap_layer.update_marker(portal);
        this.blue_map_layer.update_marker(portal);
    }

    public void remove_marker(UUID portal_id) {
        this.dynmap_layer.remove_marker(portal_id);
        this.blue_map_layer.remove_marker(portal_id);
    }

    @EventHandler
    public void on_save_world(WorldSaveEvent event) {
        this.update_persistent_data(event.getWorld());
    }

    @EventHandler
    public void on_load_world(WorldLoadEvent event) {
        this.load_persistent_data(event.getWorld());
    }

    @EventHandler
    public void on_unload_world(WorldUnloadEvent event) {
        this.update_persistent_data(event.getWorld());
    }

    public void update_persistent_data() {
        for (World world : this.getServer().getWorlds()) {
            this.update_persistent_data(world);
        }
    }

    public void load_persistent_data(World world) {
        PersistentDataContainer data = world.getPersistentDataContainer();
        String storage_portal_prefix = String.valueOf(STORAGE_PORTALS) + ".";
        Set pdc_portals = data.getKeys().stream().filter(key -> key.toString().startsWith(storage_portal_prefix)).map(key -> StringUtils.removeStart((String)key.toString(), (String)storage_portal_prefix)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toSet());
        for (UUID portal_id : pdc_portals) {
            byte[] json_bytes = (byte[])data.get(NamespacedKey.fromString((String)(storage_portal_prefix + portal_id.toString())), PersistentDataType.BYTE_ARRAY);
            try {
                Portal portal = (Portal)PersistentSerializer.from_json(Portal.class, (Object)new JSONObject(new String(json_bytes)));
                this.index_portal(portal);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "error while serializing persistent data!", e);
            }
        }
        this.log.log(Level.INFO, "Loaded " + pdc_portals.size() + " portals for world " + world.getName() + "(" + String.valueOf(world.getUID()) + ")");
        HashSet<UUID> remove_from_legacy_storage = new HashSet<UUID>();
        int converted = 0;
        for (Portal portal : this.storage_portals.values()) {
            if (!portal.spawn_world().equals(world.getUID())) continue;
            if (this.portals.containsKey(portal.id())) {
                remove_from_legacy_storage.add(portal.id());
                continue;
            }
            this.index_portal(portal);
            portal.invalidated = true;
            ++converted;
        }
        remove_from_legacy_storage.forEach(this.storage_portals::remove);
        if (remove_from_legacy_storage.size() > 0) {
            this.mark_persistent_storage_dirty();
        }
        for (Chunk chunk : world.getLoadedChunks()) {
            this.for_each_console_block_in_chunk(chunk, (Consumer2<Block, PortalBlockLookup>)(Consumer2 & Serializable)(block, console) -> {
                Portal portal = this.portal_for(console.portal_id());
                this.update_console_item(portal, (Block)block);
            });
        }
        if (converted > 0) {
            this.update_persistent_data();
        }
    }

    public void update_persistent_data(World world) {
        PersistentDataContainer data = world.getPersistentDataContainer();
        String storage_portal_prefix = String.valueOf(STORAGE_PORTALS) + ".";
        this.portals.values().stream().filter(x -> x.invalidated && x.spawn_world().equals(world.getUID())).forEach(portal -> {
            try {
                Object json = PersistentSerializer.to_json(Portal.class, (Object)portal);
                data.set(NamespacedKey.fromString((String)(storage_portal_prefix + portal.id().toString())), PersistentDataType.BYTE_ARRAY, (Object)json.toString().getBytes());
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "error while serializing persistent data!", e);
                return;
            }
            portal.invalidated = false;
        });
        Set stored_portals = data.getKeys().stream().filter(key -> key.toString().startsWith(storage_portal_prefix)).map(key -> StringUtils.removeStart((String)key.toString(), (String)storage_portal_prefix)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toSet());
        Sets.difference(stored_portals, this.portals.keySet()).forEach(id -> data.remove(NamespacedKey.fromString((String)(storage_portal_prefix + id.toString()))));
    }

    private static /* synthetic */ void lambda$on_config_change$7(Style style, boolean active, String portal_block_type, Material material) {
        PortalBlock.Type type = PortalBlock.Type.valueOf(portal_block_type.toUpperCase());
        style.set_material(active, type, material);
    }

    static {
        PersistentSerializer.serializers.put(Orientation.class, x -> ((Orientation)((Object)((Object)x))).name());
        PersistentSerializer.deserializers.put(Orientation.class, x -> Orientation.valueOf((String)x));
        PersistentSerializer.serializers.put(Portal.class, Portal::serialize);
        PersistentSerializer.deserializers.put(Portal.class, Portal::deserialize);
        PersistentSerializer.serializers.put(Portal.Visibility.class, x -> ((Portal.Visibility)((Object)((Object)x))).name());
        PersistentSerializer.deserializers.put(Portal.Visibility.class, x -> Portal.Visibility.valueOf((String)x));
        PersistentSerializer.serializers.put(PortalBlock.class, PortalBlock::serialize);
        PersistentSerializer.deserializers.put(PortalBlock.class, PortalBlock::deserialize);
        PersistentSerializer.serializers.put(PortalBlock.Type.class, x -> ((PortalBlock.Type)((Object)((Object)x))).name());
        PersistentSerializer.deserializers.put(PortalBlock.Type.class, x -> PortalBlock.Type.valueOf((String)x));
        PersistentSerializer.serializers.put(PortalBlockLookup.class, PortalBlockLookup::serialize);
        PersistentSerializer.deserializers.put(PortalBlockLookup.class, PortalBlockLookup::deserialize);
        PersistentSerializer.serializers.put(Style.class, Style::serialize);
        PersistentSerializer.deserializers.put(Style.class, Style::deserialize);
        STORAGE_PORTALS = StorageUtil.namespaced_key((String)"vane_portals", (String)"portals");
    }

    private class PortalDisableRunnable
    implements Runnable {
        private Portal src;
        private Portal dst;

        public PortalDisableRunnable(Portal src, Portal dst) {
            this.src = src;
            this.dst = dst;
        }

        @Override
        public void run() {
            Portals.this.disconnect_portals(this.src, this.dst);
        }
    }
}

