/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.entity;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.util.Nms;

public class FloatingItem
extends ItemEntity {
    public FloatingItem(Location location) {
        this(location.getWorld(), location.getX(), location.getY(), location.getZ());
    }

    public FloatingItem(World world, double x, double y, double z) {
        this(EntityType.ITEM, (Level)Nms.world_handle((World)world));
        this.setPos(x, y, z);
    }

    public FloatingItem(EntityType<?> entitytypes, Level world) {
        super(entitytypes, world);
        this.setSilent(true);
        this.setInvulnerable(true);
        this.setNoGravity(true);
        this.setNeverPickUp();
        this.setUnlimitedLifetime();
        this.persist = false;
        this.noPhysics = true;
    }

    public boolean isAlive() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void tick() {
    }

    public void inactiveTick() {
    }

    public void readAdditionalSaveData(@NotNull ValueInput output) {
    }

    protected void addAdditionalSaveData(@NotNull ValueOutput output) {
    }

    public boolean save(@NotNull ValueOutput output) {
        return false;
    }

    public void saveWithoutId(@NotNull ValueOutput output) {
    }

    public void load(@NotNull ValueInput output) {
    }

    public void setItem(@NotNull ItemStack itemStack) {
        super.setItem(itemStack);
        if (itemStack.getHoverName().toFlatList().isEmpty()) {
            this.setCustomNameVisible(false);
        } else {
            this.setCustomNameVisible(true);
            this.setCustomName(itemStack.getHoverName());
        }
    }
}

