/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.event;

import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.oddlama.vane.portals.event.PortalEvent;
import org.oddlama.vane.portals.portal.Portal;

public class PortalChangeSettingsEvent
extends PortalEvent {
    private static final HandlerList handlers = new HandlerList();
    private Player player;
    private Portal portal;
    private boolean check_only;
    private boolean cancel_if_not_owner = true;

    public PortalChangeSettingsEvent(Player player, Portal portal, boolean check_only) {
        this.player = player;
        this.portal = portal;
        this.check_only = check_only;
    }

    public void setCancelIfNotOwner(boolean cancel_if_not_owner) {
        this.cancel_if_not_owner = cancel_if_not_owner;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public boolean checkOnly() {
        return this.check_only;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public boolean isCancelled() {
        boolean cancelled = super.isCancelled();
        if (this.cancel_if_not_owner) {
            cancelled |= !this.player.getUniqueId().equals(this.portal.owner());
        }
        return cancelled;
    }
}

