/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.event;

import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.portals.event.PortalEvent;
import org.oddlama.vane.portals.portal.Portal;

public class PortalLinkConsoleEvent
extends PortalEvent {
    private static final HandlerList handlers = new HandlerList();
    private Player player;
    private Portal portal;
    private Block console;
    private List<Block> portal_blocks;
    private boolean check_only;
    private boolean cancel_if_not_owner = true;

    public PortalLinkConsoleEvent(Player player, Block console, List<Block> portal_blocks, boolean check_only, @Nullable Portal portal) {
        this.player = player;
        this.console = console;
        this.portal_blocks = portal_blocks;
        this.check_only = check_only;
        this.portal = portal;
    }

    public void setCancelIfNotOwner(boolean cancel_if_not_owner) {
        this.cancel_if_not_owner = cancel_if_not_owner;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Block getConsole() {
        return this.console;
    }

    public List<Block> getPortalBlocks() {
        return this.portal_blocks;
    }

    public boolean checkOnly() {
        return this.check_only;
    }

    @Nullable
    public Portal getPortal() {
        return this.portal;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public boolean isCancelled() {
        boolean cancelled = super.isCancelled();
        if (this.cancel_if_not_owner && this.portal != null) {
            cancelled |= !this.player.getUniqueId().equals(this.portal.owner());
        }
        return cancelled;
    }
}

