/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.menu;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.PortalChangeSettingsEvent;
import org.oddlama.vane.portals.event.PortalDestroyEvent;
import org.oddlama.vane.portals.event.PortalSelectTargetEvent;
import org.oddlama.vane.portals.event.PortalUnlinkConsoleEvent;
import org.oddlama.vane.portals.menu.PortalMenuTag;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.util.StorageUtil;

public class ConsoleMenu
extends ModuleComponent<Portals> {
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_unlink_console_confirm_title;
    @LangMessage
    public TranslatedMessage lang_destroy_portal_confirm_title;
    @LangMessage
    public TranslatedMessage lang_select_target_title;
    @LangMessage
    public TranslatedMessage lang_filter_portals_title;
    @LangMessage
    public TranslatedMessage lang_select_target_portal_visibility_public;
    @LangMessage
    public TranslatedMessage lang_select_target_portal_visibility_private;
    @LangMessage
    public TranslatedMessage lang_select_target_portal_visibility_group;
    @LangMessage
    public TranslatedMessage lang_select_target_portal_visibility_group_internal;
    public TranslatedItemStack<?> item_settings;
    public TranslatedItemStack<?> item_select_target;
    public TranslatedItemStack<?> item_select_target_portal;
    public TranslatedItemStack<?> item_select_target_locked;
    public TranslatedItemStack<?> item_unlink_console;
    public TranslatedItemStack<?> item_unlink_console_confirm_accept;
    public TranslatedItemStack<?> item_unlink_console_confirm_cancel;
    public TranslatedItemStack<?> item_destroy_portal;
    public TranslatedItemStack<?> item_destroy_portal_confirm_accept;
    public TranslatedItemStack<?> item_destroy_portal_confirm_cancel;

    public ConsoleMenu(Context<Portals> context) {
        super((Context)context.namespace("console"));
        Context ctx = this.get_context();
        this.item_settings = new TranslatedItemStack(ctx, "settings", Material.WRITABLE_BOOK, 1, "Used to enter portal settings.");
        this.item_select_target = new TranslatedItemStack(ctx, "select_target", Material.COMPASS, 1, "Used to enter portal target selection.");
        this.item_select_target_portal = new TranslatedItemStack(ctx, "select_target_portal", Material.COMPASS, 1, "Used to represent a portal in the target selection menu.");
        this.item_select_target_locked = new TranslatedItemStack(ctx, "select_target_locked", Material.FIREWORK_STAR, 1, "Used to show portal target selection when the target is locked.");
        this.item_unlink_console = new TranslatedItemStack(ctx, "unlink_console", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to unlink the current console.");
        this.item_unlink_console_confirm_accept = new TranslatedItemStack(ctx, "unlink_console_confirm_accept", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to confirm unlinking the current console.");
        this.item_unlink_console_confirm_cancel = new TranslatedItemStack(ctx, "unlink_console_confirm_cancel", Material.PRISMARINE_SHARD, 1, "Used to cancel unlinking the current console.");
        this.item_destroy_portal = new TranslatedItemStack(ctx, "destroy_portal", Material.TNT, 1, "Used to destroy the portal.");
        this.item_destroy_portal_confirm_accept = new TranslatedItemStack(ctx, "destroy_portal_confirm_accept", Material.TNT, 1, "Used to confirm destroying the portal.");
        this.item_destroy_portal_confirm_cancel = new TranslatedItemStack(ctx, "destroy_portal_confirm_cancel", Material.PRISMARINE_SHARD, 1, "Used to cancel destroying the portal.");
    }

    public Menu create(Portal portal, Player player, Block console) {
        int columns = 9;
        Component title = this.lang_title.str_component(new Object[]{"\u00a75\u00a7l" + portal.name()});
        Menu console_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)9, (Component)title));
        console_menu.tag((Object)new PortalMenuTag(portal.id()));
        PortalSelectTargetEvent select_target_event = new PortalSelectTargetEvent(player, portal, null, true);
        ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)select_target_event);
        if (!select_target_event.isCancelled() || player.hasPermission(((Portals)this.get_module()).admin_permission)) {
            console_menu.add(this.menu_item_select_target(portal));
        }
        PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent(player, portal, true);
        ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
        if (!settings_event.isCancelled() || player.hasPermission(((Portals)this.get_module()).admin_permission)) {
            console_menu.add(this.menu_item_settings(portal, console));
        }
        PortalUnlinkConsoleEvent unlink_event = new PortalUnlinkConsoleEvent(player, console, portal, true);
        ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)unlink_event);
        if (!unlink_event.isCancelled() || player.hasPermission(((Portals)this.get_module()).admin_permission)) {
            console_menu.add(this.menu_item_unlink_console(portal, console));
        }
        PortalDestroyEvent destroy_event = new PortalDestroyEvent(player, portal, true);
        ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)destroy_event);
        if (!destroy_event.isCancelled() || player.hasPermission(((Portals)this.get_module()).admin_permission)) {
            console_menu.add(this.menu_item_destroy_portal(portal));
        }
        return console_menu;
    }

    private MenuWidget menu_item_settings(Portal portal, Block console) {
        return new MenuItem(0, this.item_settings.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player, portal, false);
            ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
            if (settings_event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
                ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player, new Object[0]);
                return Menu.ClickResult.ERROR;
            }
            menu.close(player);
            ((Portals)this.get_module()).menus.settings_menu.create(portal, (Player)player, console).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private Component portal_visibility(Portal.Visibility visibility) {
        return (switch (visibility) {
            default -> throw new MatchException(null, null);
            case Portal.Visibility.PUBLIC -> this.lang_select_target_portal_visibility_public;
            case Portal.Visibility.GROUP -> this.lang_select_target_portal_visibility_group;
            case Portal.Visibility.GROUP_INTERNAL -> this.lang_select_target_portal_visibility_group_internal;
            case Portal.Visibility.PRIVATE -> this.lang_select_target_portal_visibility_private;
        }).format(new Object[0]);
    }

    private MenuWidget menu_item_select_target(final Portal portal) {
        return new MenuItem(4, null, (Function3 & Serializable)(player, menu, self) -> {
            if (portal.target_locked()) {
                return Menu.ClickResult.ERROR;
            }
            menu.close(player);
            List all_portals = ((Portals)this.get_module()).all_available_portals().stream().filter(p -> {
                switch (p.visibility()) {
                    case PUBLIC: {
                        return true;
                    }
                    case GROUP: {
                        return ((Portals)this.get_module()).player_can_use_portals_in_region_group_of((Player)player, (Portal)p);
                    }
                    case GROUP_INTERNAL: {
                        return ((Portals)this.get_module()).is_in_same_region_group(portal, (Portal)p);
                    }
                    case PRIVATE: {
                        return player.getUniqueId().equals(p.owner());
                    }
                }
                return false;
            }).filter(p -> !Objects.equals(p.id(), portal.id())).sorted(new Portal.TargetSelectionComparator((Player)player)).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(p, str) -> p.name().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_target_title.str(new Object[0]), (String)this.lang_filter_portals_title.str(new Object[0]), all_portals, (Function1 & Serializable)p -> {
                double dist = p.spawn().toVector().setY(0.0).distance(player.getLocation().toVector().setY(0.0));
                return this.item_select_target_portal.alternative(((Portals)this.get_module()).icon_for((Portal)p), new Object[]{"\u00a7a\u00a7l" + p.name(), "\u00a76" + String.format("%.1f", dist), "\u00a7b" + p.spawn().getWorld().getName(), this.portal_visibility(p.visibility())});
            }, (Filter)filter, (Function3 & Serializable)(player2, m, t) -> {
                m.close(player2);
                PortalSelectTargetEvent select_target_event = new PortalSelectTargetEvent((Player)player2, portal, (Portal)t, false);
                ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)select_target_event);
                if (select_target_event.isCancelled() && !player2.hasPermission(((Portals)this.get_module()).admin_permission)) {
                    ((Portals)this.get_module()).lang_select_target_restricted.send((CommandSender)player2, new Object[0]);
                    return Menu.ClickResult.ERROR;
                }
                portal.target_id(t.id());
                portal.update_blocks((Portals)this.get_module());
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new PortalMenuTag(portal.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                Portal target = portal.target((Portals)ConsoleMenu.this.get_module());
                String target_name = "\u00a7a" + (target == null ? "None" : target.name());
                if (portal.target_locked()) {
                    super.item(ConsoleMenu.this.item_select_target_locked.item(new Object[]{target_name}));
                } else {
                    super.item(ConsoleMenu.this.item_select_target.item(new Object[]{target_name}));
                }
            }
        };
    }

    private MenuWidget menu_item_unlink_console(Portal portal, Block console) {
        return new MenuItem(7, this.item_unlink_console.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            MenuFactory.confirm((Context)this.get_context(), (String)this.lang_unlink_console_confirm_title.str(new Object[0]), (ItemStack)this.item_unlink_console_confirm_accept.item(new Object[0]), (Function1 & Serializable)player2 -> {
                PortalUnlinkConsoleEvent event = new PortalUnlinkConsoleEvent((Player)player2, console, portal, false);
                ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled() && !player2.hasPermission(((Portals)this.get_module()).admin_permission)) {
                    ((Portals)this.get_module()).lang_unlink_restricted.send((CommandSender)player2, new Object[0]);
                    return Menu.ClickResult.ERROR;
                }
                PortalBlock portal_block = portal.portal_block_for(console);
                if (portal_block == null) {
                    return Menu.ClickResult.ERROR;
                }
                ((Portals)this.get_module()).remove_portal_block(portal, portal_block);
                return Menu.ClickResult.SUCCESS;
            }, (ItemStack)this.item_unlink_console_confirm_cancel.item(new Object[0]), (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new PortalMenuTag(portal.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_destroy_portal(Portal portal) {
        return new MenuItem(8, this.item_destroy_portal.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            MenuFactory.confirm((Context)this.get_context(), (String)this.lang_destroy_portal_confirm_title.str(new Object[0]), (ItemStack)this.item_destroy_portal_confirm_accept.item(new Object[0]), (Function1 & Serializable)player2 -> {
                PortalDestroyEvent event = new PortalDestroyEvent((Player)player2, portal, false);
                ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled() && !player2.hasPermission(((Portals)this.get_module()).admin_permission)) {
                    ((Portals)this.get_module()).lang_destroy_restricted.send((CommandSender)player2, new Object[0]);
                    return Menu.ClickResult.ERROR;
                }
                ((Portals)this.get_module()).remove_portal(portal);
                return Menu.ClickResult.SUCCESS;
            }, (ItemStack)this.item_destroy_portal_confirm_cancel.item(new Object[0]), (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new PortalMenuTag(portal.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }
}

