/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.menu;

import java.io.Serializable;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.PortalChangeSettingsEvent;
import org.oddlama.vane.portals.menu.PortalMenuTag;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.util.StorageUtil;

public class SettingsMenu
extends ModuleComponent<Portals> {
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_select_icon_title;
    public TranslatedItemStack<?> item_rename;
    public TranslatedItemStack<?> item_select_icon;
    public TranslatedItemStack<?> item_select_style;
    public TranslatedItemStack<?> item_exit_orientation_lock_on;
    public TranslatedItemStack<?> item_exit_orientation_lock_off;
    public TranslatedItemStack<?> item_visibility_public;
    public TranslatedItemStack<?> item_visibility_group;
    public TranslatedItemStack<?> item_visibility_group_internal;
    public TranslatedItemStack<?> item_visibility_private;
    public TranslatedItemStack<?> item_target_lock_on;
    public TranslatedItemStack<?> item_target_lock_off;
    public TranslatedItemStack<?> item_back;

    public SettingsMenu(Context<Portals> context) {
        super((Context)context.namespace("settings"));
        Context ctx = this.get_context();
        this.item_rename = new TranslatedItemStack(ctx, "rename", Material.NAME_TAG, 1, "Used to rename the portal.");
        this.item_select_icon = new TranslatedItemStack(ctx, "select_icon", StorageUtil.namespaced_key((String)"vane", (String)"decoration_end_portal_orb"), 1, "Used to select the portal's icon.");
        this.item_select_style = new TranslatedItemStack(ctx, "select_style", Material.ITEM_FRAME, 1, "Used to change the portal's style.");
        this.item_exit_orientation_lock_on = new TranslatedItemStack(ctx, "exit_orientation_lock_on", Material.SOUL_TORCH, 1, "Used to toggle and indicate enabled exit orientation lock.");
        this.item_exit_orientation_lock_off = new TranslatedItemStack(ctx, "exit_orientation_lock_off", Material.TORCH, 1, "Used to toggle and indicate disabled exit orientation lock.");
        this.item_visibility_public = new TranslatedItemStack(ctx, "visibility_public", Material.ENDER_EYE, 1, "Used to change and indicate public visibility.");
        this.item_visibility_group = new TranslatedItemStack(ctx, "visibility_group", Material.ENDER_PEARL, 1, "Used to change and indicate group visibility.");
        this.item_visibility_group_internal = new TranslatedItemStack(ctx, "visibility_group_internal", Material.FIRE_CHARGE, 1, "Used to change and indicate group internal visibility.");
        this.item_visibility_private = new TranslatedItemStack(ctx, "visibility_private", Material.FIREWORK_STAR, 1, "Used to change and indicate private visibility.");
        this.item_target_lock_on = new TranslatedItemStack(ctx, "target_lock_on", Material.SLIME_BALL, 1, "Used to toggle and indicate enabled target lock.");
        this.item_target_lock_off = new TranslatedItemStack(ctx, "target_lock_off", Material.SNOWBALL, 1, "Used to toggle and indicate disabled target lock.");
        this.item_back = new TranslatedItemStack(ctx, "back", Material.PRISMARINE_SHARD, 1, "Used to go back to the previous menu.");
    }

    public Menu create(Portal portal, Player player, Block console) {
        int columns = 9;
        Component title = this.lang_title.str_component(new Object[]{"\u00a75\u00a7l" + portal.name()});
        Menu settings_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)9, (Component)title));
        settings_menu.tag((Object)new PortalMenuTag(portal.id()));
        settings_menu.add(this.menu_item_rename(portal, console));
        settings_menu.add(this.menu_item_select_icon(portal));
        settings_menu.add(this.menu_item_select_style(portal));
        settings_menu.add(this.menu_item_exit_orientation_lock(portal));
        settings_menu.add(this.menu_item_visibility(portal));
        settings_menu.add(this.menu_item_target_lock(portal));
        settings_menu.add(this.menu_item_back(portal, console));
        settings_menu.on_natural_close((Consumer1 & Serializable)player2 -> ((Portals)this.get_module()).menus.console_menu.create(portal, (Player)player2, console).open(player2));
        return settings_menu;
    }

    private MenuWidget menu_item_rename(Portal portal, Block console) {
        return new MenuItem(0, this.item_rename.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Portals)this.get_module()).menus.enter_name_menu.create((Player)player, portal.name(), (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player2, portal, false);
                ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
                if (settings_event.isCancelled() && !player2.hasPermission(((Portals)this.get_module()).admin_permission)) {
                    ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player2, new Object[0]);
                    return Menu.ClickResult.ERROR;
                }
                portal.name((String)name);
                ((Portals)this.get_module()).update_portal_icon(portal);
                ((Portals)this.get_module()).menus.settings_menu.create(portal, (Player)player2, console).open(player2);
                return Menu.ClickResult.SUCCESS;
            }).on_natural_close((Consumer1 & Serializable)player2 -> ((Portals)this.get_module()).menus.settings_menu.create(portal, (Player)player2, console).open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_select_icon(Portal portal) {
        return new MenuItem(1, this.item_select_icon.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            MenuFactory.item_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_icon_title.str(new Object[0]), (ItemStack)portal.icon(), (boolean)true, (Function2 & Serializable)(player2, item) -> {
                PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player2, portal, false);
                ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
                if (settings_event.isCancelled() && !player2.hasPermission(((Portals)this.get_module()).admin_permission)) {
                    ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player2, new Object[0]);
                    return Menu.ClickResult.ERROR;
                }
                portal.icon((ItemStack)item);
                ((Portals)this.get_module()).update_portal_icon(portal);
                menu.open(player2);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new PortalMenuTag(portal.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_select_style(Portal portal) {
        return new MenuItem(2, this.item_select_style.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player, portal, false);
            ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
            if (settings_event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
                ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player, new Object[0]);
                return Menu.ClickResult.ERROR;
            }
            menu.close(player);
            ((Portals)this.get_module()).menus.style_menu.create(portal, (Player)player, (Menu)menu).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_exit_orientation_lock(final Portal portal) {
        return new MenuItem(4, null, (Function3 & Serializable)(player, menu, self) -> {
            PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player, portal, false);
            ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
            if (settings_event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
                ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player, new Object[0]);
                return Menu.ClickResult.ERROR;
            }
            portal.exit_orientation_locked(!portal.exit_orientation_locked());
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                if (portal.exit_orientation_locked()) {
                    super.item(SettingsMenu.this.item_exit_orientation_lock_on.item(new Object[0]));
                } else {
                    super.item(SettingsMenu.this.item_exit_orientation_lock_off.item(new Object[0]));
                }
            }
        };
    }

    private MenuWidget menu_item_visibility(final Portal portal) {
        return new MenuItem(5, null, (Function4 & Serializable)(player, menu, self, event) -> {
            if (!Menu.is_left_or_right_click((InventoryClickEvent)event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player, portal, false);
            ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
            if (settings_event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
                ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player, new Object[0]);
                return Menu.ClickResult.ERROR;
            }
            Portal.Visibility new_vis = portal.visibility();
            do {
                Portal.Visibility visibility = new_vis = event.getClick() == ClickType.RIGHT ? new_vis.prev() : new_vis.next();
            } while (new_vis.requires_regions() && !((Portals)this.get_module()).is_regions_installed());
            portal.visibility(new_vis);
            ((Portals)this.get_module()).update_portal_visibility(portal);
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                switch (portal.visibility()) {
                    case PUBLIC: {
                        super.item(SettingsMenu.this.item_visibility_public.item(new Object[0]));
                        break;
                    }
                    case GROUP: {
                        super.item(SettingsMenu.this.item_visibility_group.item(new Object[0]));
                        break;
                    }
                    case GROUP_INTERNAL: {
                        super.item(SettingsMenu.this.item_visibility_group_internal.item(new Object[0]));
                        break;
                    }
                    case PRIVATE: {
                        super.item(SettingsMenu.this.item_visibility_private.item(new Object[0]));
                    }
                }
            }
        };
    }

    private MenuWidget menu_item_target_lock(final Portal portal) {
        return new MenuItem(6, null, (Function3 & Serializable)(player, menu, self) -> {
            PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player, portal, false);
            ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
            if (settings_event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
                ((Portals)this.get_module()).lang_settings_restricted.send((CommandSender)player, new Object[0]);
                return Menu.ClickResult.ERROR;
            }
            portal.target_locked(!portal.target_locked());
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                if (portal.target_locked()) {
                    super.item(SettingsMenu.this.item_target_lock_on.item(new Object[0]));
                } else {
                    super.item(SettingsMenu.this.item_target_lock_off.item(new Object[0]));
                }
            }
        };
    }

    private MenuWidget menu_item_back(Portal portal, Block console) {
        return new MenuItem(8, this.item_back.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Portals)this.get_module()).menus.console_menu.create(portal, (Player)player, console).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }
}

