/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.VoxelShape;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.PortalChangeSettingsEvent;
import org.oddlama.vane.portals.menu.PortalMenuTag;
import org.oddlama.vane.portals.portal.Portal;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.portals.portal.Style;

public class StyleMenu
extends ModuleComponent<Portals> {
    private static final int columns = 9;
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_select_block_console_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_origin_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_portal_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_1_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_2_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_3_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_4_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_5_active_title;
    @LangMessage
    public TranslatedMessage lang_select_block_console_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_origin_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_portal_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_1_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_2_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_3_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_4_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_block_boundary_5_inactive_title;
    @LangMessage
    public TranslatedMessage lang_select_style_title;
    @LangMessage
    public TranslatedMessage lang_filter_styles_title;
    private TranslatedItemStack<?> item_block_console_active;
    private TranslatedItemStack<?> item_block_origin_active;
    private TranslatedItemStack<?> item_block_portal_active;
    private TranslatedItemStack<?> item_block_boundary_1_active;
    private TranslatedItemStack<?> item_block_boundary_2_active;
    private TranslatedItemStack<?> item_block_boundary_3_active;
    private TranslatedItemStack<?> item_block_boundary_4_active;
    private TranslatedItemStack<?> item_block_boundary_5_active;
    private TranslatedItemStack<?> item_block_console_inactive;
    private TranslatedItemStack<?> item_block_origin_inactive;
    private TranslatedItemStack<?> item_block_portal_inactive;
    private TranslatedItemStack<?> item_block_boundary_1_inactive;
    private TranslatedItemStack<?> item_block_boundary_2_inactive;
    private TranslatedItemStack<?> item_block_boundary_3_inactive;
    private TranslatedItemStack<?> item_block_boundary_4_inactive;
    private TranslatedItemStack<?> item_block_boundary_5_inactive;
    private TranslatedItemStack<?> item_accept;
    private TranslatedItemStack<?> item_reset;
    private TranslatedItemStack<?> item_select_defined;
    private TranslatedItemStack<?> item_select_style;
    private TranslatedItemStack<?> item_cancel;

    public StyleMenu(Context<Portals> context) {
        super((Context)context.namespace("style"));
        Context ctx = this.get_context();
        this.item_block_console_active = new TranslatedItemStack(ctx, "block_console_active", Material.BARRIER, 1, "Used to select active console block.");
        this.item_block_origin_active = new TranslatedItemStack(ctx, "block_origin_active", Material.BARRIER, 1, "Used to select active origin block.");
        this.item_block_portal_active = new TranslatedItemStack(ctx, "block_portal_active", Material.BARRIER, 1, "Used to select active portal area block. Defaults to end gateway if unset.");
        this.item_block_boundary_1_active = new TranslatedItemStack(ctx, "block_boundary_1_active", Material.BARRIER, 1, "Used to select active boundary variant 1 block.");
        this.item_block_boundary_2_active = new TranslatedItemStack(ctx, "block_boundary_2_active", Material.BARRIER, 1, "Used to select active boundary variant 2 block.");
        this.item_block_boundary_3_active = new TranslatedItemStack(ctx, "block_boundary_3_active", Material.BARRIER, 1, "Used to select active boundary variant 3 block.");
        this.item_block_boundary_4_active = new TranslatedItemStack(ctx, "block_boundary_4_active", Material.BARRIER, 1, "Used to select active boundary variant 4 block.");
        this.item_block_boundary_5_active = new TranslatedItemStack(ctx, "block_boundary_5_active", Material.BARRIER, 1, "Used to select active boundary variant 5 block.");
        this.item_block_console_inactive = new TranslatedItemStack(ctx, "block_console_inactive", Material.BARRIER, 1, "Used to select inactive console block.");
        this.item_block_origin_inactive = new TranslatedItemStack(ctx, "block_origin_inactive", Material.BARRIER, 1, "Used to select inactive origin block.");
        this.item_block_portal_inactive = new TranslatedItemStack(ctx, "block_portal_inactive", Material.BARRIER, 1, "Used to select inactive portal area block.");
        this.item_block_boundary_1_inactive = new TranslatedItemStack(ctx, "block_boundary_1_inactive", Material.BARRIER, 1, "Used to select inactive boundary variant 1 block.");
        this.item_block_boundary_2_inactive = new TranslatedItemStack(ctx, "block_boundary_2_inactive", Material.BARRIER, 1, "Used to select inactive boundary variant 2 block.");
        this.item_block_boundary_3_inactive = new TranslatedItemStack(ctx, "block_boundary_3_inactive", Material.BARRIER, 1, "Used to select inactive boundary variant 3 block.");
        this.item_block_boundary_4_inactive = new TranslatedItemStack(ctx, "block_boundary_4_inactive", Material.BARRIER, 1, "Used to select inactive boundary variant 4 block.");
        this.item_block_boundary_5_inactive = new TranslatedItemStack(ctx, "block_boundary_5_inactive", Material.BARRIER, 1, "Used to select inactive boundary variant 5 block.");
        this.item_accept = new TranslatedItemStack(ctx, "accept", Material.LIME_TERRACOTTA, 1, "Used to apply the style.");
        this.item_reset = new TranslatedItemStack(ctx, "reset", Material.MILK_BUCKET, 1, "Used to reset any changes.");
        this.item_select_defined = new TranslatedItemStack(ctx, "select_defined", Material.ITEM_FRAME, 1, "Used to select a defined style from the configuration.");
        this.item_select_style = new TranslatedItemStack(ctx, "select_style", Material.ITEM_FRAME, 1, "Used to represent a defined style in the selector menu.");
        this.item_cancel = new TranslatedItemStack(ctx, "cancel", Material.RED_TERRACOTTA, 1, "Used to abort style selection.");
    }

    public Menu create(Portal portal, Player player, Menu previous) {
        Component title = this.lang_title.str_component(new Object[]{"\u00a75\u00a7l" + portal.name()});
        Menu style_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)36, (Component)title));
        style_menu.tag((Object)new PortalMenuTag(portal.id()));
        StyleContainer style_container = new StyleContainer();
        style_container.defined_style = portal.style();
        style_container.style = portal.copy_style((Portals)this.get_module(), null);
        style_menu.add(this.menu_item_block_selector(portal, style_container, 0, this.item_block_console_inactive, ((Portals)this.get_module()).constructor.config_material_console, this.lang_select_block_console_inactive_title.str(new Object[0]), PortalBlock.Type.CONSOLE, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 1, this.item_block_origin_inactive, ((Portals)this.get_module()).constructor.config_material_origin, this.lang_select_block_origin_inactive_title.str(new Object[0]), PortalBlock.Type.ORIGIN, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 2, this.item_block_portal_inactive, ((Portals)this.get_module()).constructor.config_material_portal_area, this.lang_select_block_portal_inactive_title.str(new Object[0]), PortalBlock.Type.PORTAL, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 4, this.item_block_boundary_1_inactive, ((Portals)this.get_module()).constructor.config_material_boundary_1, this.lang_select_block_boundary_1_inactive_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_1, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 5, this.item_block_boundary_2_inactive, ((Portals)this.get_module()).constructor.config_material_boundary_2, this.lang_select_block_boundary_2_inactive_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_2, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 6, this.item_block_boundary_3_inactive, ((Portals)this.get_module()).constructor.config_material_boundary_3, this.lang_select_block_boundary_3_inactive_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_3, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 7, this.item_block_boundary_4_inactive, ((Portals)this.get_module()).constructor.config_material_boundary_4, this.lang_select_block_boundary_4_inactive_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_4, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 8, this.item_block_boundary_5_inactive, ((Portals)this.get_module()).constructor.config_material_boundary_5, this.lang_select_block_boundary_5_inactive_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_5, false));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 9, this.item_block_console_active, ((Portals)this.get_module()).constructor.config_material_console, this.lang_select_block_console_active_title.str(new Object[0]), PortalBlock.Type.CONSOLE, true));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 10, this.item_block_origin_active, ((Portals)this.get_module()).constructor.config_material_origin, this.lang_select_block_origin_active_title.str(new Object[0]), PortalBlock.Type.ORIGIN, true));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 13, this.item_block_boundary_1_active, ((Portals)this.get_module()).constructor.config_material_boundary_1, this.lang_select_block_boundary_1_active_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_1, true));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 14, this.item_block_boundary_2_active, ((Portals)this.get_module()).constructor.config_material_boundary_2, this.lang_select_block_boundary_2_active_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_2, true));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 15, this.item_block_boundary_3_active, ((Portals)this.get_module()).constructor.config_material_boundary_3, this.lang_select_block_boundary_3_active_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_3, true));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 16, this.item_block_boundary_4_active, ((Portals)this.get_module()).constructor.config_material_boundary_4, this.lang_select_block_boundary_4_active_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_4, true));
        style_menu.add(this.menu_item_block_selector(portal, style_container, 17, this.item_block_boundary_5_active, ((Portals)this.get_module()).constructor.config_material_boundary_5, this.lang_select_block_boundary_5_active_title.str(new Object[0]), PortalBlock.Type.BOUNDARY_5, true));
        style_menu.add(this.menu_item_accept(portal, style_container, previous));
        style_menu.add(this.menu_item_reset(portal, style_container));
        style_menu.add(this.menu_item_select_defined(portal, style_container));
        style_menu.add(this.menu_item_cancel(previous));
        style_menu.on_natural_close((Consumer1 & Serializable)player2 -> previous.open(player2));
        return style_menu;
    }

    private static ItemStack item_for_type(StyleContainer style_container, boolean active, PortalBlock.Type type) {
        if (active && type == PortalBlock.Type.PORTAL) {
            return new ItemStack(Material.AIR);
        }
        return new ItemStack(style_container.style.material(active, type));
    }

    private MenuWidget menu_item_block_selector(Portal portal, final StyleContainer style_container, int slot, final TranslatedItemStack<?> t_item, final Material building_material, String title, final PortalBlock.Type type, final boolean active) {
        return new MenuItem(this, slot, null, (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            MenuFactory.item_selector((Context)this.get_context(), (Player)player, (String)title, (ItemStack)StyleMenu.item_for_type(style_container, active, type), (boolean)true, (Function2 & Serializable)(player2, item) -> {
                style_container.defined_style = null;
                if (item == null) {
                    if (active && type == PortalBlock.Type.PORTAL) {
                        style_container.style.set_material(active, type, Material.END_GATEWAY, true);
                    }
                    style_container.style.set_material(active, type, Material.AIR, true);
                } else {
                    style_container.style.set_material(active, type, item.getType(), true);
                }
                menu.open(player2);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2), (Function1 & Serializable)item -> {
                if (item == null || !item.getType().isBlock() || !item.getType().isSolid()) {
                    return null;
                }
                if (((Portals)this.get_module()).config_blacklisted_materials.contains(item.getType())) {
                    return null;
                }
                BlockType block = item.getType().asBlockType();
                if (block == null) {
                    return null;
                }
                BlockData blockdata = block.createBlockData();
                VoxelShape voxelshape = blockdata.getCollisionShape(player.getLocation());
                Collection bbs = voxelshape.getBoundingBoxes();
                if (bbs.size() != 1 || !bbs.stream().allMatch(x -> x.getWidthX() == 1.0 && x.getWidthZ() == 1.0 && x.getHeight() == 1.0)) {
                    return null;
                }
                item.setAmount(1);
                return item;
            }).tag((Object)new PortalMenuTag(portal.id())).open(player);
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                ItemStack stack = StyleMenu.item_for_type(style_container, active, type);
                if (stack.getType() == Material.AIR) {
                    stack = new ItemStack(Material.BARRIER);
                }
                super.item(t_item.alternative(stack, new Object[]{"\u00a76" + String.valueOf(building_material.getKey())}));
            }
        };
    }

    private MenuWidget menu_item_accept(Portal portal, StyleContainer style_container, Menu previous) {
        return new MenuItem(27, this.item_accept.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            PortalChangeSettingsEvent settings_event = new PortalChangeSettingsEvent((Player)player, portal, false);
            ((Portals)this.get_module()).getServer().getPluginManager().callEvent((Event)settings_event);
            if (settings_event.isCancelled() && !player.hasPermission(((Portals)this.get_module()).admin_permission)) {
                return Menu.ClickResult.ERROR;
            }
            portal.style(style_container.style);
            portal.update_blocks((Portals)this.get_module());
            previous.open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_reset(Portal portal, StyleContainer style_container) {
        return new MenuItem(30, this.item_reset.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            style_container.style = portal.copy_style((Portals)this.get_module(), null);
            menu.update();
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_select_defined(Portal portal, StyleContainer style_container) {
        Function1 & Serializable item_for = (Function1 & Serializable)style -> {
            Material mat = style.material(false, PortalBlock.Type.BOUNDARY_1);
            if (mat == null) {
                return new ItemStack(Material.BARRIER);
            }
            return new ItemStack(mat);
        };
        return new MenuItem(31, this.item_select_defined.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ArrayList<Style> all_styles = new ArrayList<Style>(((Portals)this.get_module()).styles.values());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(s, str) -> s.key().toString().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_style_title.str(new Object[0]), (String)this.lang_filter_styles_title.str(new Object[0]), all_styles, (Function1 & Serializable)s -> this.item_select_style.alternative((ItemStack)item_for.apply(s), new Object[]{s.key().getKey()}), (Filter)filter, (Function3 & Serializable)(player2, m, t) -> {
                m.close(player2);
                style_container.defined_style = t.key();
                style_container.style = t.copy(null);
                menu.open(player2);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new PortalMenuTag(portal.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_cancel(Menu previous) {
        return new MenuItem(35, this.item_cancel.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            previous.open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }

    private static class StyleContainer {
        public NamespacedKey defined_style = null;
        public Style style = null;

        private StyleContainer() {
        }
    }
}

