/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.portal;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;
import org.oddlama.vane.portals.portal.Plane;

public enum Orientation {
    POSITIVE_X(Plane.YZ, new Vector(1, 0, 0)),
    NEGATIVE_X(Plane.YZ, new Vector(-1, 0, 0)),
    POSITIVE_Y(Plane.XZ, new Vector(0, 1, 0)),
    NEGATIVE_Y(Plane.XZ, new Vector(0, -1, 0)),
    POSITIVE_Z(Plane.XY, new Vector(0, 0, 1)),
    NEGATIVE_Z(Plane.XY, new Vector(0, 0, -1));

    private Plane plane;
    private Vector vector;

    private Orientation(Plane plane, Vector vector) {
        this.plane = plane;
        this.vector = vector;
    }

    public Plane plane() {
        return this.plane;
    }

    public Vector vector() {
        return this.vector.clone();
    }

    public Vector component_mask() {
        return this.vector().multiply(this.vector);
    }

    public Orientation flip() {
        switch (this.ordinal()) {
            case 1: {
                return POSITIVE_X;
            }
            case 0: {
                return NEGATIVE_X;
            }
            case 5: {
                return POSITIVE_Z;
            }
            case 4: {
                return NEGATIVE_Z;
            }
            case 3: {
                return POSITIVE_Y;
            }
            case 2: {
                return NEGATIVE_Y;
            }
        }
        throw new RuntimeException("Invalid control flow. This is a bug.");
    }

    public Location apply(Orientation reference, Location location, boolean flip_source_if_not_opposing) {
        Location l = location.clone();
        l.setDirection(this.apply(reference, location.getDirection(), flip_source_if_not_opposing));
        return l;
    }

    public Vector apply(Orientation reference, Vector vector, boolean flip_source_if_not_opposing) {
        boolean opposing;
        double x = vector.getX();
        double y = vector.getY();
        double z = vector.getZ();
        Orientation effective_source = this;
        Vector cmask = this.component_mask();
        boolean bl = opposing = this.vector.dot(cmask) < 0.0 != vector.dot(cmask) < 0.0;
        if (flip_source_if_not_opposing && opposing) {
            effective_source = effective_source.flip();
        }
        switch (effective_source.ordinal()) {
            case 1: {
                switch (reference.ordinal()) {
                    case 1: {
                        return new Vector(-x, y, -z);
                    }
                    case 0: {
                        return new Vector(x, y, z);
                    }
                    case 5: {
                        return new Vector(z, y, -x);
                    }
                    case 4: {
                        return new Vector(-z, y, x);
                    }
                    case 3: {
                        return new Vector(y, -x, z);
                    }
                    case 2: {
                        return new Vector(-y, x, z);
                    }
                }
                break;
            }
            case 0: {
                switch (reference.ordinal()) {
                    case 1: {
                        return new Vector(x, y, z);
                    }
                    case 0: {
                        return new Vector(-x, y, -z);
                    }
                    case 5: {
                        return new Vector(-z, y, x);
                    }
                    case 4: {
                        return new Vector(z, y, -x);
                    }
                    case 3: {
                        return new Vector(-y, x, z);
                    }
                    case 2: {
                        return new Vector(y, -x, z);
                    }
                }
                break;
            }
            case 5: {
                switch (reference.ordinal()) {
                    case 1: {
                        return new Vector(-z, y, x);
                    }
                    case 0: {
                        return new Vector(z, y, -x);
                    }
                    case 5: {
                        return new Vector(-x, y, -z);
                    }
                    case 4: {
                        return new Vector(x, y, z);
                    }
                    case 3: {
                        return new Vector(x, -z, y);
                    }
                    case 2: {
                        return new Vector(-x, z, y);
                    }
                }
                break;
            }
            case 4: {
                switch (reference.ordinal()) {
                    case 1: {
                        return new Vector(z, y, -x);
                    }
                    case 0: {
                        return new Vector(-z, y, x);
                    }
                    case 5: {
                        return new Vector(x, y, z);
                    }
                    case 4: {
                        return new Vector(-x, y, -z);
                    }
                    case 3: {
                        return new Vector(-x, z, y);
                    }
                    case 2: {
                        return new Vector(x, -z, y);
                    }
                }
                break;
            }
            case 3: {
                switch (reference.ordinal()) {
                    case 1: {
                        return new Vector(-y, 0.0, 0.0);
                    }
                    case 0: {
                        return new Vector(y, 0.0, 0.0);
                    }
                    case 5: {
                        return new Vector(0.0, 0.0, -y);
                    }
                    case 4: {
                        return new Vector(0.0, 0.0, y);
                    }
                    case 3: {
                        return new Vector(x, -y, z);
                    }
                    case 2: {
                        return new Vector(x, y, z);
                    }
                }
                break;
            }
            case 2: {
                switch (reference.ordinal()) {
                    case 1: {
                        return new Vector(y, 0.0, 0.0);
                    }
                    case 0: {
                        return new Vector(-y, 0.0, 0.0);
                    }
                    case 5: {
                        return new Vector(0.0, 0.0, y);
                    }
                    case 4: {
                        return new Vector(0.0, 0.0, -y);
                    }
                    case 3: {
                        return new Vector(x, y, z);
                    }
                    case 2: {
                        return new Vector(-x, -y, -z);
                    }
                }
            }
        }
        throw new RuntimeException("Invalid control flow. This is a bug.");
    }

    public static Orientation from(Plane plane, Block origin, Block console, Location entity_location) {
        switch (plane) {
            case XY: {
                double origin_z = (double)origin.getZ() + 0.5;
                double console_z = (double)console.getZ() + 0.5;
                if (console_z > origin_z) {
                    return NEGATIVE_Z;
                }
                if (console_z < origin_z) {
                    return POSITIVE_Z;
                }
                if (entity_location.getZ() > origin_z) {
                    return NEGATIVE_Z;
                }
                return POSITIVE_Z;
            }
            case YZ: {
                double origin_x = (double)origin.getX() + 0.5;
                double console_x = (double)console.getX() + 0.5;
                if (console_x > origin_x) {
                    return NEGATIVE_X;
                }
                if (console_x < origin_x) {
                    return POSITIVE_X;
                }
                if (entity_location.getX() > origin_x) {
                    return NEGATIVE_X;
                }
                return POSITIVE_X;
            }
            case XZ: {
                double origin_y = (double)origin.getY() + 0.5;
                double console_y = (double)console.getY() + 0.5;
                if (console_y >= origin_y) {
                    return NEGATIVE_Y;
                }
                return POSITIVE_Y;
            }
        }
        throw new RuntimeException("Invalid control flow. This is a bug.");
    }
}

