/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.portal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.event.PortalActivateEvent;
import org.oddlama.vane.portals.event.PortalDeactivateEvent;
import org.oddlama.vane.portals.event.PortalOpenConsoleEvent;
import org.oddlama.vane.portals.portal.Orientation;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.portals.portal.Style;
import org.oddlama.vane.util.BlockUtil;
import org.oddlama.vane.util.LazyLocation;

public class Portal {
    private UUID id;
    private UUID owner;
    private Orientation orientation;
    private LazyLocation spawn;
    private List<PortalBlock> blocks = new ArrayList<PortalBlock>();
    private String name = "Portal";
    private NamespacedKey style = Style.default_style_key();
    private Style style_override = null;
    private ItemStack icon = null;
    private Visibility visibility = Visibility.PRIVATE;
    private boolean exit_orientation_locked = false;
    private UUID target_id = null;
    private boolean target_locked = false;
    public boolean invalidated = true;

    public static Object serialize(@NotNull Object o) throws IOException {
        Portal portal = (Portal)o;
        JSONObject json = new JSONObject();
        json.put("id", PersistentSerializer.to_json(UUID.class, (Object)portal.id));
        json.put("owner", PersistentSerializer.to_json(UUID.class, (Object)portal.owner));
        json.put("orientation", PersistentSerializer.to_json(Orientation.class, (Object)((Object)portal.orientation)));
        json.put("spawn", PersistentSerializer.to_json(LazyLocation.class, (Object)portal.spawn));
        try {
            json.put("blocks", PersistentSerializer.to_json((Field)Portal.class.getDeclaredField("blocks"), portal.blocks));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        json.put("name", PersistentSerializer.to_json(String.class, (Object)portal.name));
        json.put("style", PersistentSerializer.to_json(NamespacedKey.class, (Object)portal.style));
        json.put("style_override", PersistentSerializer.to_json(Style.class, (Object)portal.style_override));
        json.put("icon", PersistentSerializer.to_json(ItemStack.class, (Object)portal.icon));
        json.put("visibility", PersistentSerializer.to_json(Visibility.class, (Object)((Object)portal.visibility)));
        json.put("exit_orientation_locked", PersistentSerializer.to_json(Boolean.TYPE, (Object)portal.exit_orientation_locked));
        json.put("target_id", PersistentSerializer.to_json(UUID.class, (Object)portal.target_id));
        json.put("target_locked", PersistentSerializer.to_json(Boolean.TYPE, (Object)portal.target_locked));
        return json;
    }

    public static Portal deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        Portal portal = new Portal();
        portal.id = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("id"));
        portal.owner = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("owner"));
        portal.orientation = (Orientation)((Object)PersistentSerializer.from_json(Orientation.class, (Object)json.get("orientation")));
        portal.spawn = (LazyLocation)PersistentSerializer.from_json(LazyLocation.class, (Object)json.get("spawn"));
        try {
            portal.blocks = (List)PersistentSerializer.from_json((Field)Portal.class.getDeclaredField("blocks"), (Object)json.get("blocks"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        portal.name = (String)PersistentSerializer.from_json(String.class, (Object)json.get("name"));
        portal.style = (NamespacedKey)PersistentSerializer.from_json(NamespacedKey.class, (Object)json.get("style"));
        portal.style_override = (Style)PersistentSerializer.from_json(Style.class, (Object)json.get("style_override"));
        if (portal.style_override != null) {
            try {
                portal.style_override.check_valid();
            }
            catch (RuntimeException e) {
                portal.style_override = null;
            }
        }
        portal.icon = (ItemStack)PersistentSerializer.from_json(ItemStack.class, (Object)json.get("icon"));
        portal.visibility = (Visibility)((Object)PersistentSerializer.from_json(Visibility.class, (Object)json.get("visibility")));
        portal.exit_orientation_locked = (Boolean)PersistentSerializer.from_json(Boolean.TYPE, (Object)json.optString("exit_orientation_locked", "false"));
        portal.target_id = (UUID)PersistentSerializer.from_json(UUID.class, (Object)json.get("target_id"));
        portal.target_locked = (Boolean)PersistentSerializer.from_json(Boolean.TYPE, (Object)json.get("target_locked"));
        return portal;
    }

    private Portal() {
    }

    public Portal(UUID owner, Orientation orientation, Location spawn) {
        this.id = UUID.randomUUID();
        this.owner = owner;
        this.orientation = orientation;
        this.spawn = new LazyLocation(spawn.clone());
    }

    public UUID id() {
        return this.id;
    }

    public UUID owner() {
        return this.owner;
    }

    public Orientation orientation() {
        return this.orientation;
    }

    public UUID spawn_world() {
        return this.spawn.world_id();
    }

    public Location spawn() {
        return this.spawn.location().clone();
    }

    public List<PortalBlock> blocks() {
        return this.blocks;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.invalidated = true;
    }

    public NamespacedKey style() {
        return this.style_override == null ? this.style : null;
    }

    public void style(Style style) {
        if (style.key() == null) {
            this.style_override = style;
        } else {
            this.style = style.key();
        }
        this.invalidated = true;
    }

    public ItemStack icon() {
        return this.icon == null ? null : this.icon.clone();
    }

    public void icon(ItemStack icon) {
        this.icon = icon;
        this.invalidated = true;
    }

    public Visibility visibility() {
        return this.visibility;
    }

    public void visibility(Visibility visibility) {
        this.visibility = visibility;
        this.invalidated = true;
    }

    public boolean exit_orientation_locked() {
        return this.exit_orientation_locked;
    }

    public void exit_orientation_locked(boolean exit_orientation_locked) {
        this.exit_orientation_locked = exit_orientation_locked;
        this.invalidated = true;
    }

    public UUID target_id() {
        return this.target_id;
    }

    public void target_id(UUID target_id) {
        this.target_id = target_id;
        this.invalidated = true;
    }

    public boolean target_locked() {
        return this.target_locked;
    }

    public void target_locked(boolean target_locked) {
        this.target_locked = target_locked;
        this.invalidated = true;
    }

    public PortalBlock portal_block_for(Block block) {
        for (PortalBlock pb : this.blocks()) {
            if (!pb.block().equals((Object)block)) continue;
            return pb;
        }
        return null;
    }

    @Nullable
    public Portal target(Portals portals) {
        return portals.portal_for(this.target_id());
    }

    private Set<Block> controlling_blocks() {
        HashSet<Block> controlling_blocks = new HashSet<Block>();
        block4: for (PortalBlock pb : this.blocks()) {
            switch (pb.type()) {
                default: {
                    continue block4;
                }
                case ORIGIN: 
                case BOUNDARY_1: 
                case BOUNDARY_2: 
                case BOUNDARY_3: 
                case BOUNDARY_4: 
                case BOUNDARY_5: {
                    controlling_blocks.add(pb.block());
                    continue block4;
                }
                case CONSOLE: 
            }
            controlling_blocks.add(pb.block());
            controlling_blocks.addAll(Arrays.asList(BlockUtil.adjacent_blocks_3d((Block)pb.block())));
        }
        return controlling_blocks;
    }

    private void set_controlling_levers(boolean activated) {
        Set<Block> controlling_blocks = this.controlling_blocks();
        HashSet<Block> levers = new HashSet<Block>();
        for (Block b : this.controlling_blocks()) {
            for (BlockFace f : BlockUtil.BLOCK_FACES) {
                Block l = b.getRelative(f);
                if (l.getType() != Material.LEVER) continue;
                Switch lever = (Switch)l.getBlockData();
                if (!controlling_blocks.contains(l.getRelative(switch (lever.getAttachedFace()) {
                    default -> lever.getFacing().getOppositeFace();
                    case FaceAttachable.AttachedFace.CEILING -> BlockFace.UP;
                    case FaceAttachable.AttachedFace.FLOOR -> BlockFace.DOWN;
                }))) continue;
                levers.add(l);
            }
        }
        for (Block l : levers) {
            Switch lever = (Switch)l.getBlockData();
            lever.setPowered(activated);
            l.setBlockData((BlockData)lever);
            BlockUtil.update_lever((Block)l, (BlockFace)lever.getFacing());
        }
    }

    public boolean activate(Portals portals, @Nullable Player player) {
        if (portals.is_activated(this)) {
            return false;
        }
        Portal target = this.target(portals);
        if (target == null) {
            return false;
        }
        PortalActivateEvent event = new PortalActivateEvent(player, this, target);
        portals.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        portals.connect_portals(this, target);
        return true;
    }

    public boolean deactivate(Portals portals, @Nullable Player player) {
        if (!portals.is_activated(this)) {
            return false;
        }
        PortalDeactivateEvent event = new PortalDeactivateEvent(player, this);
        portals.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        portals.disconnect_portals(this);
        return true;
    }

    public void on_connect(Portals portals, Portal target) {
        this.update_blocks(portals);
        this.set_controlling_levers(true);
        float sound_volume = (float)portals.config_volume_activation;
        if (sound_volume > 0.0f) {
            this.spawn().getWorld().playSound(this.spawn(), Sound.BLOCK_END_PORTAL_SPAWN, SoundCategory.BLOCKS, sound_volume, 0.8f);
        }
    }

    public void on_disconnect(Portals portals, Portal target) {
        this.update_blocks(portals);
        this.set_controlling_levers(false);
        float sound_volume = (float)portals.config_volume_deactivation;
        if (sound_volume > 0.0f) {
            this.spawn().getWorld().playSound(this.spawn(), Sound.BLOCK_END_PORTAL_FRAME_FILL, SoundCategory.BLOCKS, sound_volume, 0.5f);
        }
    }

    public void update_blocks(Portals portals) {
        Style cur_style = this.style_override == null ? portals.style(this.style) : this.style_override;
        boolean active = portals.is_activated(this);
        for (PortalBlock portal_block : this.blocks) {
            Material type = cur_style.material(active, portal_block.type());
            portal_block.block().setType(type);
            if (type == Material.END_GATEWAY) {
                EndGateway end_gateway = (EndGateway)portal_block.block().getState(false);
                end_gateway.setAge(200L);
                end_gateway.update(true, false);
                if (this.spawn.location().getWorld().getEnvironment() == World.Environment.THE_END) {
                    end_gateway.setExitLocation(this.spawn.location());
                    end_gateway.setExactTeleport(true);
                }
            }
            if (portal_block.type() != PortalBlock.Type.CONSOLE) continue;
            portals.update_console_item(this, portal_block.block());
        }
    }

    public boolean open_console(Portals portals, Player player, Block console) {
        PortalOpenConsoleEvent event = new PortalOpenConsoleEvent(player, console, this);
        portals.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && !player.hasPermission(portals.admin_permission)) {
            return false;
        }
        portals.menus.console_menu.create(this, player, console).open(player);
        return true;
    }

    public Style copy_style(Portals portals, NamespacedKey new_key) {
        if (this.style_override == null) {
            return portals.style(this.style).copy(new_key);
        }
        return this.style_override.copy(new_key);
    }

    public String toString() {
        return "Portal{id = " + String.valueOf(this.id) + ", name = " + this.name + "}";
    }

    public static enum Visibility {
        PUBLIC,
        GROUP,
        GROUP_INTERNAL,
        PRIVATE;


        public Visibility prev() {
            int prev = this.ordinal() == 0 ? Visibility.values().length - 1 : this.ordinal() - 1;
            return Visibility.values()[prev];
        }

        public Visibility next() {
            int next = (this.ordinal() + 1) % Visibility.values().length;
            return Visibility.values()[next];
        }

        public boolean is_transient_target() {
            return this == GROUP || this == PRIVATE;
        }

        public boolean requires_regions() {
            return this == GROUP || this == GROUP_INTERNAL;
        }
    }

    public static class TargetSelectionComparator
    implements Comparator<Portal> {
        private World world;
        private Vector from;

        public TargetSelectionComparator(Player player) {
            this.world = player.getLocation().getWorld();
            this.from = player.getLocation().toVector().setY(0.0);
        }

        @Override
        public int compare(Portal a, Portal b) {
            boolean a_same_world = this.world.equals((Object)a.spawn().getWorld());
            boolean b_same_world = this.world.equals((Object)b.spawn().getWorld());
            if (a_same_world) {
                if (b_same_world) {
                    double a_dist = this.from.distanceSquared(a.spawn().toVector().setY(0.0));
                    double b_dist = this.from.distanceSquared(b.spawn().toVector().setY(0.0));
                    return Double.compare(a_dist, b_dist);
                }
                return -1;
            }
            if (b_same_world) {
                return 1;
            }
            return a.name().compareToIgnoreCase(b.name());
        }
    }
}

