/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.portal;

import java.io.IOException;
import java.util.UUID;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.portals.portal.PortalBlockLookup;
import org.oddlama.vane.util.LazyBlock;

public class PortalBlock {
    private LazyBlock block;
    private Type type;

    public static Object serialize(@NotNull Object o) throws IOException {
        PortalBlock portal_block = (PortalBlock)o;
        JSONObject json = new JSONObject();
        json.put("block", PersistentSerializer.to_json(LazyBlock.class, (Object)portal_block.block));
        json.put("type", PersistentSerializer.to_json(Type.class, (Object)((Object)portal_block.type)));
        return json;
    }

    public static PortalBlock deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        LazyBlock block = (LazyBlock)PersistentSerializer.from_json(LazyBlock.class, (Object)json.get("block"));
        Type type = (Type)((Object)PersistentSerializer.from_json(Type.class, (Object)json.get("type")));
        return new PortalBlock(block, type);
    }

    public PortalBlock(LazyBlock block, Type type) {
        this.block = block;
        this.type = type;
    }

    public PortalBlock(Block block, Type type) {
        this(new LazyBlock(block), type);
    }

    public Block block() {
        return this.block.block();
    }

    public Type type() {
        return this.type;
    }

    public PortalBlockLookup lookup(UUID portal_id) {
        return new PortalBlockLookup(portal_id, this.type);
    }

    public int hashCode() {
        return this.block().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PortalBlock)) {
            return false;
        }
        PortalBlock po = (PortalBlock)other;
        return this.block().equals((Object)po.block());
    }

    public static enum Type {
        ORIGIN,
        CONSOLE,
        BOUNDARY_1,
        BOUNDARY_2,
        BOUNDARY_3,
        BOUNDARY_4,
        BOUNDARY_5,
        PORTAL;

    }
}

