/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.portal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;
import org.oddlama.vane.portals.PortalConstructor;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.portals.portal.Plane;

public class PortalBoundary {
    private Set<Block> boundary_blocks = null;
    private Set<Block> portal_area_blocks = null;
    private Block origin_block = null;
    private final Plane plane;
    private Location spawn = null;
    private ErrorState error_state = ErrorState.NONE;
    private int dim_x;
    private int dim_y;
    private int dim_z;

    private PortalBoundary(Plane plane) {
        this.plane = plane;
    }

    public Set<Block> boundary_blocks() {
        return this.boundary_blocks;
    }

    public Set<Block> portal_area_blocks() {
        return this.portal_area_blocks;
    }

    public Block origin_block() {
        return this.origin_block;
    }

    public Plane plane() {
        return this.plane;
    }

    public Location spawn() {
        return this.spawn;
    }

    public ErrorState error_state() {
        return this.error_state;
    }

    public int dim_x() {
        return this.dim_x;
    }

    public int dim_y() {
        return this.dim_y;
    }

    public int dim_z() {
        return this.dim_z;
    }

    public List<Block> all_blocks() {
        ArrayList<Block> all_blocks = new ArrayList<Block>();
        all_blocks.addAll(this.boundary_blocks);
        all_blocks.addAll(this.portal_area_blocks);
        all_blocks.add(this.origin_block);
        return all_blocks;
    }

    public boolean intersects_existing_portal(PortalConstructor portal_constructor) {
        for (Block b : this.all_blocks()) {
            if (!((Portals)portal_constructor.get_module()).is_portal_block(b)) continue;
            return true;
        }
        return false;
    }

    private static void push_block_if_not_contained(Block block, Stack<Block> stack, Set<Block> out_boundary, Set<Block> out_portal_area) {
        if (out_boundary.contains(block) || out_portal_area.contains(block)) {
            return;
        }
        stack.push(block);
    }

    private static void push_adjacent_blocks_to_stack(Block block, Stack<Block> stack, Set<Block> out_boundary, Set<Block> out_portal_area, Plane plane) {
        switch (plane) {
            case XY: {
                PortalBoundary.push_block_if_not_contained(block.getRelative(1, 0, 0), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(-1, 0, 0), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, 1, 0), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, -1, 0), stack, out_boundary, out_portal_area);
                break;
            }
            case YZ: {
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, 0, 1), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, 0, -1), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, 1, 0), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, -1, 0), stack, out_boundary, out_portal_area);
                break;
            }
            case XZ: {
                PortalBoundary.push_block_if_not_contained(block.getRelative(1, 0, 0), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(-1, 0, 0), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, 0, 1), stack, out_boundary, out_portal_area);
                PortalBoundary.push_block_if_not_contained(block.getRelative(0, 0, -1), stack, out_boundary, out_portal_area);
            }
        }
    }

    private static void do_flood_fill4_step(PortalConstructor portal_constructor, Stack<Block> stack, Set<Block> out_boundary, Set<Block> out_portal_area, Plane plane) {
        Block block = stack.pop();
        if (portal_constructor.is_type_part_of_boundary_or_origin(block.getType())) {
            out_boundary.add(block);
        } else {
            out_portal_area.add(block);
            PortalBoundary.push_adjacent_blocks_to_stack(block, stack, out_boundary, out_portal_area, plane);
        }
    }

    private static Pair<Set<Block>, Set<Block>> simultaneous_flood_fill4(PortalConstructor portal_constructor, Block[] areas, Plane plane) {
        HashSet<Block> boundary0 = new HashSet<Block>();
        HashSet<Block> boundary1 = new HashSet<Block>();
        HashSet<Block> portal_area0 = new HashSet<Block>();
        HashSet<Block> portal_area1 = new HashSet<Block>();
        Stack<Block> flood_fill_stack0 = new Stack<Block>();
        Stack<Block> flood_fill_stack1 = new Stack<Block>();
        if (areas[0] != null) {
            flood_fill_stack0.push(areas[0]);
        }
        if (areas[1] != null) {
            flood_fill_stack1.push(areas[1]);
        }
        int depth = 0;
        while (!(areas[0] != null && flood_fill_stack0.isEmpty() || areas[1] != null && flood_fill_stack1.isEmpty())) {
            if (++depth > portal_constructor.config_area_floodfill_max_steps) {
                return null;
            }
            if (areas[0] != null) {
                PortalBoundary.do_flood_fill4_step(portal_constructor, flood_fill_stack0, boundary0, portal_area0, plane);
            }
            if (areas[1] == null) continue;
            PortalBoundary.do_flood_fill4_step(portal_constructor, flood_fill_stack1, boundary1, portal_area1, plane);
        }
        if (areas[0] != null && flood_fill_stack0.isEmpty()) {
            return Pair.of(boundary0, portal_area0);
        }
        if (areas[1] != null && flood_fill_stack1.isEmpty()) {
            return Pair.of(boundary1, portal_area1);
        }
        return null;
    }

    private static List<Block> get_surrounding_blocks_ccw(Block block, Plane plane) {
        ArrayList<Block> surrounding_blocks = new ArrayList<Block>();
        switch (plane) {
            case XY: {
                surrounding_blocks.add(block.getRelative(1, -1, 0));
                surrounding_blocks.add(block.getRelative(1, 0, 0));
                surrounding_blocks.add(block.getRelative(1, 1, 0));
                surrounding_blocks.add(block.getRelative(0, 1, 0));
                surrounding_blocks.add(block.getRelative(-1, 1, 0));
                surrounding_blocks.add(block.getRelative(-1, 0, 0));
                surrounding_blocks.add(block.getRelative(-1, -1, 0));
                surrounding_blocks.add(block.getRelative(0, -1, 0));
                break;
            }
            case YZ: {
                surrounding_blocks.add(block.getRelative(0, 1, -1));
                surrounding_blocks.add(block.getRelative(0, 1, 0));
                surrounding_blocks.add(block.getRelative(0, 1, 1));
                surrounding_blocks.add(block.getRelative(0, 0, 1));
                surrounding_blocks.add(block.getRelative(0, -1, 1));
                surrounding_blocks.add(block.getRelative(0, -1, 0));
                surrounding_blocks.add(block.getRelative(0, -1, -1));
                surrounding_blocks.add(block.getRelative(0, 0, -1));
                break;
            }
            case XZ: {
                surrounding_blocks.add(block.getRelative(1, 0, -1));
                surrounding_blocks.add(block.getRelative(1, 0, 0));
                surrounding_blocks.add(block.getRelative(1, 0, 1));
                surrounding_blocks.add(block.getRelative(0, 0, 1));
                surrounding_blocks.add(block.getRelative(-1, 0, 1));
                surrounding_blocks.add(block.getRelative(-1, 0, 0));
                surrounding_blocks.add(block.getRelative(-1, 0, -1));
                surrounding_blocks.add(block.getRelative(0, 0, -1));
            }
        }
        return surrounding_blocks;
    }

    private static Block[] get_potential_area_blocks(PortalConstructor portal_constructor, Block block, Plane plane) {
        List<Block> surrounding_blocks = PortalBoundary.get_surrounding_blocks_ccw(block, plane);
        int boundary_blocks = 0;
        for (Block surrounding_block : surrounding_blocks) {
            if (!portal_constructor.is_type_part_of_boundary_or_origin(surrounding_block.getType())) continue;
            ++boundary_blocks;
        }
        if (boundary_blocks < 2) {
            return null;
        }
        Block[] areas = new Block[2];
        int area_index = 0;
        boolean had_boundary_block_before = false;
        for (Block surrounding_block : surrounding_blocks) {
            if (portal_constructor.is_type_part_of_boundary_or_origin(surrounding_block.getType())) {
                if (!had_boundary_block_before) {
                    area_index = (area_index + 1) % 2;
                }
                had_boundary_block_before = true;
                continue;
            }
            areas[area_index] = surrounding_block;
            if (areas[(area_index + 1) % 2] != null) {
                return areas;
            }
            had_boundary_block_before = false;
        }
        return areas;
    }

    private static void add3_air_stacks(PortalConstructor portal_constructor, Block start_air, List<Block> lowest_air_blocks, boolean insert_front, int mod_x, int mod_z) {
        Block above2;
        Block above1;
        Block boundary;
        Block air = start_air;
        while ((air = air.getRelative(-mod_x, 0, -mod_z)).getType() == portal_constructor.config_material_portal_area && !portal_constructor.is_type_part_of_boundary((boundary = air.getRelative(0, -1, 0)).getType()) && (above1 = air.getRelative(0, 1, 0)).getType() == portal_constructor.config_material_portal_area && (above2 = air.getRelative(0, 2, 0)).getType() == portal_constructor.config_material_portal_area) {
            if (insert_front) {
                lowest_air_blocks.add(0, air);
                continue;
            }
            lowest_air_blocks.add(air);
        }
    }

    private static PortalBoundary search_at(PortalConstructor portal_constructor, Block search_block, Plane plane) {
        Block[] potential_area_blocks = PortalBoundary.get_potential_area_blocks(portal_constructor, search_block, plane);
        if (potential_area_blocks == null || potential_area_blocks[0] == null && potential_area_blocks[1] == null) {
            return null;
        }
        Pair<Set<Block>, Set<Block>> result = PortalBoundary.simultaneous_flood_fill4(portal_constructor, potential_area_blocks, plane);
        if (result == null) {
            return null;
        }
        PortalBoundary boundary = new PortalBoundary(plane);
        boundary.boundary_blocks = (Set)result.getLeft();
        boundary.portal_area_blocks = (Set)result.getRight();
        Iterator<Block> iterator = boundary.boundary_blocks.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (block.getType() != portal_constructor.config_material_origin) continue;
            if (boundary.origin_block != null) {
                boundary.error_state = ErrorState.MULTIPLE_ORIGINS;
                return boundary;
            }
            iterator.remove();
            boundary.origin_block = block;
        }
        if (boundary.origin_block == null) {
            boundary.error_state = ErrorState.NO_ORIGIN;
            return boundary;
        }
        if (boundary.portal_area_blocks.size() > portal_constructor.config_area_max_blocks) {
            boundary.error_state = ErrorState.TOO_MANY_PORTAL_AREA_BLOCKS;
            return boundary;
        }
        int min_x = Integer.MAX_VALUE;
        int min_y = Integer.MAX_VALUE;
        int min_z = Integer.MAX_VALUE;
        int max_x = Integer.MIN_VALUE;
        int max_y = Integer.MIN_VALUE;
        int max_z = Integer.MIN_VALUE;
        for (Block block : boundary.portal_area_blocks) {
            min_x = Math.min(min_x, block.getX());
            min_y = Math.min(min_y, block.getY());
            min_z = Math.min(min_z, block.getZ());
            max_x = Math.max(max_x, block.getX());
            max_y = Math.max(max_y, block.getY());
            max_z = Math.max(max_z, block.getZ());
        }
        boundary.dim_x = 1 + max_x - min_x;
        boundary.dim_y = 1 + max_y - min_y;
        boundary.dim_z = 1 + max_z - min_z;
        if (boundary.dim_x > portal_constructor.max_dim_x(plane)) {
            boundary.error_state = ErrorState.TOO_LARGE_X;
            return boundary;
        }
        if (boundary.dim_y > portal_constructor.max_dim_y(plane)) {
            boundary.error_state = ErrorState.TOO_LARGE_Y;
            return boundary;
        }
        if (boundary.dim_z > portal_constructor.max_dim_z(plane)) {
            boundary.error_state = ErrorState.TOO_LARGE_Z;
            return boundary;
        }
        Set<Material> air_overrides = Set.of(Material.CAVE_AIR, Material.AIR, Material.VOID_AIR);
        for (Block block : boundary.portal_area_blocks) {
            if (block.getType() == portal_constructor.config_material_portal_area || portal_constructor.config_material_portal_area == Material.AIR && air_overrides.contains(block.getType())) continue;
            boundary.error_state = ErrorState.PORTAL_AREA_OBSTRUCTED;
            return boundary;
        }
        if (boundary.plane == Plane.XZ) {
            double spawn_z;
            double spawn_x;
            double spawn_offset_along_side_axis;
            double spawn_offset_along_origin_axis;
            boolean even_along_side_axis;
            int m_z;
            int m_x;
            Block last_inside;
            Block back_last_inside;
            int mod_z;
            int abs_mod_z;
            int abs_mod_x;
            int mod_x;
            Block block = boundary.origin_block().getWorld().getBlockAt((int)Math.floor((double)min_x / 2.0 + (double)max_x / 2.0), boundary.origin_block().getY(), (int)Math.floor((double)min_z / 2.0 + (double)max_z / 2.0));
            int diff_x = block.getX() - boundary.origin_block().getX();
            int diff_z = block.getZ() - boundary.origin_block().getZ();
            if (Math.abs(diff_x) > Math.abs(diff_z)) {
                mod_x = diff_x > 0 ? -1 : 1;
                abs_mod_x = 1;
                abs_mod_z = 0;
                mod_z = 0;
            } else {
                abs_mod_x = 0;
                mod_x = 0;
                abs_mod_z = 1;
                mod_z = diff_z > 0 ? -1 : 1;
            }
            Block first_inside = block;
            while (!boundary.portal_area_blocks.contains(first_inside)) {
                if (mod_x != 0 && (first_inside.getX() <= min_x || first_inside.getX() >= max_x)) {
                    boundary.error_state = ErrorState.TOO_SMALL_SPAWN_X;
                    return boundary;
                }
                if (mod_z != 0 && (first_inside.getZ() <= min_z || first_inside.getZ() >= max_z)) {
                    boundary.error_state = ErrorState.TOO_SMALL_SPAWN_Z;
                    return boundary;
                }
                first_inside = first_inside.getRelative(mod_x, 0, mod_z);
            }
            Block next = first_inside;
            int total_blocks_inside = -1;
            do {
                back_last_inside = next;
                next = back_last_inside.getRelative(-mod_x, 0, -mod_z);
                ++total_blocks_inside;
            } while (boundary.portal_area_blocks().contains(next));
            next = first_inside;
            do {
                last_inside = next;
                next = last_inside.getRelative(mod_x, 0, mod_z);
                ++total_blocks_inside;
            } while (boundary.portal_area_blocks().contains(next));
            if (total_blocks_inside < 2) {
                boundary.error_state = mod_z == 0 ? ErrorState.TOO_SMALL_SPAWN_X : ErrorState.TOO_SMALL_SPAWN_Z;
                return boundary;
            }
            if (mod_x == 0) {
                m_x = (int)Math.floor((double)min_x / 2.0 + (double)max_x / 2.0);
                m_z = (int)Math.floor((double)last_inside.getZ() / 2.0 + (double)back_last_inside.getZ() / 2.0);
            } else {
                m_x = (int)Math.floor((double)last_inside.getX() / 2.0 + (double)back_last_inside.getX() / 2.0);
                m_z = (int)Math.floor((double)min_z / 2.0 + (double)max_z / 2.0);
            }
            Block middle_inside = last_inside.getWorld().getBlockAt(m_x, last_inside.getY(), m_z);
            boolean even_along_origin_axis = total_blocks_inside % 2 == 0;
            boolean bl = even_along_side_axis = (mod_x == 0 ? boundary.dim_z : boundary.dim_x) % 2 == 0;
            if (even_along_origin_axis) {
                if (!boundary.portal_area_blocks().contains(middle_inside.getRelative(abs_mod_x, 0, abs_mod_z))) {
                    boundary.error_state = mod_x == 0 ? ErrorState.TOO_SMALL_SPAWN_Z : ErrorState.TOO_SMALL_SPAWN_X;
                    return boundary;
                }
                spawn_offset_along_origin_axis = 1.0;
            } else {
                if (!boundary.portal_area_blocks().contains(middle_inside.getRelative(abs_mod_x, 0, abs_mod_z))) {
                    boundary.error_state = mod_x == 0 ? ErrorState.TOO_SMALL_SPAWN_Z : ErrorState.TOO_SMALL_SPAWN_X;
                    return boundary;
                }
                if (!boundary.portal_area_blocks().contains(middle_inside.getRelative(-abs_mod_x, 0, -abs_mod_z))) {
                    boundary.error_state = mod_x == 0 ? ErrorState.TOO_SMALL_SPAWN_Z : ErrorState.TOO_SMALL_SPAWN_X;
                    return boundary;
                }
                spawn_offset_along_origin_axis = 0.5;
            }
            if (even_along_side_axis) {
                if (!boundary.portal_area_blocks().contains(middle_inside.getRelative(abs_mod_z, 0, abs_mod_x))) {
                    boundary.error_state = mod_x == 0 ? ErrorState.TOO_SMALL_SPAWN_X : ErrorState.TOO_SMALL_SPAWN_Z;
                    return boundary;
                }
                spawn_offset_along_side_axis = 1.0;
            } else {
                if (!boundary.portal_area_blocks().contains(middle_inside.getRelative(abs_mod_z, 0, abs_mod_x))) {
                    boundary.error_state = mod_x == 0 ? ErrorState.TOO_SMALL_SPAWN_X : ErrorState.TOO_SMALL_SPAWN_Z;
                    return boundary;
                }
                if (!boundary.portal_area_blocks().contains(middle_inside.getRelative(-abs_mod_z, 0, -abs_mod_x))) {
                    boundary.error_state = mod_x == 0 ? ErrorState.TOO_SMALL_SPAWN_X : ErrorState.TOO_SMALL_SPAWN_Z;
                    return boundary;
                }
                spawn_offset_along_side_axis = 0.5;
            }
            if (mod_x == 0) {
                spawn_x = (double)m_x + spawn_offset_along_side_axis;
                spawn_z = (double)m_z + spawn_offset_along_origin_axis;
            } else {
                spawn_x = (double)m_x + spawn_offset_along_origin_axis;
                spawn_z = (double)m_z + spawn_offset_along_side_axis;
            }
            boundary.spawn = new Location(middle_inside.getWorld(), spawn_x, (double)middle_inside.getY() + 0.5, spawn_z);
        } else {
            Block block = boundary.origin_block().getRelative(0, 1, 0);
            if (!boundary.portal_area_blocks().contains(block)) {
                boundary.error_state = ErrorState.NO_PORTAL_BLOCK_ABOVE_ORIGIN;
                return boundary;
            }
            ArrayList<Block> air_above_with_boundary_below = new ArrayList<Block>();
            air_above_with_boundary_below.add(block);
            Block air_above_origin2 = boundary.origin_block().getRelative(0, 2, 0);
            Block air_above_origin3 = boundary.origin_block().getRelative(0, 3, 0);
            if (!boundary.portal_area_blocks().contains(air_above_origin2) || !boundary.portal_area_blocks().contains(air_above_origin3)) {
                boundary.error_state = ErrorState.NOT_ENOUGH_PORTAL_BLOCKS_ABOVE_ORIGIN;
                return boundary;
            }
            int mod_x = boundary.plane().x() ? 1 : 0;
            int mod_z = boundary.plane().z() ? 1 : 0;
            PortalBoundary.add3_air_stacks(portal_constructor, block, air_above_with_boundary_below, false, -mod_x, -mod_z);
            PortalBoundary.add3_air_stacks(portal_constructor, block, air_above_with_boundary_below, true, mod_x, mod_z);
            if (air_above_with_boundary_below.size() < 1) {
                boundary.error_state = boundary.plane().x() ? ErrorState.TOO_SMALL_SPAWN_X : ErrorState.TOO_SMALL_SPAWN_Z;
                return boundary;
            }
            Block small_coord_end = air_above_with_boundary_below.get(0);
            Block large_coord_end = air_above_with_boundary_below.get(air_above_with_boundary_below.size() - 1);
            double middle_x = 0.5 + (double)(small_coord_end.getX() + large_coord_end.getX()) / 2.0;
            double middle_z = 0.5 + (double)(small_coord_end.getZ() + large_coord_end.getZ()) / 2.0;
            boundary.spawn = new Location(block.getWorld(), middle_x, (double)block.getY() + 0.05, middle_z);
        }
        return boundary;
    }

    public static PortalBoundary search_at(PortalConstructor portal_constructor, Block block) {
        PortalBoundary boundary = PortalBoundary.search_at(portal_constructor, block, Plane.XY);
        if (boundary != null) {
            return boundary;
        }
        boundary = PortalBoundary.search_at(portal_constructor, block, Plane.YZ);
        if (boundary != null) {
            return boundary;
        }
        return PortalBoundary.search_at(portal_constructor, block, Plane.XZ);
    }

    public String toString() {
        return "PortalBoundary{origin_block = " + String.valueOf(this.origin_block) + ", plane = " + String.valueOf((Object)this.plane) + "}";
    }

    public static enum ErrorState {
        NONE,
        NO_ORIGIN,
        MULTIPLE_ORIGINS,
        TOO_SMALL_SPAWN_X,
        TOO_SMALL_SPAWN_Y,
        TOO_SMALL_SPAWN_Z,
        TOO_LARGE_X,
        TOO_LARGE_Y,
        TOO_LARGE_Z,
        NO_PORTAL_BLOCK_ABOVE_ORIGIN,
        NOT_ENOUGH_PORTAL_BLOCKS_ABOVE_ORIGIN,
        TOO_MANY_PORTAL_AREA_BLOCKS,
        PORTAL_AREA_OBSTRUCTED;

    }
}

