/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.portals.portal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.portals.portal.PortalBlock;
import org.oddlama.vane.util.StorageUtil;

public class Style {
    private NamespacedKey key;
    private Map<PortalBlock.Type, Material> active_materials = new HashMap<PortalBlock.Type, Material>();
    private Map<PortalBlock.Type, Material> inactive_materials = new HashMap<PortalBlock.Type, Material>();

    public static Object serialize(@NotNull Object o) throws IOException {
        Style style = (Style)o;
        JSONObject json = new JSONObject();
        json.put("key", PersistentSerializer.to_json(NamespacedKey.class, (Object)style.key));
        try {
            json.put("active_materials", PersistentSerializer.to_json((Field)Style.class.getDeclaredField("active_materials"), style.active_materials));
            json.put("inactive_materials", PersistentSerializer.to_json((Field)Style.class.getDeclaredField("inactive_materials"), style.inactive_materials));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        return json;
    }

    public static Style deserialize(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        Style style = new Style(null);
        style.key = (NamespacedKey)PersistentSerializer.from_json(NamespacedKey.class, (Object)json.get("key"));
        try {
            style.active_materials = (Map)PersistentSerializer.from_json((Field)Style.class.getDeclaredField("active_materials"), (Object)json.get("active_materials"));
            style.inactive_materials = (Map)PersistentSerializer.from_json((Field)Style.class.getDeclaredField("inactive_materials"), (Object)json.get("inactive_materials"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Invalid field. This is a bug.", e);
        }
        return style;
    }

    public Style(NamespacedKey key) {
        this.key = key;
    }

    public NamespacedKey key() {
        return this.key;
    }

    public Material material(boolean active, PortalBlock.Type type) {
        if (active) {
            return this.active_materials.get((Object)type);
        }
        return this.inactive_materials.get((Object)type);
    }

    public static NamespacedKey default_style_key() {
        return StorageUtil.namespaced_key((String)"vane_portals", (String)"portal_style_default");
    }

    public void set_material(boolean active, PortalBlock.Type type, Material material) {
        this.set_material(active, type, material, false);
    }

    public void set_material(boolean active, PortalBlock.Type type, Material material, boolean overwrite) {
        Map<PortalBlock.Type, Material> map = active ? this.active_materials : this.inactive_materials;
        if (!overwrite && map.containsKey((Object)type)) {
            throw new RuntimeException("Invalid style definition! PortalBlock.Type." + String.valueOf((Object)type) + " was specified multiple times.");
        }
        map.put(type, material);
    }

    public void check_valid() {
        for (PortalBlock.Type type : PortalBlock.Type.values()) {
            if (!this.active_materials.containsKey((Object)type)) {
                throw new RuntimeException("Invalid style definition! Active state for PortalBlock.Type." + String.valueOf((Object)type) + " was not specified!");
            }
            if (this.inactive_materials.containsKey((Object)type)) continue;
            throw new RuntimeException("Invalid style definition! Inactive state for PortalBlock.Type." + String.valueOf((Object)type) + " was not specified!");
        }
    }

    public static Style default_style() {
        Style style = new Style(Style.default_style_key());
        style.set_material(true, PortalBlock.Type.BOUNDARY_1, Material.OBSIDIAN);
        style.set_material(true, PortalBlock.Type.BOUNDARY_2, Material.CRYING_OBSIDIAN);
        style.set_material(true, PortalBlock.Type.BOUNDARY_3, Material.GOLD_BLOCK);
        style.set_material(true, PortalBlock.Type.BOUNDARY_4, Material.GILDED_BLACKSTONE);
        style.set_material(true, PortalBlock.Type.BOUNDARY_5, Material.EMERALD_BLOCK);
        style.set_material(true, PortalBlock.Type.CONSOLE, Material.ENCHANTING_TABLE);
        style.set_material(true, PortalBlock.Type.ORIGIN, Material.OBSIDIAN);
        style.set_material(true, PortalBlock.Type.PORTAL, Material.END_GATEWAY);
        style.set_material(false, PortalBlock.Type.BOUNDARY_1, Material.OBSIDIAN);
        style.set_material(false, PortalBlock.Type.BOUNDARY_2, Material.CRYING_OBSIDIAN);
        style.set_material(false, PortalBlock.Type.BOUNDARY_3, Material.GOLD_BLOCK);
        style.set_material(false, PortalBlock.Type.BOUNDARY_4, Material.GILDED_BLACKSTONE);
        style.set_material(false, PortalBlock.Type.BOUNDARY_5, Material.EMERALD_BLOCK);
        style.set_material(false, PortalBlock.Type.CONSOLE, Material.ENCHANTING_TABLE);
        style.set_material(false, PortalBlock.Type.ORIGIN, Material.OBSIDIAN);
        style.set_material(false, PortalBlock.Type.PORTAL, Material.AIR);
        return style;
    }

    public Style copy(NamespacedKey new_key) {
        Style copy = new Style(new_key);
        copy.active_materials = new HashMap<PortalBlock.Type, Material>(this.active_materials);
        copy.inactive_materials = new HashMap<PortalBlock.Type, Material>(this.inactive_materials);
        return copy;
    }
}

