/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.bedtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.VaneModule;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.bedtime.BedtimeBlueMapLayer;
import org.oddlama.vane.bedtime.BedtimeDynmapLayer;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.util.Nms;
import org.oddlama.vane.util.WorldUtil;

@VaneModule(name="bedtime", bstats=8639, config_version=3L, lang_version=5L, storage_version=1L)
public class Bedtime
extends Module<Bedtime> {
    private HashMap<UUID, HashSet<UUID>> world_sleepers = new HashMap();
    @ConfigDouble(def=0.5, min=0.0, max=1.0, desc="The percentage of sleeping players required to advance time.")
    double config_sleep_threshold;
    @ConfigLong(def=1000L, min=0L, max=12000L, desc="The target time in ticks to advance to. 1000 is just after sunrise.")
    long config_target_time;
    @ConfigLong(def=100L, min=0L, max=1200L, desc="The interpolation time in ticks for a smooth change of time.")
    long config_interpolation_ticks;
    @LangMessage
    private TranslatedMessage lang_player_bed_enter;
    @LangMessage
    private TranslatedMessage lang_player_bed_leave;
    public BedtimeDynmapLayer dynmap_layer = new BedtimeDynmapLayer((Context<Bedtime>)this);
    public BedtimeBlueMapLayer blue_map_layer = new BedtimeBlueMapLayer((Context<Bedtime>)this);

    public void start_check_world_task(World world) {
        if (this.enough_players_sleeping(world)) {
            this.schedule_task(() -> this.check_world_now(world), 98L);
        }
    }

    public void check_world_now(World world) {
        if (!this.enough_players_sleeping(world)) {
            return;
        }
        WorldUtil.change_time_smoothly((World)world, (Plugin)this, (long)this.config_target_time, (long)this.config_interpolation_ticks);
        world.setStorm(false);
        world.setThundering(false);
        this.reset_sleepers(world);
        world.getPlayers().stream().filter(LivingEntity::isSleeping).forEach(p -> Nms.get_player((Player)p).stopSleepInBed(false, false));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_bed_enter(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        this.dynmap_layer.update_marker((OfflinePlayer)player);
        this.blue_map_layer.update_marker((OfflinePlayer)player);
        this.schedule_next_tick(() -> {
            this.add_sleeping(world, player);
            this.start_check_world_task(world);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_bed_leave(PlayerBedLeaveEvent event) {
        this.remove_sleeping(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_quit(PlayerQuitEvent event) {
        this.start_check_world_task(event.getPlayer().getWorld());
    }

    private static String percentage_str(double percentage) {
        return String.format("\u00a76%.2f", 100.0 * percentage) + "%";
    }

    private long get_amount_sleeping(World world) {
        UUID world_id = world.getUID();
        HashSet<UUID> sleepers = this.world_sleepers.get(world_id);
        if (sleepers == null) {
            return 0L;
        }
        return sleepers.size();
    }

    private long get_potential_sleepers_in_world(World world) {
        return world.getPlayers().stream().filter(p -> p.getGameMode() != GameMode.SPECTATOR).count();
    }

    private double get_percentage_sleeping(World world) {
        long count_sleeping = this.get_amount_sleeping(world);
        if (count_sleeping == 0L) {
            return 0.0;
        }
        return (double)count_sleeping / (double)this.get_potential_sleepers_in_world(world);
    }

    private boolean enough_players_sleeping(World world) {
        return this.get_percentage_sleeping(world) >= this.config_sleep_threshold;
    }

    private void add_sleeping(World world, Player player) {
        UUID world_id = world.getUID();
        HashSet sleepers = this.world_sleepers.computeIfAbsent(world_id, k -> new HashSet());
        sleepers.add(player.getUniqueId());
        double percent = this.get_percentage_sleeping(world);
        long count_sleeping = this.get_amount_sleeping(world);
        int count_required = (int)Math.ceil((double)this.get_potential_sleepers_in_world(world) * this.config_sleep_threshold);
        this.lang_player_bed_enter.broadcast_world_action_bar(world, new Object[]{"\u00a76" + player.getName(), "\u00a76" + Bedtime.percentage_str(percent), String.valueOf(count_sleeping), String.valueOf(count_required), "\u00a76" + world.getName()});
    }

    private void remove_sleeping(Player player) {
        World world = player.getWorld();
        UUID world_id = world.getUID();
        HashSet<UUID> sleepers = this.world_sleepers.get(world_id);
        if (sleepers == null) {
            return;
        }
        if (sleepers.remove(player.getUniqueId())) {
            double percent = this.get_percentage_sleeping(world);
            long count_sleeping = this.get_amount_sleeping(world);
            int count_required = (int)Math.ceil((double)this.get_potential_sleepers_in_world(world) * this.config_sleep_threshold);
            this.lang_player_bed_leave.broadcast_world_action_bar(world, new Object[]{"\u00a76" + player.getName(), "\u00a76" + Bedtime.percentage_str(percent), String.valueOf(count_sleeping), String.valueOf(count_required), "\u00a76" + world.getName()});
        }
    }

    private void reset_sleepers(World world) {
        UUID world_id = world.getUID();
        HashSet<UUID> sleepers = this.world_sleepers.get(world_id);
        if (sleepers == null) {
            return;
        }
        sleepers.clear();
    }
}

