/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.bedtime;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.HtmlMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.bedtime.Bedtime;
import org.oddlama.vane.bedtime.BedtimeBlueMapLayer;
import org.oddlama.vane.external.apache.commons.text.StringEscapeUtils;

public class BedtimeBlueMapLayerDelegate {
    public static final String MARKER_SET_ID = "vane_bedtime.bedtime";
    private final BedtimeBlueMapLayer parent;
    private boolean bluemap_enabled = false;
    private final HashMap<UUID, MarkerSet> marker_sets = new HashMap();

    public BedtimeBlueMapLayerDelegate(BedtimeBlueMapLayer parent) {
        this.parent = parent;
    }

    public Bedtime get_module() {
        return (Bedtime)this.parent.get_module();
    }

    public void on_enable(Plugin plugin) {
        BlueMapAPI.onEnable(api -> {
            this.get_module().log.info("Enabling BlueMap integration");
            this.bluemap_enabled = true;
            for (World world : this.get_module().getServer().getWorlds()) {
                this.create_marker_set((BlueMapAPI)api, world);
            }
            this.update_all_markers();
        });
    }

    public void on_disable() {
        if (!this.bluemap_enabled) {
            return;
        }
        this.get_module().log.info("Disabling BlueMap integration");
        this.bluemap_enabled = false;
    }

    private void create_marker_set(BlueMapAPI api, World world) {
        if (this.marker_sets.containsKey(world.getUID())) {
            return;
        }
        MarkerSet marker_set = MarkerSet.builder().label(this.parent.lang_layer_label.str(new Object[0])).toggleable(Boolean.valueOf(true)).defaultHidden(Boolean.valueOf(this.parent.config_hide_by_default)).build();
        api.getWorld((Object)world).ifPresent(bm_world -> {
            for (BlueMapMap map : bm_world.getMaps()) {
                map.getMarkerSets().put(MARKER_SET_ID, marker_set);
            }
        });
        this.marker_sets.put(world.getUID(), marker_set);
    }

    public void update_marker(OfflinePlayer player) {
        this.remove_marker(player.getUniqueId());
        Location loc = player.getRespawnLocation();
        if (loc == null) {
            return;
        }
        HtmlMarker marker = ((HtmlMarker.Builder)((HtmlMarker.Builder)HtmlMarker.builder().position(loc.getX(), loc.getY(), loc.getZ())).label("Bed for " + player.getName())).html(this.parent.lang_marker_label.str(new Object[]{StringEscapeUtils.escapeHtml4((String)player.getName())})).build();
        this.marker_sets.get(loc.getWorld().getUID()).getMarkers().put(player.getUniqueId().toString(), marker);
    }

    public void remove_marker(UUID player_id) {
        for (MarkerSet marker_set : this.marker_sets.values()) {
            marker_set.getMarkers().remove(player_id.toString());
        }
    }

    public void update_all_markers() {
        for (OfflinePlayer player : this.get_module().get_offline_players_with_valid_name()) {
            this.update_marker(player);
        }
    }
}

