/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.bedtime;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.bedtime.Bedtime;
import org.oddlama.vane.bedtime.BedtimeDynmapLayerDelegate;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;

public class BedtimeDynmapLayer
extends ModuleComponent<Bedtime> {
    public static final String LAYER_ID = "vane_bedtime.bedtime";
    @ConfigInt(def=25, min=0, desc="Layer ordering priority.")
    public int config_layer_priority;
    @ConfigBoolean(def=false, desc="If the layer should be hidden by default.")
    public boolean config_layer_hide;
    @ConfigString(def="house", desc="The dynmap marker icon.")
    public String config_marker_icon;
    @LangMessage
    public TranslatedMessage lang_layer_label;
    @LangMessage
    public TranslatedMessage lang_marker_label;
    private BedtimeDynmapLayerDelegate delegate = null;

    public BedtimeDynmapLayer(Context<Bedtime> context) {
        super((Context)context.group("dynmap", "Enable dynmap integration. Player spawnpoints (beds) will then be shown on a separate dynmap layer."));
    }

    public void delayed_on_enable() {
        Plugin plugin = ((Bedtime)this.get_module()).getServer().getPluginManager().getPlugin("dynmap");
        if (plugin == null) {
            return;
        }
        this.delegate = new BedtimeDynmapLayerDelegate(this);
        this.delegate.on_enable(plugin);
    }

    public void on_enable() {
        this.schedule_next_tick(this::delayed_on_enable);
    }

    public void on_disable() {
        if (this.delegate != null) {
            this.delegate.on_disable();
            this.delegate = null;
        }
    }

    public void update_marker(OfflinePlayer player) {
        if (this.delegate != null) {
            this.delegate.update_marker(player);
        }
    }

    public void remove_marker(UUID player_id) {
        if (this.delegate != null) {
            this.delegate.remove_marker(player_id);
        }
    }

    public void remove_marker(String marker_id) {
        if (this.delegate != null) {
            this.delegate.remove_marker(marker_id);
        }
    }

    public void update_all_markers() {
        if (this.delegate != null) {
            this.delegate.update_all_markers();
        }
    }
}

