/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.bedtime;

import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.oddlama.vane.bedtime.Bedtime;
import org.oddlama.vane.bedtime.BedtimeDynmapLayer;

public class BedtimeDynmapLayerDelegate {
    private final BedtimeDynmapLayer parent;
    private DynmapCommonAPI dynmap_api = null;
    private MarkerAPI marker_api = null;
    private boolean dynmap_enabled = false;
    private MarkerSet marker_set = null;
    private MarkerIcon marker_icon = null;

    public BedtimeDynmapLayerDelegate(BedtimeDynmapLayer parent) {
        this.parent = parent;
    }

    public Bedtime get_module() {
        return (Bedtime)this.parent.get_module();
    }

    public void on_enable(Plugin plugin) {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI api) {
                    BedtimeDynmapLayerDelegate.this.dynmap_api = api;
                    BedtimeDynmapLayerDelegate.this.marker_api = BedtimeDynmapLayerDelegate.this.dynmap_api.getMarkerAPI();
                }
            });
        }
        catch (Exception e) {
            this.get_module().log.log(Level.WARNING, "Error while enabling dynmap integration!", e);
            return;
        }
        if (this.marker_api == null) {
            return;
        }
        this.get_module().log.info("Enabling dynmap integration");
        this.dynmap_enabled = true;
        this.create_or_load_layer();
    }

    public void on_disable() {
        if (!this.dynmap_enabled) {
            return;
        }
        this.get_module().log.info("Disabling dynmap integration");
        this.dynmap_enabled = false;
        this.dynmap_api = null;
        this.marker_api = null;
    }

    private void create_or_load_layer() {
        this.marker_set = this.marker_api.getMarkerSet("vane_bedtime.bedtime");
        if (this.marker_set == null) {
            this.marker_set = this.marker_api.createMarkerSet("vane_bedtime.bedtime", this.parent.lang_layer_label.str(new Object[0]), null, false);
        }
        if (this.marker_set == null) {
            this.get_module().log.severe("Failed to create dynmap bedtime marker set!");
            return;
        }
        this.marker_set.setMarkerSetLabel(this.parent.lang_layer_label.str(new Object[0]));
        this.marker_set.setLayerPriority(this.parent.config_layer_priority);
        this.marker_set.setHideByDefault(this.parent.config_layer_hide);
        this.marker_icon = this.marker_api.getMarkerIcon(this.parent.config_marker_icon);
        if (this.marker_icon == null) {
            this.get_module().log.severe("Failed to load dynmap bedtime marker icon!");
            return;
        }
        this.update_all_markers();
    }

    private String id_for(UUID player_id) {
        return player_id.toString();
    }

    private String id_for(OfflinePlayer player) {
        return this.id_for(player.getUniqueId());
    }

    public boolean update_marker(OfflinePlayer player) {
        if (!this.dynmap_enabled) {
            return false;
        }
        Location loc = player.getRespawnLocation();
        if (loc == null) {
            return false;
        }
        String world_name = loc.getWorld().getName();
        String marker_id = this.id_for(player);
        String marker_label = this.parent.lang_marker_label.str(new Object[]{player.getName()});
        this.marker_set.createMarker(marker_id, marker_label, world_name, loc.getX(), loc.getY(), loc.getZ(), this.marker_icon, false);
        return true;
    }

    public void remove_marker(UUID player_id) {
        this.remove_marker(this.id_for(player_id));
    }

    public void remove_marker(String marker_id) {
        if (!this.dynmap_enabled || marker_id == null) {
            return;
        }
        this.remove_marker(this.marker_set.findMarker(marker_id));
    }

    public void remove_marker(Marker marker) {
        if (!this.dynmap_enabled || marker == null) {
            return;
        }
        marker.deleteMarker();
    }

    public void update_all_markers() {
        if (!this.dynmap_enabled) {
            return;
        }
        HashSet<String> id_set = new HashSet<String>();
        for (OfflinePlayer player : this.get_module().get_offline_players_with_valid_name()) {
            if (!this.update_marker(player)) continue;
            id_set.add(this.id_for(player));
        }
        for (Marker marker : this.marker_set.getMarkers()) {
            String id = marker.getMarkerID();
            if (id == null || id_set.contains(id)) continue;
            this.remove_marker(marker);
        }
    }
}

