/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.admin;

import org.bukkit.command.CommandSender;
import org.bukkit.scheduler.BukkitTask;
import org.oddlama.vane.admin.Admin;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleGroup;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.TimeUtil;

public class AutostopGroup
extends ModuleGroup<Admin> {
    @ConfigLong(def=1200L, min=0L, desc="Delay in seconds after which to stop the server.")
    public long config_delay;
    @LangMessage
    public TranslatedMessage lang_aborted;
    @LangMessage
    public TranslatedMessage lang_scheduled;
    @LangMessage
    public TranslatedMessage lang_status;
    @LangMessage
    public TranslatedMessage lang_status_not_scheduled;
    @LangMessage
    public TranslatedMessage lang_shutdown;
    public BukkitTask task = null;
    public long start_time = -1L;
    public long stop_time = -1L;

    public AutostopGroup(Context<Admin> context) {
        super(context, "autostop", "Enable automatic server stop after certain time without online players.");
    }

    public long remaining() {
        if (this.start_time == -1L) {
            return -1L;
        }
        return this.stop_time - System.currentTimeMillis();
    }

    public void abort() {
        this.abort(null);
    }

    public void abort(CommandSender sender) {
        if (this.task == null) {
            this.lang_status_not_scheduled.send(sender, new Object[0]);
            return;
        }
        this.task.cancel();
        this.task = null;
        this.start_time = -1L;
        this.stop_time = -1L;
        this.lang_aborted.send_and_log(sender, new Object[0]);
    }

    public void schedule() {
        this.schedule(null);
    }

    public void schedule(CommandSender sender) {
        this.schedule(sender, this.config_delay * 1000L);
    }

    public void schedule(CommandSender sender, long delay) {
        if (this.task != null) {
            this.abort(sender);
        }
        this.start_time = System.currentTimeMillis();
        this.stop_time = this.start_time + delay;
        this.task = this.schedule_task(() -> {
            this.lang_shutdown.send_and_log(null, new Object[0]);
            ((Admin)this.get_module()).getServer().shutdown();
        }, Conversions.ms_to_ticks((long)delay));
        this.lang_scheduled.send_and_log(sender, new Object[]{"\u00a7b" + TimeUtil.format_time((long)delay)});
    }

    public void status(CommandSender sender) {
        if (this.task == null) {
            this.lang_status_not_scheduled.send(sender, new Object[0]);
            return;
        }
        this.lang_status.send(sender, new Object[]{"\u00a7b" + TimeUtil.format_time((long)this.remaining())});
    }

    public void on_enable() {
        if (((Admin)this.get_module()).getServer().getOnlinePlayers().isEmpty()) {
            this.schedule();
        }
    }
}

