/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.admin;

import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.oddlama.vane.admin.Admin;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;

public class ChatMessageFormatter
extends Listener<Admin> {
    @LangMessage
    private TranslatedMessage lang_player_chat_format;
    @LangMessage
    private TranslatedMessage lang_player_join;
    @LangMessage
    private TranslatedMessage lang_player_kick;
    @LangMessage
    private TranslatedMessage lang_player_quit;
    final ChatRenderer chat_renderer = new ChatRenderer(){

        public Component render(Player source, Component sourceDisplayName, Component message, Audience viewer) {
            Component who = sourceDisplayName.color((TextColor)NamedTextColor.AQUA);
            return ChatMessageFormatter.this.lang_player_chat_format.str_component(new Object[]{who, message});
        }
    };

    public ChatMessageFormatter(Context<Admin> context) {
        super((Context)context.group("chat_message_formatter", "Enables custom formatting of chat messages like player chats and join / quit messages."));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_chat(AsyncChatEvent event) {
        event.renderer(this.chat_renderer);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_join(PlayerJoinEvent event) {
        event.joinMessage(null);
        this.lang_player_join.broadcast_server(new Object[]{event.getPlayer().playerListName().color((TextColor)NamedTextColor.GOLD)});
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_player_kick(PlayerKickEvent event) {
        event.leaveMessage((Component)Component.text((String)""));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_player_quit(PlayerQuitEvent event) {
        event.quitMessage(null);
        if (event.getReason() == PlayerQuitEvent.QuitReason.KICKED) {
            this.lang_player_kick.broadcast_server(new Object[]{event.getPlayer().playerListName().color((TextColor)NamedTextColor.GOLD)});
        } else {
            this.lang_player_quit.broadcast_server(new Object[]{event.getPlayer().playerListName().color((TextColor)NamedTextColor.GOLD)});
        }
    }
}

