/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.admin;

import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.oddlama.vane.admin.Admin;
import org.oddlama.vane.admin.WorldRebuild;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigStringList;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;

public class HazardProtection
extends Listener<Admin> {
    private WorldRebuild world_rebuild = new WorldRebuild((Context<Admin>)this.get_context());
    @ConfigBoolean(def=true, desc="Restrict wither spawning to a list of worlds defined by wither_world_whitelist.")
    private boolean config_enable_wither_world_whitelist;
    @ConfigStringList(def={"world_nether", "world_the_end"}, desc="A list of worlds in which the wither may be spawned.")
    private List<String> config_wither_world_whitelist;
    @ConfigBoolean(def=true, desc="Disables explosions from the wither.")
    private boolean config_disable_wither_explosions;
    @ConfigBoolean(def=true, desc="Disables explosions from creepers.")
    private boolean config_disable_creeper_explosions;
    @ConfigBoolean(def=true, desc="Disables enderman block pickup.")
    private boolean config_disable_enderman_block_pickup;
    @ConfigBoolean(def=true, desc="Disables entities from breaking doors (various zombies).")
    private boolean config_disable_door_breaking;
    @ConfigBoolean(def=true, desc="Disables fire from lightning.")
    private boolean config_disable_lightning_fire;
    @LangMessage
    private TranslatedMessage lang_wither_spawn_prohibited;

    public HazardProtection(Context<Admin> context) {
        super((Context)context.group("hazard_protection", "Enable hazard protection. The options below allow more fine-grained control over the hazards to protect from."));
    }

    private boolean disable_explosion(EntityType type) {
        switch (type) {
            default: {
                return false;
            }
            case WITHER: 
            case WITHER_SKULL: {
                return this.config_disable_wither_explosions;
            }
            case CREEPER: 
        }
        return this.config_disable_creeper_explosions;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_entity_explode(EntityExplodeEvent event) {
        if (this.disable_explosion(event.getEntityType())) {
            if (this.world_rebuild.enabled()) {
                this.world_rebuild.rebuild(event.blockList());
                event.blockList().clear();
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_hanging_break_by_entity(HangingBreakByEntityEvent event) {
        if (this.disable_explosion(event.getRemover().getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_entity_break_door(EntityBreakDoorEvent event) {
        if (this.config_disable_door_breaking) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_block_ignite(BlockIgniteEvent event) {
        if (event.getCause() == BlockIgniteEvent.IgniteCause.LIGHTNING && this.config_disable_lightning_fire) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_creature_spawn(CreatureSpawnEvent event) {
        if (!this.config_enable_wither_world_whitelist) {
            return;
        }
        if (event.getEntity().getType() != EntityType.WITHER) {
            return;
        }
        World world = event.getEntity().getWorld();
        if (this.config_wither_world_whitelist.contains(world.getName())) {
            return;
        }
        this.lang_wither_spawn_prohibited.broadcast_world(world, new Object[]{world.getName()});
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_entity_block_change(EntityChangeBlockEvent event) {
        if (!this.config_disable_enderman_block_pickup) {
            return;
        }
        if (event.getEntity().getType() != EntityType.ENDERMAN) {
            return;
        }
        event.setCancelled(true);
    }
}

