/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.admin;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.oddlama.vane.admin.Admin;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;

public class SpawnProtection
extends Listener<Admin> {
    private static final String PERMISSION_NAME = "vane.admin.bypass_spawn_protection";
    private Permission permission = new Permission("vane.admin.bypass_spawn_protection", "Allow player to bypass spawn protection", PermissionDefault.OP);
    @ConfigBoolean(def=true, desc="Allow interaction events at spawn (buttons, levers, etc.).")
    private boolean config_allow_interaction;
    @ConfigInt(def=64, min=0, desc="Radius to protect.")
    private int config_radius;
    @ConfigString(def="world", desc="The spawn world.")
    private String config_world;
    @ConfigBoolean(def=true, desc="Use world's spawn location instead of the specified center coordinates.")
    private boolean config_use_spawn_location;
    @ConfigInt(def=0, desc="Center X coordinate.")
    private int config_x;
    @ConfigInt(def=0, desc="Center Z coordinate.")
    private int config_z;
    private Location spawn_center = null;

    public SpawnProtection(Context<Admin> context) {
        super((Context)context.group_default_disabled("spawn_protection", "Enable spawn protection. Slightly more sophisticated than the vanilla spawn protection, if you need even more control, use regions. This will prevent anyone from modifying the spawn of the world if they don't have the permission 'vane.admin.bypass_spawn_protection'."));
        ((Admin)this.get_module()).register_permission(this.permission);
    }

    public void on_config_change() {
        this.spawn_center = null;
        this.schedule_next_tick(() -> {
            World world = ((Admin)this.get_module()).getServer().getWorld(this.config_world);
            if (world == null) {
                ((Admin)this.get_module()).log.warning("The world \"" + this.config_world + "\" configured for spawn-protection could not be found.");
                ((Admin)this.get_module()).log.warning("These are the names of worlds existing on this server:");
                for (World w : ((Admin)this.get_module()).getServer().getWorlds()) {
                    ((Admin)this.get_module()).log.warning("  \"" + w.getName() + "\"");
                }
                this.spawn_center = null;
            } else if (this.config_use_spawn_location) {
                this.spawn_center = world.getSpawnLocation();
                this.spawn_center.setY(0.0);
            } else {
                this.spawn_center = new Location(world, (double)this.config_x, 0.0, (double)this.config_z);
            }
        });
    }

    public boolean deny_modify_spawn(Block block, Entity entity) {
        return this.deny_modify_spawn(block.getLocation(), entity);
    }

    public boolean deny_modify_spawn(Location location, Entity entity) {
        double dz;
        if (this.spawn_center == null || !(entity instanceof Player)) {
            return false;
        }
        double dx = location.getX() - this.spawn_center.getX();
        double distance = Math.sqrt(dx * dx + (dz = location.getZ() - this.spawn_center.getZ()) * dz);
        if (distance > (double)this.config_radius) {
            return false;
        }
        return !entity.hasPermission(this.permission);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_block_break(BlockBreakEvent event) {
        if (this.deny_modify_spawn(event.getBlock(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_block_place(BlockPlaceEvent event) {
        if (this.deny_modify_spawn(event.getBlock(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_hanging_break_by_entity(HangingBreakByEntityEvent event) {
        if (this.deny_modify_spawn(event.getEntity().getLocation(), event.getRemover())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_hanging_place(HangingPlaceEvent event) {
        if (this.deny_modify_spawn(event.getEntity().getLocation(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_armor_stand_manipulate(PlayerArmorStandManipulateEvent event) {
        if (this.deny_modify_spawn(event.getRightClicked().getLocation(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_bucket_empty(PlayerBucketEmptyEvent event) {
        if (this.deny_modify_spawn(event.getBlock(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_bucket_fill(PlayerBucketFillEvent event) {
        if (this.deny_modify_spawn(event.getBlock(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_interact_entity(PlayerInteractEntityEvent event) {
        if (!this.config_allow_interaction && this.deny_modify_spawn(event.getRightClicked().getLocation(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_interact(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && !this.config_allow_interaction && this.deny_modify_spawn(event.getClickedBlock(), (Entity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }
}

