/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.admin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.oddlama.vane.admin.Admin;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.Nms;

public class WorldRebuild
extends Listener<Admin> {
    @ConfigLong(def=2000L, min=0L, desc="Delay in milliseconds until the world will be rebuilt.")
    private long config_delay;
    @ConfigDouble(def=0.175, min=0.0, desc="Determines rebuild speed. Higher falloff means faster transition to quicker rebuild. After n blocks, the delay until the next block will be d_n = delay * exp(-x * delay_falloff). For example 0.0 will result in same delay for every block.")
    private double config_delay_falloff;
    @ConfigLong(def=50L, min=50L, desc="Minimum delay in milliseconds between rebuilding two blocks. Anything <= 50 milliseconds will be one tick.")
    private long config_min_delay;
    private final List<Rebuilder> rebuilders = new ArrayList<Rebuilder>();

    public WorldRebuild(Context<Admin> context) {
        super((Context)context.group("world_rebuild", "Instead of cancelling explosions, the world will regenerate after a short amount of time."));
    }

    public void rebuild(List<Block> blocks) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (Block block : blocks) {
            states.add(block.getState());
        }
        for (Block block : blocks) {
            Nms.set_air_no_drops((Block)block);
        }
        this.rebuilders.add(new Rebuilder(states));
    }

    public void on_disable() {
        for (Rebuilder r : new ArrayList<Rebuilder>(this.rebuilders)) {
            r.finish_now();
        }
        this.rebuilders.clear();
    }

    public class Rebuilder
    implements Runnable {
        private List<BlockState> states;
        private BukkitTask task = null;
        private long amount_rebuild = 0L;

        public Rebuilder(List<BlockState> _states) {
            this.states = _states;
            if (this.states.isEmpty()) {
                return;
            }
            Vector center = new Vector(0, 0, 0);
            int max_y = 0;
            for (BlockState state : this.states) {
                max_y = Math.max(max_y, state.getY());
                center.add(state.getLocation().toVector());
            }
            center.multiply(1.0 / (double)this.states.size());
            center.setY(max_y + 1);
            this.states.sort(new RebuildComparator(center));
            this.task = ((Admin)WorldRebuild.this.get_module()).schedule_task(this, Conversions.ms_to_ticks((long)WorldRebuild.this.config_delay));
        }

        private void finish() {
            this.task = null;
            WorldRebuild.this.rebuilders.remove(this);
        }

        private void rebuild_next_block() {
            this.rebuild_block(this.states.remove(this.states.size() - 1));
        }

        private void rebuild_block(BlockState state) {
            Block block = state.getBlock();
            ++this.amount_rebuild;
            if (block.getType() != Material.AIR) {
                block.breakNaturally();
            }
            state.update(true, false);
            state.update(true, false);
            block.getWorld().playSound(block.getLocation(), block.getBlockSoundGroup().getPlaceSound(), SoundCategory.BLOCKS, 1.0f, 0.8f);
        }

        public void finish_now() {
            if (this.task != null) {
                this.task.cancel();
            }
            for (BlockState state : this.states) {
                this.rebuild_block(state);
            }
            this.finish();
        }

        @Override
        public void run() {
            if (this.states.isEmpty()) {
                this.finish();
            } else {
                this.rebuild_next_block();
                long delay = Conversions.ms_to_ticks((long)Math.max(WorldRebuild.this.config_min_delay, (long)((int)((double)WorldRebuild.this.config_delay * Math.exp((double)(-this.amount_rebuild) * WorldRebuild.this.config_delay_falloff)))));
                ((Admin)WorldRebuild.this.get_module()).schedule_task(this, delay);
            }
        }
    }

    public static class RebuildComparator
    implements Comparator<BlockState> {
        private Vector reference_point;

        public RebuildComparator(Vector reference_point) {
            this.reference_point = reference_point;
        }

        @Override
        public int compare(BlockState a, BlockState b) {
            double da = a.getLocation().toVector().subtract(this.reference_point).lengthSquared();
            double db = b.getLocation().toVector().subtract(this.reference_point).lengthSquared();
            return Double.compare(da, db);
        }
    }
}

