/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.data.CooldownData;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.StorageUtil;

public class ChestSorter
extends Listener<Trifles> {
    public static final NamespacedKey LAST_SORT_TIME = StorageUtil.namespaced_key((String)"vane_trifles", (String)"last_sort_time");
    @ConfigLong(def=1000L, min=0L, desc="Chest sorting cooldown in milliseconds.")
    public long config_cooldown;
    private CooldownData cooldown_data = null;
    @ConfigInt(def=1, min=0, max=16, desc="Chest sorting radius in X-direction from the button (left-right when looking at the button). A radius of 0 means a column of the block including the button. It is advised to NEVER set the three radius values to more than THREE (3), as sorting a huge area of chests can lead to SEVERE lag! Ideally always keep the Z-radius set to 0 or 1, while only adjusting X and Y. You've been warned.")
    public int config_radius_x;
    @ConfigInt(def=1, min=0, max=16, desc="Chest sorting radius in Y-direction from the button (up-down when looking at the button - this can be a horizontal direction if the button is on the ground). A radius of 0 means a column of the block including the button. It is advised to NEVER set the three radius values to more than THREE (3), as sorting a huge area of chests can lead to SEVERE lag! Ideally always keep the Z-radius set to 0 or 1, while only adjusting X and Y. You've been warned.")
    public int config_radius_y;
    @ConfigInt(def=1, min=0, max=16, desc="Chest sorting radius in Z-direction from the button (into/out-of the attached block). A radius of 0 means a column of the block including the button. It is advised to NEVER set the three radius values to more than THREE (3), as sorting a huge area of chests can lead to SEVERE lag! Ideally always keep the Z-radius set to 0 or 1, while only adjusting X and Y. You've been warned.")
    public int config_radius_z;

    public ChestSorter(Context<Trifles> context) {
        super((Context)context.group("chest_sorting", "Enables chest sorting when a nearby button is pressed."));
    }

    protected void on_config_change() {
        super.on_config_change();
        this.cooldown_data = new CooldownData(LAST_SORT_TIME, this.config_cooldown);
    }

    private void sort_inventory(Inventory inventory) {
        ItemStack[] saved_contents = inventory.getStorageContents();
        int non_null = 0;
        for (ItemStack i : saved_contents) {
            if (i == null) continue;
            ++non_null;
        }
        ItemStack[] saved_contents_condensed = new ItemStack[non_null];
        int cur = 0;
        for (ItemStack i : saved_contents) {
            if (i == null) continue;
            saved_contents_condensed[cur++] = i.clone();
        }
        try {
            inventory.clear();
            HashMap leftovers = inventory.addItem(saved_contents_condensed);
            if (leftovers.size() != 0) {
                inventory.setStorageContents(saved_contents_condensed);
                ((Trifles)this.get_module()).log.warning("Sorting inventory " + String.valueOf(inventory) + " produced leftovers!");
            }
        }
        catch (Exception e) {
            inventory.setStorageContents(saved_contents_condensed);
            throw e;
        }
        ItemStack[] contents = inventory.getStorageContents();
        Arrays.sort(contents, new ItemUtil.ItemStackComparator());
        inventory.setStorageContents(contents);
    }

    private void sort_container(Container container) {
        if (!this.cooldown_data.check_or_update_cooldown((PersistentDataHolder)container)) {
            return;
        }
        this.sort_inventory(container.getInventory());
    }

    private void sort_chest(Chest chest) {
        Chest persistent_chest;
        Inventory inventory = chest.getInventory();
        if (inventory instanceof DoubleChestInventory) {
            InventoryHolder left_side = ((DoubleChestInventory)inventory).getLeftSide().getHolder();
            if (!(left_side instanceof Chest)) {
                return;
            }
            persistent_chest = (Chest)left_side;
        } else {
            persistent_chest = chest;
        }
        if (!this.cooldown_data.check_or_update_cooldown((PersistentDataHolder)persistent_chest)) {
            return;
        }
        if (persistent_chest != chest) {
            persistent_chest.update(true, false);
        }
        this.sort_inventory(inventory);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void on_player_right_click(PlayerInteractEvent event) {
        int ry;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.useInteractedBlock() != Event.Result.ALLOW) {
            return;
        }
        Block root_block = event.getClickedBlock();
        if (!Tag.BUTTONS.isTagged((Keyed)root_block.getType())) {
            return;
        }
        BlockData button_data = root_block.getState().getBlockData();
        BlockFace facing = ((Directional)button_data).getFacing();
        FaceAttachable.AttachedFace face = ((FaceAttachable)button_data).getAttachedFace();
        int rx = 0;
        int rz = 0;
        if (face == FaceAttachable.AttachedFace.WALL) {
            ry = this.config_radius_y;
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    rx = this.config_radius_x;
                    rz = this.config_radius_z;
                    break;
                }
                case EAST: 
                case WEST: {
                    rx = this.config_radius_z;
                    rz = this.config_radius_x;
                    break;
                }
            }
        } else {
            ry = this.config_radius_z;
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    rx = this.config_radius_x;
                    rz = this.config_radius_y;
                    break;
                }
                case EAST: 
                case WEST: {
                    rx = this.config_radius_y;
                    rz = this.config_radius_x;
                    break;
                }
            }
        }
        for (int x = -rx; x <= rx; ++x) {
            for (int y = -ry; y <= ry; ++y) {
                for (int z = -rz; z <= rz; ++z) {
                    Block block = root_block.getRelative(x, y, z);
                    BlockState state = block.getState();
                    if (state instanceof Chest) {
                        this.sort_chest((Chest)state);
                        continue;
                    }
                    if (!(state instanceof Barrel)) continue;
                    this.sort_container((Container)((Barrel)state));
                }
            }
        }
    }
}

