/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.SingleDoor;
import org.oddlama.vane.trifles.Trifles;

public class DoubleDoorListener
extends Listener<Trifles> {
    public DoubleDoorListener(Context<Trifles> context) {
        super((Context)context.group("doubledoor", "Enable updating of double doors automatically when one of the doors is changed."));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_interact(PlayerInteractEvent event) {
        if (event.hasBlock() && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (event.getPlayer().isSneaking()) {
                return;
            }
            this.handle_double_door(event.getClickedBlock());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_entity_interact(EntityInteractEvent event) {
        Block block = event.getBlock();
        this.handle_double_door(block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_block_redstone(BlockRedstoneEvent event) {
        int old;
        int now = event.getNewCurrent();
        if (now != (old = event.getOldCurrent()) && (now == 0 || old == 0)) {
            this.handle_double_door(event.getBlock());
        }
    }

    public void handle_double_door(Block block) {
        SingleDoor first = SingleDoor.create_door_from_block(block);
        if (first == null) {
            return;
        }
        SingleDoor second = first.get_second_door();
        if (second == null) {
            return;
        }
        this.schedule_next_tick(() -> {
            if (!first.update_cached_state() || !second.update_cached_state()) {
                return;
            }
            second.set_open(first.isOpen());
        });
    }
}

