/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import io.papermc.paper.event.entity.EntityMoveEvent;
import net.minecraft.world.entity.monster.Monster;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.FastWalkingGroup;
import org.oddlama.vane.trifles.Trifles;

public class FastWalkingListener
extends Listener<Trifles> {
    FastWalkingGroup fast_walking;
    @ConfigBoolean(def=false, desc="Whether hostile mobs should be allowed to fast walk on paths.")
    public boolean config_hostile_speedwalk;
    @ConfigBoolean(def=true, desc="Whether villagers should be allowed to fast walk on paths.")
    public boolean config_villager_speedwalk;
    @ConfigBoolean(def=false, desc="Whether players should be the only entities allowed to fast walk on paths (will override other path walk settings).")
    public boolean config_players_only_speedwalk;

    public FastWalkingListener(FastWalkingGroup context) {
        super((Context)context);
        this.fast_walking = context;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_move(PlayerMoveEvent event) {
        Block block;
        Entity entity;
        Player player = event.getPlayer();
        if (player.isGliding()) {
            return;
        }
        Player effect_entity = player;
        if (player.isInsideVehicle() && (entity = player.getVehicle()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity;
            effect_entity = vehicle;
        }
        if (!this.fast_walking.config_materials.contains((block = effect_entity.getLocation().clone().subtract(0.0, 0.1, 0.0).getBlock()).getType())) {
            return;
        }
        effect_entity.addPotionEffect(this.fast_walking.walk_speed_effect);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_entity_move(EntityMoveEvent event) {
        LivingEntity entity = event.getEntity();
        if (this.config_players_only_speedwalk) {
            return;
        }
        if (entity instanceof Monster && !this.config_hostile_speedwalk) {
            return;
        }
        if (entity.getType() == EntityType.VILLAGER && !this.config_villager_speedwalk) {
            return;
        }
        Block block = event.getTo().clone().subtract(0.0, 0.1, 0.0).getBlock();
        if (!this.fast_walking.config_materials.contains(block.getType())) {
            return;
        }
        entity.addPotionEffect(this.fast_walking.walk_speed_effect);
    }
}

