/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.ItemFinderPacketUtils;
import org.oddlama.vane.trifles.Trifles;

public class ItemFinder
extends Listener<Trifles> {
    @ConfigInt(def=2, min=1, max=10, desc="The radius of chunks in which containers (and possibly entities) are checked for matching items.")
    public int config_radius;
    @ConfigBoolean(def=true, desc="Also search entities such as players, mobs, minecarts, ...")
    public boolean config_search_entities;
    @ConfigBoolean(def=false, desc="Only allow players to use the shift+rightclick shortcut when they have the shortcut permission `vane.trifles.use_item_find_shortcut`.")
    public boolean config_require_permission;
    private static final int FALLBACK_TASK_INTERVAL = 15;
    public final Permission use_item_find_shortcut_permission = new Permission("vane." + ((Trifles)this.get_module()).get_name() + ".use_item_find_shortcut", "Allows a player to use shfit+rightclick to search for items if the require_permission config is set", PermissionDefault.FALSE);

    public ItemFinder(Context<Trifles> context) {
        super((Context)context.group("item_finder", "Enables players to search for items in nearby containers by either shift-right-clicking a similar item in their inventory or by using the `/finditem <item>` command."));
        ((Trifles)this.get_module()).register_permission(this.use_item_find_shortcut_permission);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_player_click_inventory(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.config_require_permission && !player.hasPermission(this.use_item_find_shortcut_permission)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getClick() != ClickType.SHIFT_RIGHT) {
            return;
        }
        event.setCancelled(true);
        if (this.find_item(player, item.getType())) {
            ((Trifles)this.get_module()).schedule_next_tick(() -> ((Player)player).closeInventory());
        }
    }

    private boolean is_container(Block block) {
        return block.getState() instanceof Container;
    }

    private void fallback_indicate_match(@NotNull Player player, @NotNull Location location) {
        player.spawnParticle(Particle.DRIPPING_OBSIDIAN_TEAR, location, 130, 0.4, 0.0, 0.0, 0.0);
        player.spawnParticle(Particle.DRIPPING_OBSIDIAN_TEAR, location, 130, 0.0, 0.4, 0.0, 0.0);
        player.spawnParticle(Particle.DRIPPING_OBSIDIAN_TEAR, location, 130, 0.0, 0.0, 0.4, 0.0);
        player.spawnParticle(Particle.CAMPFIRE_SIGNAL_SMOKE, location, 70, 0.2, 0.2, 0.2, 0.0);
    }

    public boolean find_item(@NotNull Player player, @NotNull Material material) {
        boolean any_found = false;
        World world = player.getWorld();
        Chunk origin_chunk = player.getChunk();
        boolean packet_events_enabled = ((Trifles)this.get_module()).packet_events_enabled;
        for (int cx = origin_chunk.getX() - this.config_radius; cx <= origin_chunk.getX() + this.config_radius; ++cx) {
            for (int cz = origin_chunk.getZ() - this.config_radius; cz <= origin_chunk.getZ() + this.config_radius; ++cz) {
                if (!world.isChunkLoaded(cx, cz)) continue;
                Chunk chunk = world.getChunkAt(cx, cz);
                for (BlockState tile_entity : chunk.getTileEntities(this::is_container, false)) {
                    Container container;
                    if (!(tile_entity instanceof Container) || !(container = (Container)tile_entity).getInventory().contains(material)) continue;
                    if (container.getType() == Material.CHEST) {
                        if (packet_events_enabled) {
                            ItemFinderPacketUtils.indicate_chest_match((Trifles)this.get_module(), player, container);
                        } else {
                            this.fallback_indicate_match(player, container.getLocation().add(0.5, 0.5, 0.5));
                        }
                    } else if (packet_events_enabled) {
                        ItemFinderPacketUtils.indicate_container_match((Trifles)this.get_module(), player, container);
                    } else {
                        this.fallback_indicate_match(player, container.getLocation().add(0.5, 0.5, 0.5));
                    }
                    any_found = true;
                }
                if (!this.config_search_entities) continue;
                for (Entity entity : chunk.getEntities()) {
                    InventoryHolder holder;
                    if (entity == player || !(entity instanceof InventoryHolder) || !(holder = (InventoryHolder)entity).getInventory().contains(material)) continue;
                    if (packet_events_enabled) {
                        ItemFinderPacketUtils.indicate_entity_match((Trifles)this.get_module(), player, entity);
                    } else {
                        this.fallback_indicate_match(player, entity.getLocation());
                    }
                    any_found = true;
                }
            }
        }
        if (any_found) {
            player.playSound((Entity)player, Sound.BLOCK_AMETHYST_BLOCK_HIT, SoundCategory.MASTER, 1.0f, 1.3f);
        } else {
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 5.0f);
        }
        return any_found;
    }
}

