/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attribute;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.trifles.Trifles;

public class ItemFinderPacketUtils {
    private static final long GLOW_DURATION = 160L;
    private static final float CONTAINER_DEFAULT_SCALE = 0.95f;
    private static final float CONTAINER_DEFAULT_TRANSLATION = 0.025000006f;
    private static final float CHEST_DEFAULT_SCALE = 0.85f;

    static void indicate_entity_match(@NotNull Trifles module, final @NotNull Player player, @NotNull Entity entity) {
        List base_entity_data = SpigotConversionUtil.getEntityMetadata((Entity)entity);
        ArrayList<EntityData> glowing_entity_data = new ArrayList<EntityData>(base_entity_data);
        EntityData glow_data = new EntityData(0, EntityDataTypes.BYTE, (Object)64);
        glowing_entity_data.add(glow_data);
        final WrapperPlayServerEntityMetadata glowing_packet = new WrapperPlayServerEntityMetadata(entity.getEntityId(), glowing_entity_data);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)glowing_packet);
        BukkitTask repeating_packet_task = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                }
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)glowing_packet);
            }
        }.runTaskTimer((Plugin)module, 1L, 1L);
        ArrayList non_glowing_entity_data = new ArrayList(base_entity_data);
        WrapperPlayServerEntityMetadata non_glowing_packet = new WrapperPlayServerEntityMetadata(entity.getEntityId(), non_glowing_entity_data);
        new ResetGlowingPacketTask(player, (PacketWrapper<?>)non_glowing_packet, repeating_packet_task).runTaskLater((Plugin)module, 160L);
    }

    static void indicate_container_match(@NotNull Trifles module, @NotNull Player player, @NotNull Container container) {
        int display_id = SpigotReflectionUtil.generateEntityId();
        EntityType entity_type = container instanceof ShulkerBox ? EntityTypes.SHULKER : EntityTypes.BLOCK_DISPLAY;
        WrapperPlayServerSpawnEntity display_packet = new WrapperPlayServerSpawnEntity(display_id, UUID.randomUUID(), entity_type, SpigotConversionUtil.fromBukkitLocation((Location)container.getLocation()), container.getLocation().getYaw(), 0, null);
        ArrayList<EntityData> display_metadata = new ArrayList<EntityData>();
        display_metadata.add(new EntityData(0, EntityDataTypes.BYTE, (Object)96));
        if (entity_type == EntityTypes.BLOCK_DISPLAY) {
            display_metadata.add(new EntityData(11, EntityDataTypes.VECTOR3F, (Object)new Vector3f(0.025000006f, 0.025000006f, 0.025000006f)));
            display_metadata.add(new EntityData(12, EntityDataTypes.VECTOR3F, (Object)new Vector3f(0.95f, 0.95f, 0.95f)));
            display_metadata.add(new EntityData(23, EntityDataTypes.BLOCK_STATE, (Object)SpigotConversionUtil.fromBukkitBlockData((BlockData)container.getBlockData()).getGlobalId()));
        }
        WrapperPlayServerEntityMetadata display_metadata_packet = new WrapperPlayServerEntityMetadata(display_id, display_metadata);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)display_packet);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)display_metadata_packet);
        if (entity_type == EntityTypes.SHULKER) {
            Attribute scale_attribute = Attributes.SCALE;
            WrapperPlayServerUpdateAttributes.PropertyModifier attribute_modifier = new WrapperPlayServerUpdateAttributes.PropertyModifier(UUID.randomUUID(), -0.050000011920928955, WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.ADDITION);
            WrapperPlayServerUpdateAttributes.Property attribute_property = new WrapperPlayServerUpdateAttributes.Property(scale_attribute, 1.0, Collections.singletonList(attribute_modifier));
            WrapperPlayServerUpdateAttributes attribute_packet = new WrapperPlayServerUpdateAttributes(display_id, Collections.singletonList(attribute_property));
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)attribute_packet);
        }
        WrapperPlayServerDestroyEntities destroy_entity_packet = new WrapperPlayServerDestroyEntities(display_id);
        new ResetGlowingPacketTask(player, (PacketWrapper<?>)destroy_entity_packet, null).runTaskLater((Plugin)module, 160L);
    }

    static void indicate_chest_match(@NotNull Trifles module, @NotNull Player player, @NotNull Container container) {
        int display_id = SpigotReflectionUtil.generateEntityId();
        WrapperPlayServerSpawnEntity display_packet = new WrapperPlayServerSpawnEntity(display_id, UUID.randomUUID(), EntityTypes.SHULKER, SpigotConversionUtil.fromBukkitLocation((Location)container.getLocation()), container.getLocation().getYaw(), 0, null);
        ArrayList<EntityData> display_metadata = new ArrayList<EntityData>();
        display_metadata.add(new EntityData(0, EntityDataTypes.BYTE, (Object)96));
        WrapperPlayServerEntityMetadata display_metadata_packet = new WrapperPlayServerEntityMetadata(display_id, display_metadata);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)display_packet);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)display_metadata_packet);
        Attribute scale_attribute = Attributes.SCALE;
        WrapperPlayServerUpdateAttributes.PropertyModifier attribute_modifier = new WrapperPlayServerUpdateAttributes.PropertyModifier(UUID.randomUUID(), -0.1499999761581421, WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.ADDITION);
        WrapperPlayServerUpdateAttributes.Property attribute_property = new WrapperPlayServerUpdateAttributes.Property(scale_attribute, 1.0, Collections.singletonList(attribute_modifier));
        WrapperPlayServerUpdateAttributes attribute_packet = new WrapperPlayServerUpdateAttributes(display_id, Collections.singletonList(attribute_property));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)attribute_packet);
        WrapperPlayServerDestroyEntities destroy_entity_packet = new WrapperPlayServerDestroyEntities(display_id);
        new ResetGlowingPacketTask(player, (PacketWrapper<?>)destroy_entity_packet, null).runTaskLater((Plugin)module, 160L);
    }

    private static class ResetGlowingPacketTask
    extends BukkitRunnable {
        private final Player player;
        private final PacketWrapper<?> packet;
        private final BukkitTask optional_repeating_packet_task;

        public ResetGlowingPacketTask(@NotNull Player player, @NotNull PacketWrapper<?> packet, @Nullable BukkitTask optional_repeating_packet_task) {
            this.player = player;
            this.packet = packet;
            this.optional_repeating_packet_task = optional_repeating_packet_task;
        }

        public void run() {
            if (!this.player.isOnline()) {
                this.cancel();
            }
            if (this.optional_repeating_packet_task != null && !this.optional_repeating_packet_task.isCancelled()) {
                this.optional_repeating_packet_task.cancel();
            }
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, this.packet);
        }
    }
}

