/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.jetbrains.annotations.Nullable;

public class SingleDoor {
    private final Block lower_block;
    private Door lower;
    private Door upper;

    private SingleDoor(Block lower_block) {
        this.lower_block = lower_block;
        this.lower = SingleDoor.as_door_state(lower_block);
        this.upper = SingleDoor.as_door_state(lower_block.getRelative(BlockFace.UP));
    }

    @Nullable
    public static SingleDoor create_door_from_block(Block originBlock) {
        if (!SingleDoor.validate_single_door(originBlock)) {
            return null;
        }
        return new SingleDoor(SingleDoor.get_lower(originBlock));
    }

    private static Block get_lower(Block originBlock) {
        Bisected.Half half = SingleDoor.as_door_state(originBlock).getHalf();
        return switch (half) {
            default -> throw new MatchException(null, null);
            case Bisected.Half.TOP -> originBlock.getRelative(BlockFace.DOWN);
            case Bisected.Half.BOTTOM -> originBlock;
        };
    }

    private static boolean validate_single_door(Block originBlock) {
        if (!SingleDoor.is_door(originBlock)) {
            return false;
        }
        Block other_half = SingleDoor.other_vertical_half(originBlock);
        if (!SingleDoor.is_door(other_half)) {
            return false;
        }
        return SingleDoor.door_vertical_halves_match(originBlock, other_half);
    }

    private static boolean is_door(Block block) {
        BlockData block_data = block.getBlockData();
        return block_data instanceof Door;
    }

    private static Block other_vertical_half(Block block) {
        Door door = SingleDoor.as_door_state(block);
        return switch (door.getHalf()) {
            default -> throw new MatchException(null, null);
            case Bisected.Half.TOP -> block.getRelative(BlockFace.DOWN);
            case Bisected.Half.BOTTOM -> block.getRelative(BlockFace.UP);
        };
    }

    private static boolean door_vertical_halves_match(Block origin_block, Block other_block) {
        Door originState = SingleDoor.as_door_state(origin_block);
        Bisected.Half expected = SingleDoor.get_opposite(originState.getHalf());
        return SingleDoor.as_door_state(other_block).getHalf() == expected;
    }

    private static Bisected.Half get_opposite(Bisected.Half half) {
        if (half == Bisected.Half.TOP) {
            return Bisected.Half.BOTTOM;
        }
        if (half == Bisected.Half.BOTTOM) {
            return Bisected.Half.TOP;
        }
        throw new IllegalArgumentException("Something has fundamentally changed with Bisected.Half");
    }

    private static Door as_door_state(Block block) {
        return SingleDoor.as_door_state(block.getBlockData());
    }

    private static Door as_door_state(BlockData block_data) {
        if (!(block_data instanceof Door)) {
            return null;
        }
        return (Door)block_data;
    }

    public boolean update_cached_state() {
        BlockData lower_data = this.lower_block.getBlockData();
        this.lower = SingleDoor.as_door_state(lower_data);
        BlockData upper_data = SingleDoor.other_vertical_half(this.lower_block).getBlockData();
        this.upper = SingleDoor.as_door_state(upper_data);
        if (this.lower == null) {
            return false;
        }
        return this.upper != null;
    }

    public void set_open(boolean open) {
        Door data = SingleDoor.as_door_state(this.lower_block);
        data.setOpen(open);
        this.lower_block.setBlockData((BlockData)data);
    }

    public SingleDoor get_second_door() {
        SingleDoor normal_door = this.find_other_door(false);
        SingleDoor hacked_door = this.find_other_door(true);
        return this.priortize(normal_door, hacked_door);
    }

    private SingleDoor priortize(SingleDoor normal_door, SingleDoor hacked_door) {
        if (normal_door == null) {
            return hacked_door;
        }
        if (hacked_door == null) {
            return normal_door;
        }
        if (this.lower.isOpen()) {
            return hacked_door;
        }
        return normal_door;
    }

    @Nullable
    private SingleDoor find_other_door(boolean hacked) {
        BlockFace otherDoorDirection = this.other_door_direction(this.lower, hacked);
        Block potentialOtherDoor = this.lower_block.getRelative(otherDoorDirection);
        Door potential_other_door_state = SingleDoor.as_door_state(potentialOtherDoor);
        if (potential_other_door_state == null) {
            return null;
        }
        if (this.lower_block.getType() != potentialOtherDoor.getType()) {
            return null;
        }
        if (potential_other_door_state.getHalf() != this.lower.getHalf()) {
            return null;
        }
        if (potential_other_door_state.isOpen() != this.lower.isOpen()) {
            return null;
        }
        BlockFace other_pointing = this.other_door_direction(potential_other_door_state, hacked);
        Block should_be_us = potentialOtherDoor.getRelative(other_pointing);
        boolean is_us = should_be_us.getX() == this.lower_block.getX() && should_be_us.getY() == this.lower_block.getY() && should_be_us.getZ() == this.lower_block.getZ();
        return is_us ? SingleDoor.create_door_from_block(potentialOtherDoor) : null;
    }

    private BlockFace other_door_direction(Door our_door, boolean hacked) {
        BlockFace blank_part_when_closed = our_door.getFacing();
        if (hacked) {
            return our_door.getFacing();
        }
        return switch (our_door.getHinge()) {
            default -> throw new MatchException(null, null);
            case Door.Hinge.LEFT -> SingleDoor.rotateCW(blank_part_when_closed);
            case Door.Hinge.RIGHT -> SingleDoor.rotateCCW(blank_part_when_closed);
        };
    }

    private static BlockFace rotateCW(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            default -> throw new IllegalArgumentException("This is a door utility...");
        };
    }

    private static BlockFace rotateCCW(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.EAST -> BlockFace.NORTH;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            default -> throw new IllegalArgumentException("This is a door utility...");
        };
    }

    public boolean isOpen() {
        return this.lower.isOpen();
    }
}

