/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Nameable;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.trifles.items.storage.Backpack;
import org.oddlama.vane.trifles.items.storage.Pouch;
import org.oddlama.vane.util.StorageUtil;

public class StorageGroup
extends Listener<Trifles> {
    public static final NamespacedKey STORAGE_IS_OPEN = StorageUtil.namespaced_key((String)"vane_trifles", (String)"currently_opened_storage");
    private Map<Inventory, Pair<UUID, ItemStack>> open_block_state_inventories = Collections.synchronizedMap(new HashMap());
    @LangMessage
    public TranslatedMessage lang_open_stacked_item;

    public StorageGroup(Context<Trifles> context) {
        super((Context)context.group("storage", "Extensions to storage related stuff will be grouped under here."));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_place_item_in_storage_inventory(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Pair<UUID, ItemStack> owner_and_item = this.open_block_state_inventories.get(event.getInventory());
        if (owner_and_item != null) {
            return;
        }
        if (event.getClick() == ClickType.RIGHT && event.getAction() == InventoryAction.SWAP_WITH_CURSOR && this.is_storage_item(event.getCurrentItem()) && event.getCurrentItem().getAmount() == 1) {
            CustomItem custom_item;
            if (!this.is_storage_item(event.getCursor()) && (custom_item = ((Trifles)this.get_module()).core.item_registry().get(event.getCurrentItem())) != null) {
                event.getCurrentItem().editMeta(BlockStateMeta.class, meta -> {
                    BlockState block_state = meta.getBlockState();
                    if (block_state instanceof Container) {
                        Container container = (Container)block_state;
                        HashMap leftovers = container.getInventory().addItem(new ItemStack[]{event.getCursor()});
                        if (leftovers.size() == 0) {
                            event.setCursor(null);
                        } else {
                            event.setCursor((ItemStack)leftovers.get(0));
                        }
                        meta.setBlockState(block_state);
                    }
                });
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_inventory_click(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Pair<UUID, ItemStack> owner_and_item = this.open_block_state_inventories.get(event.getInventory());
        if (owner_and_item == null || !((UUID)owner_and_item.getLeft()).equals(player.getUniqueId())) {
            return;
        }
        boolean clicked_item_is_storage = this.is_storage_item(event.getCurrentItem());
        boolean cursor_item_is_storage = this.is_storage_item(event.getCursor());
        boolean clicked_inventory_is_player_inventory = event.getClickedInventory() == player.getInventory();
        boolean cancel = false;
        switch (event.getAction()) {
            case DROP_ALL_CURSOR: 
            case DROP_ALL_SLOT: 
            case DROP_ONE_CURSOR: 
            case DROP_ONE_SLOT: {
                cancel = false;
                break;
            }
            case PLACE_ALL: 
            case PLACE_ONE: 
            case PLACE_SOME: 
            case SWAP_WITH_CURSOR: {
                cancel = cursor_item_is_storage && !clicked_inventory_is_player_inventory;
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                cancel = clicked_item_is_storage && clicked_inventory_is_player_inventory;
                break;
            }
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_ONE: 
            case PICKUP_SOME: {
                cancel = false;
                break;
            }
            default: {
                cancel = clicked_item_is_storage || cursor_item_is_storage;
            }
        }
        switch (event.getClick()) {
            case NUMBER_KEY: {
                boolean swapped_item_is_storage = this.is_storage_item(player.getInventory().getItem(event.getHotbarButton()));
                boolean bl = cancel = (swapped_item_is_storage || clicked_item_is_storage) && !clicked_inventory_is_player_inventory;
            }
        }
        if (cancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_drop_item(PlayerDropItemEvent event) {
        if (!this.is_storage_item(event.getItemDrop().getItemStack())) {
            return;
        }
        boolean storage_item_is_open_state = this.is_currently_open(event.getItemDrop().getItemStack());
        if (storage_item_is_open_state) {
            boolean is_known_custom_inventory = this.open_block_state_inventories.containsKey(event.getPlayer().getOpenInventory().getTopInventory());
            if (is_known_custom_inventory) {
                event.getPlayer().closeInventory(InventoryCloseEvent.Reason.CANT_USE);
            } else {
                event.getItemDrop().getItemStack().editMeta(meta -> meta.getPersistentDataContainer().set(STORAGE_IS_OPEN, PersistentDataType.BOOLEAN, (Object)false));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_pickup_item(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.is_storage_item(event.getItem().getItemStack())) {
            return;
        }
        event.getItem().getItemStack().editMeta(meta -> meta.getPersistentDataContainer().set(STORAGE_IS_OPEN, PersistentDataType.BOOLEAN, (Object)false));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_inventory_drag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Pair<UUID, ItemStack> owner_and_item = this.open_block_state_inventories.get(event.getInventory());
        if (owner_and_item == null || !((UUID)owner_and_item.getLeft()).equals(player.getUniqueId())) {
            return;
        }
        for (ItemStack item_stack : event.getNewItems().values()) {
            if (!this.is_storage_item(item_stack)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void save_after_click(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Pair<UUID, ItemStack> owner_and_item = this.open_block_state_inventories.get(event.getInventory());
        if (owner_and_item == null || !((UUID)owner_and_item.getLeft()).equals(player.getUniqueId())) {
            return;
        }
        this.update_storage_item((ItemStack)owner_and_item.getRight(), event.getInventory());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void save_after_drag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Pair<UUID, ItemStack> owner_and_item = this.open_block_state_inventories.get(event.getInventory());
        if (owner_and_item == null || !((UUID)owner_and_item.getLeft()).equals(player.getUniqueId())) {
            return;
        }
        this.update_storage_item((ItemStack)owner_and_item.getRight(), event.getInventory());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void save_after_close(InventoryCloseEvent event) {
        Pair<UUID, ItemStack> owner_and_item = this.open_block_state_inventories.get(event.getInventory());
        if (owner_and_item == null || !((UUID)owner_and_item.getLeft()).equals(event.getPlayer().getUniqueId())) {
            return;
        }
        ((ItemStack)owner_and_item.getRight()).editMeta(meta -> meta.getPersistentDataContainer().set(STORAGE_IS_OPEN, PersistentDataType.BOOLEAN, (Object)false));
        this.update_storage_item((ItemStack)owner_and_item.getRight(), event.getInventory());
        this.open_block_state_inventories.remove(event.getInventory());
    }

    private boolean is_storage_item(@Nullable ItemStack item) {
        BlockStateMeta meta;
        if (item == null) {
            return false;
        }
        CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (custom_item != null && (custom_item instanceof Backpack || custom_item instanceof Pouch)) {
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta instanceof BlockStateMeta && (meta = (BlockStateMeta)itemMeta).getBlockState() instanceof ShulkerBox;
    }

    private boolean is_currently_open(@Nullable ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return Boolean.TRUE.equals(item.getPersistentDataContainer().get(STORAGE_IS_OPEN, PersistentDataType.BOOLEAN));
    }

    private void update_storage_item(@NotNull ItemStack item, @NotNull Inventory inventory) {
        ItemStack[] itemStackArray;
        if (item.getType().isAir() && (itemStackArray = inventory.getHolder()) instanceof Player) {
            Player player = (Player)itemStackArray;
            for (ItemStack checked_item : player.getInventory().getContents()) {
                if (checked_item == null || !checked_item.hasItemMeta() || !this.is_currently_open(checked_item)) continue;
                item = checked_item;
                this.open_block_state_inventories.put(inventory, (Pair<UUID, ItemStack>)Pair.of((Object)player.getUniqueId(), (Object)item));
                break;
            }
        }
        item.editMeta(BlockStateMeta.class, meta -> {
            BlockState block_state = meta.getBlockState();
            if (block_state instanceof Container) {
                Container container = (Container)block_state;
                container.getInventory().setContents(inventory.getContents());
                meta.setBlockState(block_state);
            }
        });
    }

    public boolean open_block_state_inventory(@NotNull Player player, @NotNull ItemStack item) {
        BlockStateMeta meta;
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta) || !((itemMeta = (meta = (BlockStateMeta)itemMeta).getBlockState()) instanceof Container)) {
            return false;
        }
        Container container = (Container)itemMeta;
        if (item.getAmount() != 1) {
            ((Trifles)this.get_module()).storage_group.lang_open_stacked_item.send_action_bar((CommandSender)player, new Object[0]);
            return false;
        }
        TextComponent name = Component.text((String)"");
        BlockState blockState = meta.getBlockState();
        if (blockState instanceof Nameable) {
            Nameable nameable = (Nameable)blockState;
            Object object = meta.hasDisplayName() ? meta.displayName() : (name = meta.hasItemName() ? meta.itemName() : null);
            if (name == null) {
                CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
                name = custom_item != null ? custom_item.displayName() : Component.text((String)"");
            }
            nameable.customName((Component)name);
        }
        Inventory transient_inventory = ((Trifles)this.get_module()).getServer().createInventory((InventoryHolder)player, container.getInventory().getType(), (Component)name);
        transient_inventory.setContents(container.getInventory().getContents());
        this.open_block_state_inventories.put(transient_inventory, (Pair<UUID, ItemStack>)Pair.of((Object)player.getUniqueId(), (Object)item));
        player.openInventory(transient_inventory);
        return true;
    }
}

