/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.Serializable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionDefault;
import org.oddlama.vane.annotation.command.Name;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigMaterial;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.PlayerUtil;

@Name(value="heads")
public class Heads
extends Command<Trifles> {
    @ConfigMaterial(def=Material.BONE, desc="Currency material used to buy heads.")
    public Material config_currency;
    @ConfigInt(def=1, min=0, desc="Price (in currency) per head. Set to 0 for free heads.")
    public int config_price_per_head;

    public Heads(Context<Trifles> context) {
        super(context, PermissionDefault.TRUE);
    }

    public LiteralArgumentBuilder<CommandSourceStack> get_command_base() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)super.get_command_base().requires(ctx -> ctx.getSender() instanceof Player)).then((ArgumentBuilder)this.help())).executes(ctx -> {
            this.open_head_library((Player)((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        });
    }

    private void open_head_library(Player player) {
        MenuFactory.head_selector((Context)this.get_context(), (Player)player, (Function4 & Serializable)(player2, m, t, event) -> {
            int amount;
            switch (event.getClick()) {
                default: {
                    return Menu.ClickResult.INVALID_CLICK;
                }
                case NUMBER_KEY: {
                    amount = event.getHotbarButton() + 1;
                    break;
                }
                case LEFT: {
                    amount = 1;
                    break;
                }
                case RIGHT: {
                    amount = 32;
                    break;
                }
                case MIDDLE: 
                case SHIFT_LEFT: {
                    amount = 64;
                    break;
                }
                case SHIFT_RIGHT: {
                    amount = 16;
                }
            }
            if (this.config_price_per_head > 0 && !PlayerUtil.take_items((Player)player2, (ItemStack)new ItemStack(this.config_currency, this.config_price_per_head * amount))) {
                return Menu.ClickResult.ERROR;
            }
            PlayerUtil.give_items((Player)player2, (ItemStack)t.item(), (int)amount);
            return Menu.ClickResult.SUCCESS;
        }, (Consumer1 & Serializable)player2 -> {}).open(player);
    }
}

