/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.trifles.items.Scroll;
import org.oddlama.vane.util.StorageUtil;

@VaneItem(name="death_scroll", base=Material.WARPED_FUNGUS_ON_A_STICK, durability=2, model_data=7733266, version=1)
public class DeathScroll
extends Scroll {
    public static final NamespacedKey RECENT_DEATH_LOCATION = StorageUtil.namespaced_key((String)"vane", (String)"recent_death_location");
    public static final NamespacedKey RECENT_DEATH_TIME = StorageUtil.namespaced_key((String)"vane", (String)"recent_death_time");
    @LangMessage
    public TranslatedMessage lang_teleport_no_recent_death;

    public DeathScroll(Context<Trifles> context) {
        super(context, 6000);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"aba", "epe"}).set_ingredient('p', "vane_trifles:papyrus_scroll").set_ingredient('e', Material.ENDER_PEARL).set_ingredient('a', Material.BONE).set_ingredient('b', Material.RECOVERY_COMPASS).result(this.key().toString())});
    }

    @Override
    public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        EnumSet<InhibitBehavior> set = super.inhibitedBehaviors();
        set.add(InhibitBehavior.NEW_ENCHANTS);
        return set;
    }

    @Override
    public Location teleport_location(ItemStack scroll, Player player, boolean imminent_teleport) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        Long time = (Long)pdc.getOrDefault(RECENT_DEATH_TIME, PersistentDataType.LONG, (Object)0L);
        Location loc = StorageUtil.storage_get_location((PersistentDataContainer)player.getPersistentDataContainer(), (NamespacedKey)RECENT_DEATH_LOCATION, null);
        if (System.currentTimeMillis() - time > 1200000L) {
            loc = null;
        }
        if (imminent_teleport) {
            if (loc == null) {
                this.lang_teleport_no_recent_death.send_action_bar((CommandSender)player, new Object[0]);
            } else {
                pdc.remove(RECENT_DEATH_TIME);
                StorageUtil.storage_remove_location((PersistentDataContainer)pdc, (NamespacedKey)RECENT_DEATH_LOCATION);
            }
        }
        return loc;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_death(PlayerDeathEvent event) {
        PersistentDataContainer pdc = event.getPlayer().getPersistentDataContainer();
        StorageUtil.storage_set_location((PersistentDataContainer)pdc, (NamespacedKey)RECENT_DEATH_LOCATION, (Location)event.getPlayer().getLocation());
        pdc.set(RECENT_DEATH_TIME, PersistentDataType.LONG, (Object)System.currentTimeMillis());
        event.getPlayer().setCooldown(this.baseMaterial(), 0);
    }
}

