/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.EnumSet;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapelessRecipeDefinition;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.trifles.items.XpBottles;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.PlayerUtil;

@VaneItem(name="empty_xp_bottle", base=Material.GLASS_BOTTLE, model_data=7733258, version=1)
public class EmptyXpBottle
extends CustomItem<Trifles> {
    @ConfigDouble(def=0.3, min=0.0, max=0.999, desc="Percentage of experience lost when bottling. For 10% loss, bottling 30 levels will require 30 * (1 / (1 - 0.1)) = 33.33 levels")
    public double config_loss_percentage;

    public EmptyXpBottle(Context<Trifles> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapelessRecipeDefinition("generic").add_ingredient(Material.EXPERIENCE_BOTTLE).add_ingredient(Material.GLASS_BOTTLE).add_ingredient(Material.GOLD_NUGGET).result(this.key().toString())});
    }

    public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE, InhibitBehavior.TEMPT, InhibitBehavior.USE_OFFHAND);
    }

    public static int get_total_exp(Player player) {
        return EmptyXpBottle.level_to_exp(player.getLevel()) + Math.round((float)player.getExpToLevel() * player.getExp());
    }

    public static int level_to_exp(int level) {
        if (level > 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void on_player_right_click(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        if (!this.isInstance(item)) {
            return;
        }
        event.setUseItemInHand(Event.Result.DENY);
        switch (event.getAction()) {
            default: {
                return;
            }
            case RIGHT_CLICK_AIR: {
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                if (event.useInteractedBlock() == Event.Result.DENY) break;
                return;
            }
        }
        long now = System.currentTimeMillis();
        Long last_consume = ((Trifles)this.get_module()).last_xp_bottle_consume_time.getOrDefault(player.getUniqueId(), 0L);
        if (now - last_consume < 1000L) {
            return;
        }
        XpBottles.XpBottle xp_bottle = null;
        int exp = 0;
        for (XpBottles.XpBottle bottle : ((Trifles)this.get_module()).xp_bottles.bottles) {
            int cur_exp = (int)(1.0 / (1.0 - this.config_loss_percentage) * (double)Conversions.exp_for_level((int)bottle.config_capacity));
            if (EmptyXpBottle.get_total_exp(player) < cur_exp || cur_exp <= exp) continue;
            exp = cur_exp;
            xp_bottle = bottle;
        }
        if (xp_bottle == null) {
            return;
        }
        player.giveExp(-exp, false);
        PlayerUtil.remove_one_item_from_hand((Player)player, (EquipmentSlot)event.getHand());
        PlayerUtil.give_item((Player)player, (ItemStack)xp_bottle.newStack());
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, SoundCategory.PLAYERS, 1.0f, 4.0f);
        PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
    }
}

