/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.Fence;
import org.bukkit.block.data.type.GlassPane;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.block.data.type.Wall;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.BlockUtil;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.PlayerUtil;

@VaneItem(name="file", base=Material.WARPED_FUNGUS_ON_A_STICK, durability=4000, model_data=7733251, version=1)
public class File
extends CustomItem<Trifles> {
    public File(Context<Trifles> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" m", "s "}).set_ingredient('m', Material.IRON_INGOT).set_ingredient('s', Material.STICK).result(this.key().toString())});
    }

    public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE, InhibitBehavior.TEMPT, InhibitBehavior.USE_OFFHAND);
    }

    private BlockFace next_facing(Set<BlockFace> allowed_faces, BlockFace face) {
        if (allowed_faces.isEmpty()) {
            return face;
        }
        ArrayList<BlockFace> list = new ArrayList<BlockFace>(allowed_faces);
        Collections.sort(list, (a, b) -> a.ordinal() - b.ordinal());
        int index = list.indexOf(face);
        if (index == -1) {
            return face;
        }
        return list.get((index + 1) % list.size());
    }

    private Sound change_stair_half(Stairs stairs) {
        stairs.setHalf(stairs.getHalf() == Bisected.Half.BOTTOM ? Bisected.Half.TOP : Bisected.Half.BOTTOM);
        return Sound.UI_STONECUTTER_TAKE_RESULT;
    }

    private BlockFace next_face_ccw(BlockFace face) {
        switch (face) {
            default: {
                return null;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: 
        }
        return BlockFace.SOUTH;
    }

    private Sound change_stair_shape(Player player, Block block, Stairs stairs, BlockFace clicked_face) {
        boolean is_stair_top;
        BlockUtil.Oct oct = BlockUtil.raytrace_oct((LivingEntity)player, (Block)block);
        if (oct == null) {
            return null;
        }
        BlockUtil.Corner corner = oct.corner();
        boolean bl = is_stair_top = stairs.getHalf() == Bisected.Half.TOP;
        if (corner.up() == is_stair_top) {
            corner = corner.up(!corner.up());
        }
        BlockFace original_facing = stairs.getFacing();
        corner = corner.rotate_to_north_reference(original_facing);
        Stairs.Shape shape = null;
        BlockFace face = null;
        boolean added = false;
        block0 : switch (stairs.getShape()) {
            case STRAIGHT: {
                switch (corner.xz_face()) {
                    case SOUTH_WEST: {
                        shape = Stairs.Shape.INNER_LEFT;
                        face = BlockFace.NORTH;
                        added = true;
                        break block0;
                    }
                    case NORTH_WEST: {
                        shape = Stairs.Shape.OUTER_RIGHT;
                        face = BlockFace.NORTH;
                        added = false;
                        break block0;
                    }
                    case NORTH_EAST: {
                        shape = Stairs.Shape.OUTER_LEFT;
                        face = BlockFace.NORTH;
                        added = false;
                        break block0;
                    }
                    case SOUTH_EAST: {
                        shape = Stairs.Shape.INNER_RIGHT;
                        face = BlockFace.NORTH;
                        added = true;
                        break block0;
                    }
                }
                break;
            }
            case INNER_LEFT: {
                switch (corner.xz_face()) {
                    case SOUTH_WEST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.NORTH;
                        added = false;
                        break block0;
                    }
                    case NORTH_EAST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.WEST;
                        added = false;
                        break block0;
                    }
                }
                break;
            }
            case INNER_RIGHT: {
                switch (corner.xz_face()) {
                    case NORTH_WEST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.EAST;
                        added = false;
                        break block0;
                    }
                    case SOUTH_EAST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.NORTH;
                        added = false;
                        break block0;
                    }
                }
                break;
            }
            case OUTER_LEFT: {
                switch (corner.xz_face()) {
                    case SOUTH_WEST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.WEST;
                        added = true;
                        break block0;
                    }
                    case NORTH_EAST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.NORTH;
                        added = true;
                        break block0;
                    }
                }
                break;
            }
            case OUTER_RIGHT: {
                switch (corner.xz_face()) {
                    case NORTH_WEST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.NORTH;
                        added = true;
                        break block0;
                    }
                    case SOUTH_EAST: {
                        shape = Stairs.Shape.STRAIGHT;
                        face = BlockFace.EAST;
                        added = true;
                        break block0;
                    }
                }
            }
        }
        if (shape == null) {
            return null;
        }
        switch (face) {
            case NORTH: {
                face = original_facing;
                break;
            }
            case EAST: {
                face = this.next_face_ccw(original_facing).getOppositeFace();
                break;
            }
            case SOUTH: {
                face = original_facing.getOppositeFace();
                break;
            }
            case WEST: {
                face = this.next_face_ccw(original_facing);
                break;
            }
        }
        stairs.setShape(shape);
        stairs.setFacing(face);
        return added ? Sound.UI_STONECUTTER_TAKE_RESULT : Sound.BLOCK_GRINDSTONE_USE;
    }

    private Sound change_multiple_facing(Player player, Block block, MultipleFacing mf, BlockFace clicked_face) {
        int min_faces;
        if (mf instanceof Fence || mf instanceof GlassPane) {
            min_faces = 0;
            BlockUtil.RaytraceDominantFaceResult result = BlockUtil.raytrace_dominant_face((LivingEntity)player, (Block)block);
            if (result == null) {
                return null;
            }
            if (result.dominance > 0.2 || clicked_face != BlockFace.UP && clicked_face != BlockFace.DOWN) {
                clicked_face = result.face;
            }
        } else if (mf instanceof Tripwire) {
            min_faces = 0;
        } else {
            return null;
        }
        if (!mf.getAllowedFaces().contains(clicked_face)) {
            return null;
        }
        boolean has_face = mf.hasFace(clicked_face);
        if (has_face && min_faces >= mf.getFaces().size()) {
            return null;
        }
        mf.setFace(clicked_face, !has_face);
        return has_face ? Sound.BLOCK_GRINDSTONE_USE : Sound.UI_STONECUTTER_TAKE_RESULT;
    }

    private Sound change_wall(Player player, Block block, Wall wall, BlockFace clicked_face) {
        boolean has_face;
        BlockUtil.RaytraceDominantFaceResult result = BlockUtil.raytrace_dominant_face((LivingEntity)player, (Block)block);
        if (result == null) {
            return null;
        }
        BlockFace adjusted_clicked_face = result.dominance > 0.2 || clicked_face != BlockFace.UP && clicked_face != BlockFace.DOWN ? result.face : clicked_face;
        if (clicked_face == BlockFace.UP) {
            boolean was_up = wall.isUp();
            if (adjusted_clicked_face == BlockFace.UP) {
                wall.setUp(!was_up);
            } else if (BlockUtil.XZ_FACES.contains(adjusted_clicked_face)) {
                Wall.Height height = wall.getHeight(adjusted_clicked_face);
                switch (height) {
                    case NONE: {
                        return null;
                    }
                    case LOW: {
                        wall.setHeight(adjusted_clicked_face, Wall.Height.TALL);
                        break;
                    }
                    case TALL: {
                        wall.setHeight(adjusted_clicked_face, Wall.Height.LOW);
                    }
                }
            }
            return was_up ? Sound.BLOCK_GRINDSTONE_USE : Sound.UI_STONECUTTER_TAKE_RESULT;
        }
        boolean bl = has_face = wall.getHeight(adjusted_clicked_face) != Wall.Height.NONE;
        if (has_face) {
            wall.setHeight(adjusted_clicked_face, Wall.Height.NONE);
            return Sound.BLOCK_GRINDSTONE_USE;
        }
        Wall.Height target_height = wall.getHeight(adjusted_clicked_face.getOppositeFace());
        if (target_height == Wall.Height.NONE) {
            target_height = Wall.Height.LOW;
        }
        wall.setHeight(adjusted_clicked_face, target_height);
        return Sound.UI_STONECUTTER_TAKE_RESULT;
    }

    private Sound change_directional_facing(Player player, Block block, Directional directional, BlockFace clicked_face) {
        directional.setFacing(this.next_facing(directional.getFaces(), directional.getFacing()));
        return Sound.UI_STONECUTTER_TAKE_RESULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_right_click(PlayerInteractEvent event) {
        Sound sound;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        if (!this.isInstance(item)) {
            return;
        }
        Block block = event.getClickedBlock();
        BlockBreakEvent break_event = new BlockBreakEvent(block, player);
        ((Trifles)this.get_module()).getServer().getPluginManager().callEvent((Event)break_event);
        if (break_event.isCancelled()) {
            return;
        }
        BlockData data = block.getBlockData();
        BlockFace clicked_face = event.getBlockFace();
        if (player.isSneaking()) {
            if (!(data instanceof Stairs)) return;
            sound = this.change_stair_half((Stairs)data);
        } else if (data instanceof MultipleFacing) {
            sound = this.change_multiple_facing(player, block, (MultipleFacing)data, clicked_face);
        } else if (data instanceof Wall) {
            sound = this.change_wall(player, block, (Wall)data, clicked_face);
        } else {
            if (!(data instanceof Stairs)) return;
            sound = this.change_stair_shape(player, block, (Stairs)data, clicked_face);
        }
        if (sound == null) {
            return;
        }
        block.setBlockData(data, false);
        block.getWorld().playSound(block.getLocation(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        ItemUtil.damage_item((Player)player, (ItemStack)item, (int)1);
        PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
    }
}

