/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.List;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.trifles.items.Scroll;
import org.oddlama.vane.util.PlayerUtil;
import org.oddlama.vane.util.StorageUtil;

@VaneItem(name="lodestone_scroll", base=Material.WARPED_FUNGUS_ON_A_STICK, durability=15, model_data=7733265, version=1)
public class LodestoneScroll
extends Scroll {
    public static final NamespacedKey LODESTONE_LOCATION = StorageUtil.namespaced_key((String)"vane", (String)"lodestone_location");
    @LangMessage
    public TranslatedMessage lang_teleport_no_bound_lodestone;
    @LangMessage
    public TranslatedMessage lang_teleport_missing_lodestone;
    @LangMessage
    public TranslatedMessage lang_bound_lore;

    public LodestoneScroll(Context<Trifles> context) {
        super(context, 6000);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"aba", "epe"}).set_ingredient('p', "vane_trifles:papyrus_scroll").set_ingredient('e', Material.ENDER_PEARL).set_ingredient('a', Material.AMETHYST_SHARD).set_ingredient('b', Material.NETHERITE_INGOT).result(this.key().toString())});
    }

    private Location get_lodestone_location(ItemStack scroll) {
        if (!scroll.hasItemMeta()) {
            return null;
        }
        return StorageUtil.storage_get_location((PersistentDataContainer)scroll.getItemMeta().getPersistentDataContainer(), (NamespacedKey)LODESTONE_LOCATION, null);
    }

    @Override
    public Location teleport_location(ItemStack scroll, Player player, boolean imminent_teleport) {
        Block lodestone;
        if (player.isSneaking()) {
            return null;
        }
        Location lodestone_location = this.get_lodestone_location(scroll);
        Block block = lodestone = lodestone_location == null ? null : lodestone_location.getBlock();
        if (imminent_teleport) {
            if (lodestone_location == null) {
                this.lang_teleport_no_bound_lodestone.send_action_bar((CommandSender)player, new Object[0]);
            } else if (lodestone.getType() != Material.LODESTONE) {
                this.lang_teleport_missing_lodestone.send_action_bar((CommandSender)player, new Object[0]);
                lodestone = null;
            }
        }
        return lodestone == null ? null : lodestone.getLocation().add(0.5, 1.005, 0.5);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_interact(PlayerInteractEvent event) {
        LodestoneScroll scroll;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK || event.useItemInHand() == Event.Result.ALLOW) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.getType() != Material.LODESTONE) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        ItemStack item = player.getEquipment().getItem(EquipmentSlot.HAND);
        CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof LodestoneScroll) || !(scroll = (LodestoneScroll)custom_item).enabled()) {
            return;
        }
        item.editMeta(meta -> {
            StorageUtil.storage_set_location((PersistentDataContainer)meta.getPersistentDataContainer(), (NamespacedKey)LODESTONE_LOCATION, (Location)block.getLocation().add(0.5, 0.5, 0.5));
            meta.lore(List.of(this.lang_bound_lore.format(new Object[]{"\u00a7a" + block.getWorld().getName(), "\u00a7b" + block.getX(), "\u00a7b" + block.getY(), "\u00a7b" + block.getZ()}).decoration(TextDecoration.ITALIC, false)));
        });
        PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        block.getWorld().spawnParticle(Particle.ENCHANT, block.getLocation().add(0.5, 2.0, 0.5), 100, 0.1, 0.3, 0.1, 2.0);
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_CHARGE, SoundCategory.BLOCKS, 1.0f, 3.0f);
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
    }
}

