/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.EnumSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;

@VaneItem(name="north_compass", base=Material.COMPASS, model_data=7733267, version=1)
public class NorthCompass
extends org.oddlama.vane.core.item.CustomItem<Trifles> {
    public NorthCompass(Context<Trifles> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" m ", "mrm", " m "}).set_ingredient('m', Material.COPPER_INGOT).set_ingredient('r', Material.REDSTONE).result(this.key().toString())});
    }

    public ItemStack updateItemStack(ItemStack item_stack) {
        World world;
        List worlds = ((Trifles)this.get_module()).getServer().getWorlds();
        if (worlds.size() > 0 && (world = (World)worlds.get(0)) != null) {
            item_stack.editMeta(CompassMeta.class, meta -> {
                meta.setLodestone(new Location(world, 0.0, 0.0, -3.0E8));
                meta.setLodestoneTracked(false);
            });
        }
        return item_stack;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_player_click_inventory(InventoryClickEvent event) {
        NorthCompass north_compass;
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() != Material.COMPASS) {
            return;
        }
        CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof NorthCompass) || !(north_compass = (NorthCompass)custom_item).enabled()) {
            return;
        }
        item.editMeta(CompassMeta.class, meta -> {
            if (!meta.hasLodestone()) {
                meta.setLodestoneTracked(false);
                meta.setLodestone(new Location(event.getWhoClicked().getWorld(), 0.0, 0.0, -3.0E8));
            }
        });
    }

    public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE, InhibitBehavior.USE_OFFHAND);
    }
}

