/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.trifles.event.PlayerTeleportScrollEvent;
import org.oddlama.vane.trifles.items.DeathScroll;
import org.oddlama.vane.trifles.items.HomeScroll;
import org.oddlama.vane.trifles.items.LodestoneScroll;
import org.oddlama.vane.trifles.items.Scroll;
import org.oddlama.vane.trifles.items.SpawnScroll;
import org.oddlama.vane.trifles.items.UnstableScroll;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.PlayerUtil;

public class Scrolls
extends Listener<Trifles> {
    private Set<Scroll> scrolls = new HashSet<Scroll>();
    private Set<Material> base_materials = new HashSet<Material>();
    @ConfigInt(def=15000, min=0, desc="A cooldown in milliseconds that is applied when the player takes damage (prevents combat logging). Set to 0 to allow combat logging.")
    private int config_damage_cooldown;

    public Scrolls(Context<Trifles> context) {
        super((Context)context.group("scrolls", "Several scrolls that allow player teleportation, and related behavior."));
        this.scrolls.add(new HomeScroll((Context<Trifles>)this.get_context()));
        this.scrolls.add(new UnstableScroll((Context<Trifles>)this.get_context()));
        this.scrolls.add(new SpawnScroll((Context<Trifles>)this.get_context()));
        this.scrolls.add(new LodestoneScroll((Context<Trifles>)this.get_context()));
        this.scrolls.add(new DeathScroll((Context<Trifles>)this.get_context()));
        for (Scroll scroll : this.scrolls) {
            this.base_materials.add(scroll.baseMaterial());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void on_player_right_click(PlayerInteractEvent event) {
        Scroll scroll;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof Scroll) || !(scroll = (Scroll)custom_item).enabled()) {
            return;
        }
        event.setUseItemInHand(Event.Result.DENY);
        switch (event.getAction()) {
            default: {
                return;
            }
            case RIGHT_CLICK_AIR: {
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                if (event.useInteractedBlock() == Event.Result.DENY) break;
                Block block = event.getClickedBlock();
                if (block.getType().isInteractable()) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        Location to_location = scroll.teleport_location(item, player, true);
        if (to_location == null) {
            return;
        }
        if (player.getCooldown(scroll.baseMaterial()) > 0) {
            return;
        }
        Location current_location = player.getLocation();
        if (this.teleport_from_scroll(player, current_location, to_location)) {
            this.cooldown_all(player, scroll.config_cooldown);
            ItemUtil.damage_item((Player)player, (ItemStack)item, (int)1);
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        }
    }

    public boolean teleport_from_scroll(Player player, Location from, Location to) {
        PlayerTeleportScrollEvent teleport_scroll_event = new PlayerTeleportScrollEvent(player, from, to);
        ((Trifles)this.get_module()).getServer().getPluginManager().callEvent((Event)teleport_scroll_event);
        if (teleport_scroll_event.isCancelled()) {
            return false;
        }
        player.teleport(to, PlayerTeleportEvent.TeleportCause.PLUGIN);
        from.getWorld().playSound(from, Sound.ITEM_CHORUS_FRUIT_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.1f);
        to.getWorld().playSound(to, Sound.ITEM_CHORUS_FRUIT_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.1f);
        from.getWorld().playSound(from, Sound.BLOCK_END_PORTAL_FRAME_FILL, SoundCategory.PLAYERS, 1.0f, 1.0f);
        to.getWorld().playSound(to, Sound.BLOCK_END_PORTAL_FRAME_FILL, SoundCategory.PLAYERS, 1.0f, 1.0f);
        from.getWorld().spawnParticle(Particle.PORTAL, from.clone().add(0.0, 1.0, 0.0), 200, 1.0, 2.0, 1.0, 1.0);
        to.getWorld().spawnParticle(Particle.END_ROD, to.clone().add(0.0, 1.0, 0.0), 100, 1.0, 2.0, 1.0, 1.0);
        return true;
    }

    public void cooldown_all(Player player, int cooldown_ms) {
        int cooldown_ticks = (int)Conversions.ms_to_ticks((long)cooldown_ms);
        for (Material mat : this.base_materials) {
            if (player.getCooldown(mat) >= cooldown_ticks) continue;
            player.setCooldown(mat, cooldown_ticks);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_take_damage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.cooldown_all(player, this.config_damage_cooldown);
        }
    }
}

