/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.config.recipes.SmithingRecipeDefinition;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.trifles.items.Sickle;
import org.oddlama.vane.util.BlockUtil;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.PlayerUtil;

public class Sickles
extends Listener<Trifles> {
    public Sickles(Context<Trifles> context) {
        super((Context)context.group("sickles", "Several sickles that allow players to harvest crops in a radius."));
        new WoodenSickle((Context<Trifles>)this.get_context());
        new StoneSickle((Context<Trifles>)this.get_context());
        new IronSickle((Context<Trifles>)this.get_context());
        new GoldenSickle((Context<Trifles>)this.get_context());
        new DiamondSickle((Context<Trifles>)this.get_context());
        new NetheriteSickle((Context<Trifles>)this.get_context());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_right_click_plant(PlayerInteractEvent event) {
        Sickle sickle;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        Block root_block = event.getClickedBlock();
        Material plant_type = root_block.getType();
        if (!MaterialUtil.is_seeded_plant((Material)plant_type)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof Sickle) || !(sickle = (Sickle)custom_item).enabled()) {
            return;
        }
        int total_harvested = 0;
        for (BlockVector relative_pos : (List)BlockUtil.NEAREST_RELATIVE_BLOCKS_FOR_RADIUS.get(sickle.config_harvest_radius)) {
            Block block = BlockUtil.relative((Block)root_block, (Vector)relative_pos);
            if (!PlayerUtil.harvest_plant((Player)player, (Block)block)) continue;
            ++total_harvested;
        }
        if (total_harvested > 0) {
            ItemUtil.damage_item((Player)player, (ItemStack)item, (int)(1 + (int)(0.25 * (double)total_harvested)));
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
            root_block.getWorld().playSound(root_block.getLocation(), Sound.ITEM_HOE_TILL, SoundCategory.BLOCKS, 1.0f, 2.0f);
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
    }

    @VaneItem(name="wooden_sickle", base=Material.WOODEN_HOE, model_data=7733252, version=1)
    public static class WoodenSickle
    extends Sickle {
        public WoodenSickle(Context<Trifles> context) {
            super(context);
        }

        public double config_attack_damage_def() {
            return 1.0;
        }

        public double config_attack_speed_def() {
            return 1.0;
        }

        public int config_harvest_radius_def() {
            return 1;
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" mm", "  m", " s "}).set_ingredient('m', Tag.PLANKS).set_ingredient('s', Material.STICK).result(this.key().toString())});
        }
    }

    @VaneItem(name="stone_sickle", base=Material.STONE_HOE, model_data=7733253, version=1)
    public static class StoneSickle
    extends Sickle {
        public StoneSickle(Context<Trifles> context) {
            super(context);
        }

        public double config_attack_damage_def() {
            return 1.5;
        }

        public double config_attack_speed_def() {
            return 1.5;
        }

        public int config_harvest_radius_def() {
            return 1;
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" mm", "  m", " s "}).set_ingredient('m', Tag.ITEMS_STONE_TOOL_MATERIALS).set_ingredient('s', Material.STICK).result(this.key().toString())});
        }
    }

    @VaneItem(name="iron_sickle", base=Material.IRON_HOE, model_data=0x760006, version=1)
    public static class IronSickle
    extends Sickle {
        public IronSickle(Context<Trifles> context) {
            super(context);
        }

        public double config_attack_damage_def() {
            return 2.0;
        }

        public double config_attack_speed_def() {
            return 2.0;
        }

        public int config_harvest_radius_def() {
            return 2;
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" mm", "  m", " s "}).set_ingredient('m', Material.IRON_INGOT).set_ingredient('s', Material.STICK).result(this.key().toString())});
        }
    }

    @VaneItem(name="golden_sickle", base=Material.GOLDEN_HOE, model_data=0x760007, version=1)
    public static class GoldenSickle
    extends Sickle {
        public GoldenSickle(Context<Trifles> context) {
            super(context);
        }

        public double config_attack_damage_def() {
            return 1.5;
        }

        public double config_attack_speed_def() {
            return 3.5;
        }

        public int config_harvest_radius_def() {
            return 3;
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" mm", "  m", " s "}).set_ingredient('m', Material.GOLD_INGOT).set_ingredient('s', Material.STICK).result(this.key().toString())});
        }
    }

    @VaneItem(name="diamond_sickle", base=Material.DIAMOND_HOE, model_data=7733256, version=1)
    public static class DiamondSickle
    extends Sickle {
        public DiamondSickle(Context<Trifles> context) {
            super(context);
        }

        public double config_attack_damage_def() {
            return 2.5;
        }

        public double config_attack_speed_def() {
            return 2.5;
        }

        public int config_harvest_radius_def() {
            return 2;
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" mm", "  m", " s "}).set_ingredient('m', Material.DIAMOND).set_ingredient('s', Material.STICK).result(this.key().toString())});
        }
    }

    @VaneItem(name="netherite_sickle", base=Material.NETHERITE_HOE, model_data=7733257, version=1)
    public static class NetheriteSickle
    extends Sickle {
        public NetheriteSickle(Context<Trifles> context) {
            super(context);
        }

        public double config_attack_damage_def() {
            return 3.0;
        }

        public double config_attack_speed_def() {
            return 3.0;
        }

        public int config_harvest_radius_def() {
            return 2;
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new SmithingRecipeDefinition("generic").base("vane_trifles:diamond_sickle").addition(Material.NETHERITE_INGOT).copy_nbt(true).result(this.key().toString())});
        }
    }
}

